/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeploymentAlarms
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeploymentAlarms> {
    private static final SdkField<List<String>> ALARM_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("alarmNames").getter(DeploymentAlarms.getter(DeploymentAlarms::alarmNames)).setter(DeploymentAlarms.setter(Builder::alarmNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ENABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enable").getter(DeploymentAlarms.getter(DeploymentAlarms::enable)).setter(DeploymentAlarms.setter(Builder::enable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enable").build()}).build();
    private static final SdkField<Boolean> ROLLBACK_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("rollback").getter(DeploymentAlarms.getter(DeploymentAlarms::rollback)).setter(DeploymentAlarms.setter(Builder::rollback)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rollback").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALARM_NAMES_FIELD, ENABLE_FIELD, ROLLBACK_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> alarmNames;
    private final Boolean enable;
    private final Boolean rollback;

    private DeploymentAlarms(BuilderImpl builder) {
        this.alarmNames = builder.alarmNames;
        this.enable = builder.enable;
        this.rollback = builder.rollback;
    }

    public final boolean hasAlarmNames() {
        return this.alarmNames != null && !(this.alarmNames instanceof SdkAutoConstructList);
    }

    public final List<String> alarmNames() {
        return this.alarmNames;
    }

    public final Boolean enable() {
        return this.enable;
    }

    public final Boolean rollback() {
        return this.rollback;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAlarmNames() ? this.alarmNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.enable());
        hashCode = 31 * hashCode + Objects.hashCode(this.rollback());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentAlarms)) {
            return false;
        }
        DeploymentAlarms other = (DeploymentAlarms)obj;
        return this.hasAlarmNames() == other.hasAlarmNames() && Objects.equals(this.alarmNames(), other.alarmNames()) && Objects.equals(this.enable(), other.enable()) && Objects.equals(this.rollback(), other.rollback());
    }

    public final String toString() {
        return ToString.builder((String)"DeploymentAlarms").add("AlarmNames", this.hasAlarmNames() ? this.alarmNames() : null).add("Enable", (Object)this.enable()).add("Rollback", (Object)this.rollback()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "alarmNames": {
                return Optional.ofNullable(clazz.cast(this.alarmNames()));
            }
            case "enable": {
                return Optional.ofNullable(clazz.cast(this.enable()));
            }
            case "rollback": {
                return Optional.ofNullable(clazz.cast(this.rollback()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeploymentAlarms, T> g) {
        return obj -> g.apply((DeploymentAlarms)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> alarmNames = DefaultSdkAutoConstructList.getInstance();
        private Boolean enable;
        private Boolean rollback;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentAlarms model) {
            this.alarmNames(model.alarmNames);
            this.enable(model.enable);
            this.rollback(model.rollback);
        }

        public final Collection<String> getAlarmNames() {
            if (this.alarmNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.alarmNames;
        }

        public final void setAlarmNames(Collection<String> alarmNames) {
            this.alarmNames = StringListCopier.copy(alarmNames);
        }

        @Override
        public final Builder alarmNames(Collection<String> alarmNames) {
            this.alarmNames = StringListCopier.copy(alarmNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmNames(String ... alarmNames) {
            this.alarmNames(Arrays.asList(alarmNames));
            return this;
        }

        public final Boolean getEnable() {
            return this.enable;
        }

        public final void setEnable(Boolean enable) {
            this.enable = enable;
        }

        @Override
        public final Builder enable(Boolean enable) {
            this.enable = enable;
            return this;
        }

        public final Boolean getRollback() {
            return this.rollback;
        }

        public final void setRollback(Boolean rollback) {
            this.rollback = rollback;
        }

        @Override
        public final Builder rollback(Boolean rollback) {
            this.rollback = rollback;
            return this;
        }

        public DeploymentAlarms build() {
            return new DeploymentAlarms(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeploymentAlarms> {
        public Builder alarmNames(Collection<String> var1);

        public Builder alarmNames(String ... var1);

        public Builder enable(Boolean var1);

        public Builder rollback(Boolean var1);
    }
}

