/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2instanceconnect;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ec2instanceconnect.DefaultEc2InstanceConnectBaseClientBuilder;
import software.amazon.awssdk.services.ec2instanceconnect.DefaultEc2InstanceConnectClient;
import software.amazon.awssdk.services.ec2instanceconnect.Ec2InstanceConnectClient;
import software.amazon.awssdk.services.ec2instanceconnect.Ec2InstanceConnectClientBuilder;
import software.amazon.awssdk.services.ec2instanceconnect.Ec2InstanceConnectServiceClientConfiguration;
import software.amazon.awssdk.services.ec2instanceconnect.endpoints.Ec2InstanceConnectEndpointProvider;

@SdkInternalApi
final class DefaultEc2InstanceConnectClientBuilder
extends DefaultEc2InstanceConnectBaseClientBuilder<Ec2InstanceConnectClientBuilder, Ec2InstanceConnectClient>
implements Ec2InstanceConnectClientBuilder {
    DefaultEc2InstanceConnectClientBuilder() {
    }

    @Override
    public DefaultEc2InstanceConnectClientBuilder endpointProvider(Ec2InstanceConnectEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final Ec2InstanceConnectClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultEc2InstanceConnectClientBuilder.validateClientOptions(clientConfiguration);
        Ec2InstanceConnectServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultEc2InstanceConnectClient client = new DefaultEc2InstanceConnectClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private Ec2InstanceConnectServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return Ec2InstanceConnectServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

