/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.VpnTunnelOptionsSpecification;
import software.amazon.awssdk.services.ec2.model.VpnTunnelOptionsSpecificationsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VpnConnectionOptionsSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VpnConnectionOptionsSpecification> {
    private static final SdkField<Boolean> STATIC_ROUTES_ONLY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(VpnConnectionOptionsSpecification.getter(VpnConnectionOptionsSpecification::staticRoutesOnly)).setter(VpnConnectionOptionsSpecification.setter(Builder::staticRoutesOnly)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StaticRoutesOnly").unmarshallLocationName("staticRoutesOnly").build()}).build();
    private static final SdkField<List<VpnTunnelOptionsSpecification>> TUNNEL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(VpnConnectionOptionsSpecification.getter(VpnConnectionOptionsSpecification::tunnelOptions)).setter(VpnConnectionOptionsSpecification.setter(Builder::tunnelOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TunnelOptions").unmarshallLocationName("TunnelOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VpnTunnelOptionsSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATIC_ROUTES_ONLY_FIELD, TUNNEL_OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean staticRoutesOnly;
    private final List<VpnTunnelOptionsSpecification> tunnelOptions;

    private VpnConnectionOptionsSpecification(BuilderImpl builder) {
        this.staticRoutesOnly = builder.staticRoutesOnly;
        this.tunnelOptions = builder.tunnelOptions;
    }

    public Boolean staticRoutesOnly() {
        return this.staticRoutesOnly;
    }

    public List<VpnTunnelOptionsSpecification> tunnelOptions() {
        return this.tunnelOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.staticRoutesOnly());
        hashCode = 31 * hashCode + Objects.hashCode(this.tunnelOptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpnConnectionOptionsSpecification)) {
            return false;
        }
        VpnConnectionOptionsSpecification other = (VpnConnectionOptionsSpecification)obj;
        return Objects.equals(this.staticRoutesOnly(), other.staticRoutesOnly()) && Objects.equals(this.tunnelOptions(), other.tunnelOptions());
    }

    public String toString() {
        return ToString.builder((String)"VpnConnectionOptionsSpecification").add("StaticRoutesOnly", (Object)this.staticRoutesOnly()).add("TunnelOptions", this.tunnelOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StaticRoutesOnly": {
                return Optional.ofNullable(clazz.cast(this.staticRoutesOnly()));
            }
            case "TunnelOptions": {
                return Optional.ofNullable(clazz.cast(this.tunnelOptions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VpnConnectionOptionsSpecification, T> g) {
        return obj -> g.apply((VpnConnectionOptionsSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean staticRoutesOnly;
        private List<VpnTunnelOptionsSpecification> tunnelOptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VpnConnectionOptionsSpecification model) {
            this.staticRoutesOnly(model.staticRoutesOnly);
            this.tunnelOptions(model.tunnelOptions);
        }

        public final Boolean getStaticRoutesOnly() {
            return this.staticRoutesOnly;
        }

        @Override
        public final Builder staticRoutesOnly(Boolean staticRoutesOnly) {
            this.staticRoutesOnly = staticRoutesOnly;
            return this;
        }

        public final void setStaticRoutesOnly(Boolean staticRoutesOnly) {
            this.staticRoutesOnly = staticRoutesOnly;
        }

        public final Collection<VpnTunnelOptionsSpecification.Builder> getTunnelOptions() {
            return this.tunnelOptions != null ? (Collection)this.tunnelOptions.stream().map(VpnTunnelOptionsSpecification::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tunnelOptions(Collection<VpnTunnelOptionsSpecification> tunnelOptions) {
            this.tunnelOptions = VpnTunnelOptionsSpecificationsListCopier.copy(tunnelOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tunnelOptions(VpnTunnelOptionsSpecification ... tunnelOptions) {
            this.tunnelOptions(Arrays.asList(tunnelOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tunnelOptions(Consumer<VpnTunnelOptionsSpecification.Builder> ... tunnelOptions) {
            this.tunnelOptions(Stream.of(tunnelOptions).map(c -> (VpnTunnelOptionsSpecification)((VpnTunnelOptionsSpecification.Builder)VpnTunnelOptionsSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTunnelOptions(Collection<VpnTunnelOptionsSpecification.BuilderImpl> tunnelOptions) {
            this.tunnelOptions = VpnTunnelOptionsSpecificationsListCopier.copyFromBuilder(tunnelOptions);
        }

        public VpnConnectionOptionsSpecification build() {
            return new VpnConnectionOptionsSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VpnConnectionOptionsSpecification> {
        public Builder staticRoutesOnly(Boolean var1);

        public Builder tunnelOptions(Collection<VpnTunnelOptionsSpecification> var1);

        public Builder tunnelOptions(VpnTunnelOptionsSpecification ... var1);

        public Builder tunnelOptions(Consumer<VpnTunnelOptionsSpecification.Builder> ... var1);
    }
}

