/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VolumeStatusEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VolumeStatusEvent> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VolumeStatusEvent.getter(VolumeStatusEvent::description)).setter(VolumeStatusEvent.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VolumeStatusEvent.getter(VolumeStatusEvent::eventId)).setter(VolumeStatusEvent.setter(Builder::eventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventId").unmarshallLocationName("eventId").build()}).build();
    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VolumeStatusEvent.getter(VolumeStatusEvent::eventType)).setter(VolumeStatusEvent.setter(Builder::eventType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventType").unmarshallLocationName("eventType").build()}).build();
    private static final SdkField<Instant> NOT_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(VolumeStatusEvent.getter(VolumeStatusEvent::notAfter)).setter(VolumeStatusEvent.setter(Builder::notAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotAfter").unmarshallLocationName("notAfter").build()}).build();
    private static final SdkField<Instant> NOT_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(VolumeStatusEvent.getter(VolumeStatusEvent::notBefore)).setter(VolumeStatusEvent.setter(Builder::notBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotBefore").unmarshallLocationName("notBefore").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, EVENT_ID_FIELD, EVENT_TYPE_FIELD, NOT_AFTER_FIELD, NOT_BEFORE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String description;
    private final String eventId;
    private final String eventType;
    private final Instant notAfter;
    private final Instant notBefore;

    private VolumeStatusEvent(BuilderImpl builder) {
        this.description = builder.description;
        this.eventId = builder.eventId;
        this.eventType = builder.eventType;
        this.notAfter = builder.notAfter;
        this.notBefore = builder.notBefore;
    }

    public String description() {
        return this.description;
    }

    public String eventId() {
        return this.eventId;
    }

    public String eventType() {
        return this.eventType;
    }

    public Instant notAfter() {
        return this.notAfter;
    }

    public Instant notBefore() {
        return this.notBefore;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventType());
        hashCode = 31 * hashCode + Objects.hashCode(this.notAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.notBefore());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeStatusEvent)) {
            return false;
        }
        VolumeStatusEvent other = (VolumeStatusEvent)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.eventId(), other.eventId()) && Objects.equals(this.eventType(), other.eventType()) && Objects.equals(this.notAfter(), other.notAfter()) && Objects.equals(this.notBefore(), other.notBefore());
    }

    public String toString() {
        return ToString.builder((String)"VolumeStatusEvent").add("Description", (Object)this.description()).add("EventId", (Object)this.eventId()).add("EventType", (Object)this.eventType()).add("NotAfter", (Object)this.notAfter()).add("NotBefore", (Object)this.notBefore()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "EventId": {
                return Optional.ofNullable(clazz.cast(this.eventId()));
            }
            case "EventType": {
                return Optional.ofNullable(clazz.cast(this.eventType()));
            }
            case "NotAfter": {
                return Optional.ofNullable(clazz.cast(this.notAfter()));
            }
            case "NotBefore": {
                return Optional.ofNullable(clazz.cast(this.notBefore()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VolumeStatusEvent, T> g) {
        return obj -> g.apply((VolumeStatusEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private String eventId;
        private String eventType;
        private Instant notAfter;
        private Instant notBefore;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeStatusEvent model) {
            this.description(model.description);
            this.eventId(model.eventId);
            this.eventType(model.eventType);
            this.notAfter(model.notAfter);
            this.notBefore(model.notBefore);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getEventId() {
            return this.eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        public final String getEventType() {
            return this.eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        public final Instant getNotAfter() {
            return this.notAfter;
        }

        @Override
        public final Builder notAfter(Instant notAfter) {
            this.notAfter = notAfter;
            return this;
        }

        public final void setNotAfter(Instant notAfter) {
            this.notAfter = notAfter;
        }

        public final Instant getNotBefore() {
            return this.notBefore;
        }

        @Override
        public final Builder notBefore(Instant notBefore) {
            this.notBefore = notBefore;
            return this;
        }

        public final void setNotBefore(Instant notBefore) {
            this.notBefore = notBefore;
        }

        public VolumeStatusEvent build() {
            return new VolumeStatusEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VolumeStatusEvent> {
        public Builder description(String var1);

        public Builder eventId(String var1);

        public Builder eventType(String var1);

        public Builder notAfter(Instant var1);

        public Builder notBefore(Instant var1);
    }
}

