/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.DnsSupportValue;
import software.amazon.awssdk.services.ec2.model.Ipv6SupportValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyTransitGatewayVpcAttachmentRequestOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModifyTransitGatewayVpcAttachmentRequestOptions> {
    private static final SdkField<String> DNS_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyTransitGatewayVpcAttachmentRequestOptions.getter(ModifyTransitGatewayVpcAttachmentRequestOptions::dnsSupportAsString)).setter(ModifyTransitGatewayVpcAttachmentRequestOptions.setter(Builder::dnsSupport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsSupport").unmarshallLocationName("DnsSupport").build()}).build();
    private static final SdkField<String> IPV6_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyTransitGatewayVpcAttachmentRequestOptions.getter(ModifyTransitGatewayVpcAttachmentRequestOptions::ipv6SupportAsString)).setter(ModifyTransitGatewayVpcAttachmentRequestOptions.setter(Builder::ipv6Support)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Support").unmarshallLocationName("Ipv6Support").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DNS_SUPPORT_FIELD, IPV6_SUPPORT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String dnsSupport;
    private final String ipv6Support;

    private ModifyTransitGatewayVpcAttachmentRequestOptions(BuilderImpl builder) {
        this.dnsSupport = builder.dnsSupport;
        this.ipv6Support = builder.ipv6Support;
    }

    public DnsSupportValue dnsSupport() {
        return DnsSupportValue.fromValue(this.dnsSupport);
    }

    public String dnsSupportAsString() {
        return this.dnsSupport;
    }

    public Ipv6SupportValue ipv6Support() {
        return Ipv6SupportValue.fromValue(this.ipv6Support);
    }

    public String ipv6SupportAsString() {
        return this.ipv6Support;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsSupportAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6SupportAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyTransitGatewayVpcAttachmentRequestOptions)) {
            return false;
        }
        ModifyTransitGatewayVpcAttachmentRequestOptions other = (ModifyTransitGatewayVpcAttachmentRequestOptions)obj;
        return Objects.equals(this.dnsSupportAsString(), other.dnsSupportAsString()) && Objects.equals(this.ipv6SupportAsString(), other.ipv6SupportAsString());
    }

    public String toString() {
        return ToString.builder((String)"ModifyTransitGatewayVpcAttachmentRequestOptions").add("DnsSupport", (Object)this.dnsSupportAsString()).add("Ipv6Support", (Object)this.ipv6SupportAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DnsSupport": {
                return Optional.ofNullable(clazz.cast(this.dnsSupportAsString()));
            }
            case "Ipv6Support": {
                return Optional.ofNullable(clazz.cast(this.ipv6SupportAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyTransitGatewayVpcAttachmentRequestOptions, T> g) {
        return obj -> g.apply((ModifyTransitGatewayVpcAttachmentRequestOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dnsSupport;
        private String ipv6Support;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyTransitGatewayVpcAttachmentRequestOptions model) {
            this.dnsSupport(model.dnsSupport);
            this.ipv6Support(model.ipv6Support);
        }

        public final String getDnsSupportAsString() {
            return this.dnsSupport;
        }

        @Override
        public final Builder dnsSupport(String dnsSupport) {
            this.dnsSupport = dnsSupport;
            return this;
        }

        @Override
        public final Builder dnsSupport(DnsSupportValue dnsSupport) {
            this.dnsSupport(dnsSupport == null ? null : dnsSupport.toString());
            return this;
        }

        public final void setDnsSupport(String dnsSupport) {
            this.dnsSupport = dnsSupport;
        }

        public final String getIpv6SupportAsString() {
            return this.ipv6Support;
        }

        @Override
        public final Builder ipv6Support(String ipv6Support) {
            this.ipv6Support = ipv6Support;
            return this;
        }

        @Override
        public final Builder ipv6Support(Ipv6SupportValue ipv6Support) {
            this.ipv6Support(ipv6Support == null ? null : ipv6Support.toString());
            return this;
        }

        public final void setIpv6Support(String ipv6Support) {
            this.ipv6Support = ipv6Support;
        }

        public ModifyTransitGatewayVpcAttachmentRequestOptions build() {
            return new ModifyTransitGatewayVpcAttachmentRequestOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModifyTransitGatewayVpcAttachmentRequestOptions> {
        public Builder dnsSupport(String var1);

        public Builder dnsSupport(DnsSupportValue var1);

        public Builder ipv6Support(String var1);

        public Builder ipv6Support(Ipv6SupportValue var1);
    }
}

