/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.NetworkAcl;
import software.amazon.awssdk.services.ec2.model.NetworkAclListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeNetworkAclsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeNetworkAclsResponse> {
    private static final SdkField<List<NetworkAcl>> NETWORK_ACLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeNetworkAclsResponse.getter(DescribeNetworkAclsResponse::networkAcls)).setter(DescribeNetworkAclsResponse.setter(Builder::networkAcls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkAclSet").unmarshallLocationName("networkAclSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NetworkAcl::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeNetworkAclsResponse.getter(DescribeNetworkAclsResponse::nextToken)).setter(DescribeNetworkAclsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_ACLS_FIELD, NEXT_TOKEN_FIELD));
    private final List<NetworkAcl> networkAcls;
    private final String nextToken;

    private DescribeNetworkAclsResponse(BuilderImpl builder) {
        super(builder);
        this.networkAcls = builder.networkAcls;
        this.nextToken = builder.nextToken;
    }

    public List<NetworkAcl> networkAcls() {
        return this.networkAcls;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.networkAcls());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNetworkAclsResponse)) {
            return false;
        }
        DescribeNetworkAclsResponse other = (DescribeNetworkAclsResponse)((Object)obj);
        return Objects.equals(this.networkAcls(), other.networkAcls()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeNetworkAclsResponse").add("NetworkAcls", this.networkAcls()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkAcls": {
                return Optional.ofNullable(clazz.cast(this.networkAcls()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeNetworkAclsResponse, T> g) {
        return obj -> g.apply((DescribeNetworkAclsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<NetworkAcl> networkAcls = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNetworkAclsResponse model) {
            super(model);
            this.networkAcls(model.networkAcls);
            this.nextToken(model.nextToken);
        }

        public final Collection<NetworkAcl.Builder> getNetworkAcls() {
            return this.networkAcls != null ? (Collection)this.networkAcls.stream().map(NetworkAcl::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder networkAcls(Collection<NetworkAcl> networkAcls) {
            this.networkAcls = NetworkAclListCopier.copy(networkAcls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkAcls(NetworkAcl ... networkAcls) {
            this.networkAcls(Arrays.asList(networkAcls));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkAcls(Consumer<NetworkAcl.Builder> ... networkAcls) {
            this.networkAcls(Stream.of(networkAcls).map(c -> (NetworkAcl)((NetworkAcl.Builder)NetworkAcl.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNetworkAcls(Collection<NetworkAcl.BuilderImpl> networkAcls) {
            this.networkAcls = NetworkAclListCopier.copyFromBuilder(networkAcls);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeNetworkAclsResponse build() {
            return new DescribeNetworkAclsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeNetworkAclsResponse> {
        public Builder networkAcls(Collection<NetworkAcl> var1);

        public Builder networkAcls(NetworkAcl ... var1);

        public Builder networkAcls(Consumer<NetworkAcl.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

