/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.DiskImageFormat;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.ExportTaskS3Location;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportImageResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, ExportImageResponse> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ExportImageResponse.getter(ExportImageResponse::description)).setter(ExportImageResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<String> DISK_IMAGE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ExportImageResponse.getter(ExportImageResponse::diskImageFormatAsString)).setter(ExportImageResponse.setter(Builder::diskImageFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskImageFormat").unmarshallLocationName("diskImageFormat").build()}).build();
    private static final SdkField<String> EXPORT_IMAGE_TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ExportImageResponse.getter(ExportImageResponse::exportImageTaskId)).setter(ExportImageResponse.setter(Builder::exportImageTaskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportImageTaskId").unmarshallLocationName("exportImageTaskId").build()}).build();
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ExportImageResponse.getter(ExportImageResponse::imageId)).setter(ExportImageResponse.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").unmarshallLocationName("imageId").build()}).build();
    private static final SdkField<String> ROLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ExportImageResponse.getter(ExportImageResponse::roleName)).setter(ExportImageResponse.setter(Builder::roleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleName").unmarshallLocationName("roleName").build()}).build();
    private static final SdkField<String> PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ExportImageResponse.getter(ExportImageResponse::progress)).setter(ExportImageResponse.setter(Builder::progress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Progress").unmarshallLocationName("progress").build()}).build();
    private static final SdkField<ExportTaskS3Location> S3_EXPORT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ExportImageResponse.getter(ExportImageResponse::s3ExportLocation)).setter(ExportImageResponse.setter(Builder::s3ExportLocation)).constructor(ExportTaskS3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3ExportLocation").unmarshallLocationName("s3ExportLocation").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ExportImageResponse.getter(ExportImageResponse::status)).setter(ExportImageResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ExportImageResponse.getter(ExportImageResponse::statusMessage)).setter(ExportImageResponse.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").unmarshallLocationName("statusMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, DISK_IMAGE_FORMAT_FIELD, EXPORT_IMAGE_TASK_ID_FIELD, IMAGE_ID_FIELD, ROLE_NAME_FIELD, PROGRESS_FIELD, S3_EXPORT_LOCATION_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD));
    private final String description;
    private final String diskImageFormat;
    private final String exportImageTaskId;
    private final String imageId;
    private final String roleName;
    private final String progress;
    private final ExportTaskS3Location s3ExportLocation;
    private final String status;
    private final String statusMessage;

    private ExportImageResponse(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.diskImageFormat = builder.diskImageFormat;
        this.exportImageTaskId = builder.exportImageTaskId;
        this.imageId = builder.imageId;
        this.roleName = builder.roleName;
        this.progress = builder.progress;
        this.s3ExportLocation = builder.s3ExportLocation;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
    }

    public String description() {
        return this.description;
    }

    public DiskImageFormat diskImageFormat() {
        return DiskImageFormat.fromValue(this.diskImageFormat);
    }

    public String diskImageFormatAsString() {
        return this.diskImageFormat;
    }

    public String exportImageTaskId() {
        return this.exportImageTaskId;
    }

    public String imageId() {
        return this.imageId;
    }

    public String roleName() {
        return this.roleName;
    }

    public String progress() {
        return this.progress;
    }

    public ExportTaskS3Location s3ExportLocation() {
        return this.s3ExportLocation;
    }

    public String status() {
        return this.status;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.diskImageFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportImageTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.progress());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3ExportLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportImageResponse)) {
            return false;
        }
        ExportImageResponse other = (ExportImageResponse)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.diskImageFormatAsString(), other.diskImageFormatAsString()) && Objects.equals(this.exportImageTaskId(), other.exportImageTaskId()) && Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.roleName(), other.roleName()) && Objects.equals(this.progress(), other.progress()) && Objects.equals(this.s3ExportLocation(), other.s3ExportLocation()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.statusMessage(), other.statusMessage());
    }

    public String toString() {
        return ToString.builder((String)"ExportImageResponse").add("Description", (Object)this.description()).add("DiskImageFormat", (Object)this.diskImageFormatAsString()).add("ExportImageTaskId", (Object)this.exportImageTaskId()).add("ImageId", (Object)this.imageId()).add("RoleName", (Object)this.roleName()).add("Progress", (Object)this.progress()).add("S3ExportLocation", (Object)this.s3ExportLocation()).add("Status", (Object)this.status()).add("StatusMessage", (Object)this.statusMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DiskImageFormat": {
                return Optional.ofNullable(clazz.cast(this.diskImageFormatAsString()));
            }
            case "ExportImageTaskId": {
                return Optional.ofNullable(clazz.cast(this.exportImageTaskId()));
            }
            case "ImageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "RoleName": {
                return Optional.ofNullable(clazz.cast(this.roleName()));
            }
            case "Progress": {
                return Optional.ofNullable(clazz.cast(this.progress()));
            }
            case "S3ExportLocation": {
                return Optional.ofNullable(clazz.cast(this.s3ExportLocation()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportImageResponse, T> g) {
        return obj -> g.apply((ExportImageResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String description;
        private String diskImageFormat;
        private String exportImageTaskId;
        private String imageId;
        private String roleName;
        private String progress;
        private ExportTaskS3Location s3ExportLocation;
        private String status;
        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportImageResponse model) {
            super(model);
            this.description(model.description);
            this.diskImageFormat(model.diskImageFormat);
            this.exportImageTaskId(model.exportImageTaskId);
            this.imageId(model.imageId);
            this.roleName(model.roleName);
            this.progress(model.progress);
            this.s3ExportLocation(model.s3ExportLocation);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDiskImageFormatAsString() {
            return this.diskImageFormat;
        }

        @Override
        public final Builder diskImageFormat(String diskImageFormat) {
            this.diskImageFormat = diskImageFormat;
            return this;
        }

        @Override
        public final Builder diskImageFormat(DiskImageFormat diskImageFormat) {
            this.diskImageFormat(diskImageFormat == null ? null : diskImageFormat.toString());
            return this;
        }

        public final void setDiskImageFormat(String diskImageFormat) {
            this.diskImageFormat = diskImageFormat;
        }

        public final String getExportImageTaskId() {
            return this.exportImageTaskId;
        }

        @Override
        public final Builder exportImageTaskId(String exportImageTaskId) {
            this.exportImageTaskId = exportImageTaskId;
            return this;
        }

        public final void setExportImageTaskId(String exportImageTaskId) {
            this.exportImageTaskId = exportImageTaskId;
        }

        public final String getImageId() {
            return this.imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final String getRoleName() {
            return this.roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        public final String getProgress() {
            return this.progress;
        }

        @Override
        public final Builder progress(String progress) {
            this.progress = progress;
            return this;
        }

        public final void setProgress(String progress) {
            this.progress = progress;
        }

        public final ExportTaskS3Location.Builder getS3ExportLocation() {
            return this.s3ExportLocation != null ? this.s3ExportLocation.toBuilder() : null;
        }

        @Override
        public final Builder s3ExportLocation(ExportTaskS3Location s3ExportLocation) {
            this.s3ExportLocation = s3ExportLocation;
            return this;
        }

        public final void setS3ExportLocation(ExportTaskS3Location.BuilderImpl s3ExportLocation) {
            this.s3ExportLocation = s3ExportLocation != null ? s3ExportLocation.build() : null;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public ExportImageResponse build() {
            return new ExportImageResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ExportImageResponse> {
        public Builder description(String var1);

        public Builder diskImageFormat(String var1);

        public Builder diskImageFormat(DiskImageFormat var1);

        public Builder exportImageTaskId(String var1);

        public Builder imageId(String var1);

        public Builder roleName(String var1);

        public Builder progress(String var1);

        public Builder s3ExportLocation(ExportTaskS3Location var1);

        default public Builder s3ExportLocation(Consumer<ExportTaskS3Location.Builder> s3ExportLocation) {
            return this.s3ExportLocation((ExportTaskS3Location)((ExportTaskS3Location.Builder)ExportTaskS3Location.builder().applyMutation(s3ExportLocation)).build());
        }

        public Builder status(String var1);

        public Builder statusMessage(String var1);
    }
}

