/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.InternetGatewayAttachment;
import software.amazon.awssdk.services.ec2.model.InternetGatewayAttachmentListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EgressOnlyInternetGateway
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EgressOnlyInternetGateway> {
    private static final SdkField<List<InternetGatewayAttachment>> ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(EgressOnlyInternetGateway.getter(EgressOnlyInternetGateway::attachments)).setter(EgressOnlyInternetGateway.setter(Builder::attachments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentSet").unmarshallLocationName("attachmentSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InternetGatewayAttachment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> EGRESS_ONLY_INTERNET_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EgressOnlyInternetGateway.getter(EgressOnlyInternetGateway::egressOnlyInternetGatewayId)).setter(EgressOnlyInternetGateway.setter(Builder::egressOnlyInternetGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EgressOnlyInternetGatewayId").unmarshallLocationName("egressOnlyInternetGatewayId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENTS_FIELD, EGRESS_ONLY_INTERNET_GATEWAY_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<InternetGatewayAttachment> attachments;
    private final String egressOnlyInternetGatewayId;

    private EgressOnlyInternetGateway(BuilderImpl builder) {
        this.attachments = builder.attachments;
        this.egressOnlyInternetGatewayId = builder.egressOnlyInternetGatewayId;
    }

    public List<InternetGatewayAttachment> attachments() {
        return this.attachments;
    }

    public String egressOnlyInternetGatewayId() {
        return this.egressOnlyInternetGatewayId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attachments());
        hashCode = 31 * hashCode + Objects.hashCode(this.egressOnlyInternetGatewayId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EgressOnlyInternetGateway)) {
            return false;
        }
        EgressOnlyInternetGateway other = (EgressOnlyInternetGateway)obj;
        return Objects.equals(this.attachments(), other.attachments()) && Objects.equals(this.egressOnlyInternetGatewayId(), other.egressOnlyInternetGatewayId());
    }

    public String toString() {
        return ToString.builder((String)"EgressOnlyInternetGateway").add("Attachments", this.attachments()).add("EgressOnlyInternetGatewayId", (Object)this.egressOnlyInternetGatewayId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attachments": {
                return Optional.ofNullable(clazz.cast(this.attachments()));
            }
            case "EgressOnlyInternetGatewayId": {
                return Optional.ofNullable(clazz.cast(this.egressOnlyInternetGatewayId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EgressOnlyInternetGateway, T> g) {
        return obj -> g.apply((EgressOnlyInternetGateway)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<InternetGatewayAttachment> attachments = DefaultSdkAutoConstructList.getInstance();
        private String egressOnlyInternetGatewayId;

        private BuilderImpl() {
        }

        private BuilderImpl(EgressOnlyInternetGateway model) {
            this.attachments(model.attachments);
            this.egressOnlyInternetGatewayId(model.egressOnlyInternetGatewayId);
        }

        public final Collection<InternetGatewayAttachment.Builder> getAttachments() {
            return this.attachments != null ? (Collection)this.attachments.stream().map(InternetGatewayAttachment::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attachments(Collection<InternetGatewayAttachment> attachments) {
            this.attachments = InternetGatewayAttachmentListCopier.copy(attachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(InternetGatewayAttachment ... attachments) {
            this.attachments(Arrays.asList(attachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(Consumer<InternetGatewayAttachment.Builder> ... attachments) {
            this.attachments(Stream.of(attachments).map(c -> (InternetGatewayAttachment)((InternetGatewayAttachment.Builder)InternetGatewayAttachment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttachments(Collection<InternetGatewayAttachment.BuilderImpl> attachments) {
            this.attachments = InternetGatewayAttachmentListCopier.copyFromBuilder(attachments);
        }

        public final String getEgressOnlyInternetGatewayId() {
            return this.egressOnlyInternetGatewayId;
        }

        @Override
        public final Builder egressOnlyInternetGatewayId(String egressOnlyInternetGatewayId) {
            this.egressOnlyInternetGatewayId = egressOnlyInternetGatewayId;
            return this;
        }

        public final void setEgressOnlyInternetGatewayId(String egressOnlyInternetGatewayId) {
            this.egressOnlyInternetGatewayId = egressOnlyInternetGatewayId;
        }

        public EgressOnlyInternetGateway build() {
            return new EgressOnlyInternetGateway(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EgressOnlyInternetGateway> {
        public Builder attachments(Collection<InternetGatewayAttachment> var1);

        public Builder attachments(InternetGatewayAttachment ... var1);

        public Builder attachments(Consumer<InternetGatewayAttachment.Builder> ... var1);

        public Builder egressOnlyInternetGatewayId(String var1);
    }
}

