/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.AutoAcceptSharedAttachmentsValue;
import software.amazon.awssdk.services.ec2.model.DefaultRouteTableAssociationValue;
import software.amazon.awssdk.services.ec2.model.DefaultRouteTablePropagationValue;
import software.amazon.awssdk.services.ec2.model.DnsSupportValue;
import software.amazon.awssdk.services.ec2.model.VpnEcmpSupportValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransitGatewayOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransitGatewayOptions> {
    private static final SdkField<Long> AMAZON_SIDE_ASN_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(TransitGatewayOptions.getter(TransitGatewayOptions::amazonSideAsn)).setter(TransitGatewayOptions.setter(Builder::amazonSideAsn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmazonSideAsn").unmarshallLocationName("amazonSideAsn").build()}).build();
    private static final SdkField<String> AUTO_ACCEPT_SHARED_ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TransitGatewayOptions.getter(TransitGatewayOptions::autoAcceptSharedAttachmentsAsString)).setter(TransitGatewayOptions.setter(Builder::autoAcceptSharedAttachments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoAcceptSharedAttachments").unmarshallLocationName("autoAcceptSharedAttachments").build()}).build();
    private static final SdkField<String> DEFAULT_ROUTE_TABLE_ASSOCIATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TransitGatewayOptions.getter(TransitGatewayOptions::defaultRouteTableAssociationAsString)).setter(TransitGatewayOptions.setter(Builder::defaultRouteTableAssociation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRouteTableAssociation").unmarshallLocationName("defaultRouteTableAssociation").build()}).build();
    private static final SdkField<String> ASSOCIATION_DEFAULT_ROUTE_TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TransitGatewayOptions.getter(TransitGatewayOptions::associationDefaultRouteTableId)).setter(TransitGatewayOptions.setter(Builder::associationDefaultRouteTableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationDefaultRouteTableId").unmarshallLocationName("associationDefaultRouteTableId").build()}).build();
    private static final SdkField<String> DEFAULT_ROUTE_TABLE_PROPAGATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TransitGatewayOptions.getter(TransitGatewayOptions::defaultRouteTablePropagationAsString)).setter(TransitGatewayOptions.setter(Builder::defaultRouteTablePropagation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRouteTablePropagation").unmarshallLocationName("defaultRouteTablePropagation").build()}).build();
    private static final SdkField<String> PROPAGATION_DEFAULT_ROUTE_TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TransitGatewayOptions.getter(TransitGatewayOptions::propagationDefaultRouteTableId)).setter(TransitGatewayOptions.setter(Builder::propagationDefaultRouteTableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropagationDefaultRouteTableId").unmarshallLocationName("propagationDefaultRouteTableId").build()}).build();
    private static final SdkField<String> VPN_ECMP_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TransitGatewayOptions.getter(TransitGatewayOptions::vpnEcmpSupportAsString)).setter(TransitGatewayOptions.setter(Builder::vpnEcmpSupport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnEcmpSupport").unmarshallLocationName("vpnEcmpSupport").build()}).build();
    private static final SdkField<String> DNS_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TransitGatewayOptions.getter(TransitGatewayOptions::dnsSupportAsString)).setter(TransitGatewayOptions.setter(Builder::dnsSupport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsSupport").unmarshallLocationName("dnsSupport").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMAZON_SIDE_ASN_FIELD, AUTO_ACCEPT_SHARED_ATTACHMENTS_FIELD, DEFAULT_ROUTE_TABLE_ASSOCIATION_FIELD, ASSOCIATION_DEFAULT_ROUTE_TABLE_ID_FIELD, DEFAULT_ROUTE_TABLE_PROPAGATION_FIELD, PROPAGATION_DEFAULT_ROUTE_TABLE_ID_FIELD, VPN_ECMP_SUPPORT_FIELD, DNS_SUPPORT_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long amazonSideAsn;
    private final String autoAcceptSharedAttachments;
    private final String defaultRouteTableAssociation;
    private final String associationDefaultRouteTableId;
    private final String defaultRouteTablePropagation;
    private final String propagationDefaultRouteTableId;
    private final String vpnEcmpSupport;
    private final String dnsSupport;

    private TransitGatewayOptions(BuilderImpl builder) {
        this.amazonSideAsn = builder.amazonSideAsn;
        this.autoAcceptSharedAttachments = builder.autoAcceptSharedAttachments;
        this.defaultRouteTableAssociation = builder.defaultRouteTableAssociation;
        this.associationDefaultRouteTableId = builder.associationDefaultRouteTableId;
        this.defaultRouteTablePropagation = builder.defaultRouteTablePropagation;
        this.propagationDefaultRouteTableId = builder.propagationDefaultRouteTableId;
        this.vpnEcmpSupport = builder.vpnEcmpSupport;
        this.dnsSupport = builder.dnsSupport;
    }

    public Long amazonSideAsn() {
        return this.amazonSideAsn;
    }

    public AutoAcceptSharedAttachmentsValue autoAcceptSharedAttachments() {
        return AutoAcceptSharedAttachmentsValue.fromValue(this.autoAcceptSharedAttachments);
    }

    public String autoAcceptSharedAttachmentsAsString() {
        return this.autoAcceptSharedAttachments;
    }

    public DefaultRouteTableAssociationValue defaultRouteTableAssociation() {
        return DefaultRouteTableAssociationValue.fromValue(this.defaultRouteTableAssociation);
    }

    public String defaultRouteTableAssociationAsString() {
        return this.defaultRouteTableAssociation;
    }

    public String associationDefaultRouteTableId() {
        return this.associationDefaultRouteTableId;
    }

    public DefaultRouteTablePropagationValue defaultRouteTablePropagation() {
        return DefaultRouteTablePropagationValue.fromValue(this.defaultRouteTablePropagation);
    }

    public String defaultRouteTablePropagationAsString() {
        return this.defaultRouteTablePropagation;
    }

    public String propagationDefaultRouteTableId() {
        return this.propagationDefaultRouteTableId;
    }

    public VpnEcmpSupportValue vpnEcmpSupport() {
        return VpnEcmpSupportValue.fromValue(this.vpnEcmpSupport);
    }

    public String vpnEcmpSupportAsString() {
        return this.vpnEcmpSupport;
    }

    public DnsSupportValue dnsSupport() {
        return DnsSupportValue.fromValue(this.dnsSupport);
    }

    public String dnsSupportAsString() {
        return this.dnsSupport;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.amazonSideAsn());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoAcceptSharedAttachmentsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultRouteTableAssociationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationDefaultRouteTableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultRouteTablePropagationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.propagationDefaultRouteTableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpnEcmpSupportAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsSupportAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayOptions)) {
            return false;
        }
        TransitGatewayOptions other = (TransitGatewayOptions)obj;
        return Objects.equals(this.amazonSideAsn(), other.amazonSideAsn()) && Objects.equals(this.autoAcceptSharedAttachmentsAsString(), other.autoAcceptSharedAttachmentsAsString()) && Objects.equals(this.defaultRouteTableAssociationAsString(), other.defaultRouteTableAssociationAsString()) && Objects.equals(this.associationDefaultRouteTableId(), other.associationDefaultRouteTableId()) && Objects.equals(this.defaultRouteTablePropagationAsString(), other.defaultRouteTablePropagationAsString()) && Objects.equals(this.propagationDefaultRouteTableId(), other.propagationDefaultRouteTableId()) && Objects.equals(this.vpnEcmpSupportAsString(), other.vpnEcmpSupportAsString()) && Objects.equals(this.dnsSupportAsString(), other.dnsSupportAsString());
    }

    public String toString() {
        return ToString.builder((String)"TransitGatewayOptions").add("AmazonSideAsn", (Object)this.amazonSideAsn()).add("AutoAcceptSharedAttachments", (Object)this.autoAcceptSharedAttachmentsAsString()).add("DefaultRouteTableAssociation", (Object)this.defaultRouteTableAssociationAsString()).add("AssociationDefaultRouteTableId", (Object)this.associationDefaultRouteTableId()).add("DefaultRouteTablePropagation", (Object)this.defaultRouteTablePropagationAsString()).add("PropagationDefaultRouteTableId", (Object)this.propagationDefaultRouteTableId()).add("VpnEcmpSupport", (Object)this.vpnEcmpSupportAsString()).add("DnsSupport", (Object)this.dnsSupportAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AmazonSideAsn": {
                return Optional.ofNullable(clazz.cast(this.amazonSideAsn()));
            }
            case "AutoAcceptSharedAttachments": {
                return Optional.ofNullable(clazz.cast(this.autoAcceptSharedAttachmentsAsString()));
            }
            case "DefaultRouteTableAssociation": {
                return Optional.ofNullable(clazz.cast(this.defaultRouteTableAssociationAsString()));
            }
            case "AssociationDefaultRouteTableId": {
                return Optional.ofNullable(clazz.cast(this.associationDefaultRouteTableId()));
            }
            case "DefaultRouteTablePropagation": {
                return Optional.ofNullable(clazz.cast(this.defaultRouteTablePropagationAsString()));
            }
            case "PropagationDefaultRouteTableId": {
                return Optional.ofNullable(clazz.cast(this.propagationDefaultRouteTableId()));
            }
            case "VpnEcmpSupport": {
                return Optional.ofNullable(clazz.cast(this.vpnEcmpSupportAsString()));
            }
            case "DnsSupport": {
                return Optional.ofNullable(clazz.cast(this.dnsSupportAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayOptions, T> g) {
        return obj -> g.apply((TransitGatewayOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long amazonSideAsn;
        private String autoAcceptSharedAttachments;
        private String defaultRouteTableAssociation;
        private String associationDefaultRouteTableId;
        private String defaultRouteTablePropagation;
        private String propagationDefaultRouteTableId;
        private String vpnEcmpSupport;
        private String dnsSupport;

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayOptions model) {
            this.amazonSideAsn(model.amazonSideAsn);
            this.autoAcceptSharedAttachments(model.autoAcceptSharedAttachments);
            this.defaultRouteTableAssociation(model.defaultRouteTableAssociation);
            this.associationDefaultRouteTableId(model.associationDefaultRouteTableId);
            this.defaultRouteTablePropagation(model.defaultRouteTablePropagation);
            this.propagationDefaultRouteTableId(model.propagationDefaultRouteTableId);
            this.vpnEcmpSupport(model.vpnEcmpSupport);
            this.dnsSupport(model.dnsSupport);
        }

        public final Long getAmazonSideAsn() {
            return this.amazonSideAsn;
        }

        @Override
        public final Builder amazonSideAsn(Long amazonSideAsn) {
            this.amazonSideAsn = amazonSideAsn;
            return this;
        }

        public final void setAmazonSideAsn(Long amazonSideAsn) {
            this.amazonSideAsn = amazonSideAsn;
        }

        public final String getAutoAcceptSharedAttachmentsAsString() {
            return this.autoAcceptSharedAttachments;
        }

        @Override
        public final Builder autoAcceptSharedAttachments(String autoAcceptSharedAttachments) {
            this.autoAcceptSharedAttachments = autoAcceptSharedAttachments;
            return this;
        }

        @Override
        public final Builder autoAcceptSharedAttachments(AutoAcceptSharedAttachmentsValue autoAcceptSharedAttachments) {
            this.autoAcceptSharedAttachments(autoAcceptSharedAttachments.toString());
            return this;
        }

        public final void setAutoAcceptSharedAttachments(String autoAcceptSharedAttachments) {
            this.autoAcceptSharedAttachments = autoAcceptSharedAttachments;
        }

        public final String getDefaultRouteTableAssociationAsString() {
            return this.defaultRouteTableAssociation;
        }

        @Override
        public final Builder defaultRouteTableAssociation(String defaultRouteTableAssociation) {
            this.defaultRouteTableAssociation = defaultRouteTableAssociation;
            return this;
        }

        @Override
        public final Builder defaultRouteTableAssociation(DefaultRouteTableAssociationValue defaultRouteTableAssociation) {
            this.defaultRouteTableAssociation(defaultRouteTableAssociation.toString());
            return this;
        }

        public final void setDefaultRouteTableAssociation(String defaultRouteTableAssociation) {
            this.defaultRouteTableAssociation = defaultRouteTableAssociation;
        }

        public final String getAssociationDefaultRouteTableId() {
            return this.associationDefaultRouteTableId;
        }

        @Override
        public final Builder associationDefaultRouteTableId(String associationDefaultRouteTableId) {
            this.associationDefaultRouteTableId = associationDefaultRouteTableId;
            return this;
        }

        public final void setAssociationDefaultRouteTableId(String associationDefaultRouteTableId) {
            this.associationDefaultRouteTableId = associationDefaultRouteTableId;
        }

        public final String getDefaultRouteTablePropagationAsString() {
            return this.defaultRouteTablePropagation;
        }

        @Override
        public final Builder defaultRouteTablePropagation(String defaultRouteTablePropagation) {
            this.defaultRouteTablePropagation = defaultRouteTablePropagation;
            return this;
        }

        @Override
        public final Builder defaultRouteTablePropagation(DefaultRouteTablePropagationValue defaultRouteTablePropagation) {
            this.defaultRouteTablePropagation(defaultRouteTablePropagation.toString());
            return this;
        }

        public final void setDefaultRouteTablePropagation(String defaultRouteTablePropagation) {
            this.defaultRouteTablePropagation = defaultRouteTablePropagation;
        }

        public final String getPropagationDefaultRouteTableId() {
            return this.propagationDefaultRouteTableId;
        }

        @Override
        public final Builder propagationDefaultRouteTableId(String propagationDefaultRouteTableId) {
            this.propagationDefaultRouteTableId = propagationDefaultRouteTableId;
            return this;
        }

        public final void setPropagationDefaultRouteTableId(String propagationDefaultRouteTableId) {
            this.propagationDefaultRouteTableId = propagationDefaultRouteTableId;
        }

        public final String getVpnEcmpSupportAsString() {
            return this.vpnEcmpSupport;
        }

        @Override
        public final Builder vpnEcmpSupport(String vpnEcmpSupport) {
            this.vpnEcmpSupport = vpnEcmpSupport;
            return this;
        }

        @Override
        public final Builder vpnEcmpSupport(VpnEcmpSupportValue vpnEcmpSupport) {
            this.vpnEcmpSupport(vpnEcmpSupport.toString());
            return this;
        }

        public final void setVpnEcmpSupport(String vpnEcmpSupport) {
            this.vpnEcmpSupport = vpnEcmpSupport;
        }

        public final String getDnsSupportAsString() {
            return this.dnsSupport;
        }

        @Override
        public final Builder dnsSupport(String dnsSupport) {
            this.dnsSupport = dnsSupport;
            return this;
        }

        @Override
        public final Builder dnsSupport(DnsSupportValue dnsSupport) {
            this.dnsSupport(dnsSupport.toString());
            return this;
        }

        public final void setDnsSupport(String dnsSupport) {
            this.dnsSupport = dnsSupport;
        }

        public TransitGatewayOptions build() {
            return new TransitGatewayOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransitGatewayOptions> {
        public Builder amazonSideAsn(Long var1);

        public Builder autoAcceptSharedAttachments(String var1);

        public Builder autoAcceptSharedAttachments(AutoAcceptSharedAttachmentsValue var1);

        public Builder defaultRouteTableAssociation(String var1);

        public Builder defaultRouteTableAssociation(DefaultRouteTableAssociationValue var1);

        public Builder associationDefaultRouteTableId(String var1);

        public Builder defaultRouteTablePropagation(String var1);

        public Builder defaultRouteTablePropagation(DefaultRouteTablePropagationValue var1);

        public Builder propagationDefaultRouteTableId(String var1);

        public Builder vpnEcmpSupport(String var1);

        public Builder vpnEcmpSupport(VpnEcmpSupportValue var1);

        public Builder dnsSupport(String var1);

        public Builder dnsSupport(DnsSupportValue var1);
    }
}

