/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.Scope;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReservedInstancesConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReservedInstancesConfiguration> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReservedInstancesConfiguration.getter(ReservedInstancesConfiguration::availabilityZone)).setter(ReservedInstancesConfiguration.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").unmarshallLocationName("availabilityZone").build()}).build();
    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ReservedInstancesConfiguration.getter(ReservedInstancesConfiguration::instanceCount)).setter(ReservedInstancesConfiguration.setter(Builder::instanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").unmarshallLocationName("instanceCount").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReservedInstancesConfiguration.getter(ReservedInstancesConfiguration::instanceTypeAsString)).setter(ReservedInstancesConfiguration.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").unmarshallLocationName("instanceType").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReservedInstancesConfiguration.getter(ReservedInstancesConfiguration::platform)).setter(ReservedInstancesConfiguration.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform").unmarshallLocationName("platform").build()}).build();
    private static final SdkField<String> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReservedInstancesConfiguration.getter(ReservedInstancesConfiguration::scopeAsString)).setter(ReservedInstancesConfiguration.setter(Builder::scope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").unmarshallLocationName("scope").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD, INSTANCE_COUNT_FIELD, INSTANCE_TYPE_FIELD, PLATFORM_FIELD, SCOPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String availabilityZone;
    private final Integer instanceCount;
    private final String instanceType;
    private final String platform;
    private final String scope;

    private ReservedInstancesConfiguration(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.instanceCount = builder.instanceCount;
        this.instanceType = builder.instanceType;
        this.platform = builder.platform;
        this.scope = builder.scope;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public Integer instanceCount() {
        return this.instanceCount;
    }

    public InstanceType instanceType() {
        return InstanceType.fromValue(this.instanceType);
    }

    public String instanceTypeAsString() {
        return this.instanceType;
    }

    public String platform() {
        return this.platform;
    }

    public Scope scope() {
        return Scope.fromValue(this.scope);
    }

    public String scopeAsString() {
        return this.scope;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.platform());
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedInstancesConfiguration)) {
            return false;
        }
        ReservedInstancesConfiguration other = (ReservedInstancesConfiguration)obj;
        return Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.instanceCount(), other.instanceCount()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.platform(), other.platform()) && Objects.equals(this.scopeAsString(), other.scopeAsString());
    }

    public String toString() {
        return ToString.builder((String)"ReservedInstancesConfiguration").add("AvailabilityZone", (Object)this.availabilityZone()).add("InstanceCount", (Object)this.instanceCount()).add("InstanceType", (Object)this.instanceTypeAsString()).add("Platform", (Object)this.platform()).add("Scope", (Object)this.scopeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "InstanceCount": {
                return Optional.ofNullable(clazz.cast(this.instanceCount()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "Platform": {
                return Optional.ofNullable(clazz.cast(this.platform()));
            }
            case "Scope": {
                return Optional.ofNullable(clazz.cast(this.scopeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReservedInstancesConfiguration, T> g) {
        return obj -> g.apply((ReservedInstancesConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String availabilityZone;
        private Integer instanceCount;
        private String instanceType;
        private String platform;
        private String scope;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedInstancesConfiguration model) {
            this.availabilityZone(model.availabilityZone);
            this.instanceCount(model.instanceCount);
            this.instanceType(model.instanceType);
            this.platform(model.platform);
            this.scope(model.scope);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final String getInstanceTypeAsString() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getPlatform() {
            return this.platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final String getScopeAsString() {
            return this.scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(Scope scope) {
            this.scope(scope.toString());
            return this;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        public ReservedInstancesConfiguration build() {
            return new ReservedInstancesConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReservedInstancesConfiguration> {
        public Builder availabilityZone(String var1);

        public Builder instanceCount(Integer var1);

        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder platform(String var1);

        public Builder scope(String var1);

        public Builder scope(Scope var1);
    }
}

