/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateKeyPairResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, CreateKeyPairResponse> {
    private static final SdkField<String> KEY_FINGERPRINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateKeyPairResponse.getter(CreateKeyPairResponse::keyFingerprint)).setter(CreateKeyPairResponse.setter(Builder::keyFingerprint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyFingerprint").unmarshallLocationName("keyFingerprint").build()}).build();
    private static final SdkField<String> KEY_MATERIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateKeyPairResponse.getter(CreateKeyPairResponse::keyMaterial)).setter(CreateKeyPairResponse.setter(Builder::keyMaterial)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyMaterial").unmarshallLocationName("keyMaterial").build()}).build();
    private static final SdkField<String> KEY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateKeyPairResponse.getter(CreateKeyPairResponse::keyName)).setter(CreateKeyPairResponse.setter(Builder::keyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName").unmarshallLocationName("keyName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FINGERPRINT_FIELD, KEY_MATERIAL_FIELD, KEY_NAME_FIELD));
    private final String keyFingerprint;
    private final String keyMaterial;
    private final String keyName;

    private CreateKeyPairResponse(BuilderImpl builder) {
        super(builder);
        this.keyFingerprint = builder.keyFingerprint;
        this.keyMaterial = builder.keyMaterial;
        this.keyName = builder.keyName;
    }

    public String keyFingerprint() {
        return this.keyFingerprint;
    }

    public String keyMaterial() {
        return this.keyMaterial;
    }

    public String keyName() {
        return this.keyName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyFingerprint());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyMaterial());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateKeyPairResponse)) {
            return false;
        }
        CreateKeyPairResponse other = (CreateKeyPairResponse)((Object)obj);
        return Objects.equals(this.keyFingerprint(), other.keyFingerprint()) && Objects.equals(this.keyMaterial(), other.keyMaterial()) && Objects.equals(this.keyName(), other.keyName());
    }

    public String toString() {
        return ToString.builder((String)"CreateKeyPairResponse").add("KeyFingerprint", (Object)this.keyFingerprint()).add("KeyMaterial", (Object)this.keyMaterial()).add("KeyName", (Object)this.keyName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyFingerprint": {
                return Optional.ofNullable(clazz.cast(this.keyFingerprint()));
            }
            case "KeyMaterial": {
                return Optional.ofNullable(clazz.cast(this.keyMaterial()));
            }
            case "KeyName": {
                return Optional.ofNullable(clazz.cast(this.keyName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateKeyPairResponse, T> g) {
        return obj -> g.apply((CreateKeyPairResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String keyFingerprint;
        private String keyMaterial;
        private String keyName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateKeyPairResponse model) {
            super(model);
            this.keyFingerprint(model.keyFingerprint);
            this.keyMaterial(model.keyMaterial);
            this.keyName(model.keyName);
        }

        public final String getKeyFingerprint() {
            return this.keyFingerprint;
        }

        @Override
        public final Builder keyFingerprint(String keyFingerprint) {
            this.keyFingerprint = keyFingerprint;
            return this;
        }

        public final void setKeyFingerprint(String keyFingerprint) {
            this.keyFingerprint = keyFingerprint;
        }

        public final String getKeyMaterial() {
            return this.keyMaterial;
        }

        @Override
        public final Builder keyMaterial(String keyMaterial) {
            this.keyMaterial = keyMaterial;
            return this;
        }

        public final void setKeyMaterial(String keyMaterial) {
            this.keyMaterial = keyMaterial;
        }

        public final String getKeyName() {
            return this.keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        @Override
        public CreateKeyPairResponse build() {
            return new CreateKeyPairResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateKeyPairResponse> {
        public Builder keyFingerprint(String var1);

        public Builder keyMaterial(String var1);

        public Builder keyName(String var1);
    }
}

