/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ServiceState;
import software.amazon.awssdk.services.ec2.model.ServiceTypeDetail;
import software.amazon.awssdk.services.ec2.model.ServiceTypeDetailSetCopier;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceConfiguration> {
    private static final SdkField<List<ServiceTypeDetail>> SERVICE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ServiceConfiguration.getter(ServiceConfiguration::serviceType)).setter(ServiceConfiguration.setter(Builder::serviceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceType").unmarshallLocationName("serviceType").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceTypeDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> SERVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ServiceConfiguration.getter(ServiceConfiguration::serviceId)).setter(ServiceConfiguration.setter(Builder::serviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceId").unmarshallLocationName("serviceId").build()}).build();
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ServiceConfiguration.getter(ServiceConfiguration::serviceName)).setter(ServiceConfiguration.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").unmarshallLocationName("serviceName").build()}).build();
    private static final SdkField<String> SERVICE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ServiceConfiguration.getter(ServiceConfiguration::serviceStateAsString)).setter(ServiceConfiguration.setter(Builder::serviceState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceState").unmarshallLocationName("serviceState").build()}).build();
    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ServiceConfiguration.getter(ServiceConfiguration::availabilityZones)).setter(ServiceConfiguration.setter(Builder::availabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneSet").unmarshallLocationName("availabilityZoneSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ACCEPTANCE_REQUIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ServiceConfiguration.getter(ServiceConfiguration::acceptanceRequired)).setter(ServiceConfiguration.setter(Builder::acceptanceRequired)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptanceRequired").unmarshallLocationName("acceptanceRequired").build()}).build();
    private static final SdkField<Boolean> MANAGES_VPC_ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ServiceConfiguration.getter(ServiceConfiguration::managesVpcEndpoints)).setter(ServiceConfiguration.setter(Builder::managesVpcEndpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagesVpcEndpoints").unmarshallLocationName("managesVpcEndpoints").build()}).build();
    private static final SdkField<List<String>> NETWORK_LOAD_BALANCER_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ServiceConfiguration.getter(ServiceConfiguration::networkLoadBalancerArns)).setter(ServiceConfiguration.setter(Builder::networkLoadBalancerArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkLoadBalancerArnSet").unmarshallLocationName("networkLoadBalancerArnSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> BASE_ENDPOINT_DNS_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ServiceConfiguration.getter(ServiceConfiguration::baseEndpointDnsNames)).setter(ServiceConfiguration.setter(Builder::baseEndpointDnsNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseEndpointDnsNameSet").unmarshallLocationName("baseEndpointDnsNameSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> PRIVATE_DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ServiceConfiguration.getter(ServiceConfiguration::privateDnsName)).setter(ServiceConfiguration.setter(Builder::privateDnsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsName").unmarshallLocationName("privateDnsName").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ServiceConfiguration.getter(ServiceConfiguration::tags)).setter(ServiceConfiguration.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_TYPE_FIELD, SERVICE_ID_FIELD, SERVICE_NAME_FIELD, SERVICE_STATE_FIELD, AVAILABILITY_ZONES_FIELD, ACCEPTANCE_REQUIRED_FIELD, MANAGES_VPC_ENDPOINTS_FIELD, NETWORK_LOAD_BALANCER_ARNS_FIELD, BASE_ENDPOINT_DNS_NAMES_FIELD, PRIVATE_DNS_NAME_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<ServiceTypeDetail> serviceType;
    private final String serviceId;
    private final String serviceName;
    private final String serviceState;
    private final List<String> availabilityZones;
    private final Boolean acceptanceRequired;
    private final Boolean managesVpcEndpoints;
    private final List<String> networkLoadBalancerArns;
    private final List<String> baseEndpointDnsNames;
    private final String privateDnsName;
    private final List<Tag> tags;

    private ServiceConfiguration(BuilderImpl builder) {
        this.serviceType = builder.serviceType;
        this.serviceId = builder.serviceId;
        this.serviceName = builder.serviceName;
        this.serviceState = builder.serviceState;
        this.availabilityZones = builder.availabilityZones;
        this.acceptanceRequired = builder.acceptanceRequired;
        this.managesVpcEndpoints = builder.managesVpcEndpoints;
        this.networkLoadBalancerArns = builder.networkLoadBalancerArns;
        this.baseEndpointDnsNames = builder.baseEndpointDnsNames;
        this.privateDnsName = builder.privateDnsName;
        this.tags = builder.tags;
    }

    public List<ServiceTypeDetail> serviceType() {
        return this.serviceType;
    }

    public String serviceId() {
        return this.serviceId;
    }

    public String serviceName() {
        return this.serviceName;
    }

    public ServiceState serviceState() {
        return ServiceState.fromValue(this.serviceState);
    }

    public String serviceStateAsString() {
        return this.serviceState;
    }

    public List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public Boolean acceptanceRequired() {
        return this.acceptanceRequired;
    }

    public Boolean managesVpcEndpoints() {
        return this.managesVpcEndpoints;
    }

    public List<String> networkLoadBalancerArns() {
        return this.networkLoadBalancerArns;
    }

    public List<String> baseEndpointDnsNames() {
        return this.baseEndpointDnsNames;
    }

    public String privateDnsName() {
        return this.privateDnsName;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZones());
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptanceRequired());
        hashCode = 31 * hashCode + Objects.hashCode(this.managesVpcEndpoints());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkLoadBalancerArns());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseEndpointDnsNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceConfiguration)) {
            return false;
        }
        ServiceConfiguration other = (ServiceConfiguration)obj;
        return Objects.equals(this.serviceType(), other.serviceType()) && Objects.equals(this.serviceId(), other.serviceId()) && Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.serviceStateAsString(), other.serviceStateAsString()) && Objects.equals(this.availabilityZones(), other.availabilityZones()) && Objects.equals(this.acceptanceRequired(), other.acceptanceRequired()) && Objects.equals(this.managesVpcEndpoints(), other.managesVpcEndpoints()) && Objects.equals(this.networkLoadBalancerArns(), other.networkLoadBalancerArns()) && Objects.equals(this.baseEndpointDnsNames(), other.baseEndpointDnsNames()) && Objects.equals(this.privateDnsName(), other.privateDnsName()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"ServiceConfiguration").add("ServiceType", this.serviceType()).add("ServiceId", (Object)this.serviceId()).add("ServiceName", (Object)this.serviceName()).add("ServiceState", (Object)this.serviceStateAsString()).add("AvailabilityZones", this.availabilityZones()).add("AcceptanceRequired", (Object)this.acceptanceRequired()).add("ManagesVpcEndpoints", (Object)this.managesVpcEndpoints()).add("NetworkLoadBalancerArns", this.networkLoadBalancerArns()).add("BaseEndpointDnsNames", this.baseEndpointDnsNames()).add("PrivateDnsName", (Object)this.privateDnsName()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceType": {
                return Optional.ofNullable(clazz.cast(this.serviceType()));
            }
            case "ServiceId": {
                return Optional.ofNullable(clazz.cast(this.serviceId()));
            }
            case "ServiceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
            case "ServiceState": {
                return Optional.ofNullable(clazz.cast(this.serviceStateAsString()));
            }
            case "AvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.availabilityZones()));
            }
            case "AcceptanceRequired": {
                return Optional.ofNullable(clazz.cast(this.acceptanceRequired()));
            }
            case "ManagesVpcEndpoints": {
                return Optional.ofNullable(clazz.cast(this.managesVpcEndpoints()));
            }
            case "NetworkLoadBalancerArns": {
                return Optional.ofNullable(clazz.cast(this.networkLoadBalancerArns()));
            }
            case "BaseEndpointDnsNames": {
                return Optional.ofNullable(clazz.cast(this.baseEndpointDnsNames()));
            }
            case "PrivateDnsName": {
                return Optional.ofNullable(clazz.cast(this.privateDnsName()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceConfiguration, T> g) {
        return obj -> g.apply((ServiceConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ServiceTypeDetail> serviceType = DefaultSdkAutoConstructList.getInstance();
        private String serviceId;
        private String serviceName;
        private String serviceState;
        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();
        private Boolean acceptanceRequired;
        private Boolean managesVpcEndpoints;
        private List<String> networkLoadBalancerArns = DefaultSdkAutoConstructList.getInstance();
        private List<String> baseEndpointDnsNames = DefaultSdkAutoConstructList.getInstance();
        private String privateDnsName;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceConfiguration model) {
            this.serviceType(model.serviceType);
            this.serviceId(model.serviceId);
            this.serviceName(model.serviceName);
            this.serviceState(model.serviceState);
            this.availabilityZones(model.availabilityZones);
            this.acceptanceRequired(model.acceptanceRequired);
            this.managesVpcEndpoints(model.managesVpcEndpoints);
            this.networkLoadBalancerArns(model.networkLoadBalancerArns);
            this.baseEndpointDnsNames(model.baseEndpointDnsNames);
            this.privateDnsName(model.privateDnsName);
            this.tags(model.tags);
        }

        public final Collection<ServiceTypeDetail.Builder> getServiceType() {
            return this.serviceType != null ? (Collection)this.serviceType.stream().map(ServiceTypeDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder serviceType(Collection<ServiceTypeDetail> serviceType) {
            this.serviceType = ServiceTypeDetailSetCopier.copy(serviceType);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceType(ServiceTypeDetail ... serviceType) {
            this.serviceType(Arrays.asList(serviceType));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceType(Consumer<ServiceTypeDetail.Builder> ... serviceType) {
            this.serviceType(Stream.of(serviceType).map(c -> (ServiceTypeDetail)((ServiceTypeDetail.Builder)ServiceTypeDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setServiceType(Collection<ServiceTypeDetail.BuilderImpl> serviceType) {
            this.serviceType = ServiceTypeDetailSetCopier.copyFromBuilder(serviceType);
        }

        public final String getServiceId() {
            return this.serviceId;
        }

        @Override
        public final Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public final void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public final String getServiceStateAsString() {
            return this.serviceState;
        }

        @Override
        public final Builder serviceState(String serviceState) {
            this.serviceState = serviceState;
            return this;
        }

        @Override
        public final Builder serviceState(ServiceState serviceState) {
            this.serviceState(serviceState.toString());
            return this;
        }

        public final void setServiceState(String serviceState) {
            this.serviceState = serviceState;
        }

        public final Collection<String> getAvailabilityZones() {
            return this.availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = ValueStringListCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = ValueStringListCopier.copy(availabilityZones);
        }

        public final Boolean getAcceptanceRequired() {
            return this.acceptanceRequired;
        }

        @Override
        public final Builder acceptanceRequired(Boolean acceptanceRequired) {
            this.acceptanceRequired = acceptanceRequired;
            return this;
        }

        public final void setAcceptanceRequired(Boolean acceptanceRequired) {
            this.acceptanceRequired = acceptanceRequired;
        }

        public final Boolean getManagesVpcEndpoints() {
            return this.managesVpcEndpoints;
        }

        @Override
        public final Builder managesVpcEndpoints(Boolean managesVpcEndpoints) {
            this.managesVpcEndpoints = managesVpcEndpoints;
            return this;
        }

        public final void setManagesVpcEndpoints(Boolean managesVpcEndpoints) {
            this.managesVpcEndpoints = managesVpcEndpoints;
        }

        public final Collection<String> getNetworkLoadBalancerArns() {
            return this.networkLoadBalancerArns;
        }

        @Override
        public final Builder networkLoadBalancerArns(Collection<String> networkLoadBalancerArns) {
            this.networkLoadBalancerArns = ValueStringListCopier.copy(networkLoadBalancerArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkLoadBalancerArns(String ... networkLoadBalancerArns) {
            this.networkLoadBalancerArns(Arrays.asList(networkLoadBalancerArns));
            return this;
        }

        public final void setNetworkLoadBalancerArns(Collection<String> networkLoadBalancerArns) {
            this.networkLoadBalancerArns = ValueStringListCopier.copy(networkLoadBalancerArns);
        }

        public final Collection<String> getBaseEndpointDnsNames() {
            return this.baseEndpointDnsNames;
        }

        @Override
        public final Builder baseEndpointDnsNames(Collection<String> baseEndpointDnsNames) {
            this.baseEndpointDnsNames = ValueStringListCopier.copy(baseEndpointDnsNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder baseEndpointDnsNames(String ... baseEndpointDnsNames) {
            this.baseEndpointDnsNames(Arrays.asList(baseEndpointDnsNames));
            return this;
        }

        public final void setBaseEndpointDnsNames(Collection<String> baseEndpointDnsNames) {
            this.baseEndpointDnsNames = ValueStringListCopier.copy(baseEndpointDnsNames);
        }

        public final String getPrivateDnsName() {
            return this.privateDnsName;
        }

        @Override
        public final Builder privateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
            return this;
        }

        public final void setPrivateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public ServiceConfiguration build() {
            return new ServiceConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceConfiguration> {
        public Builder serviceType(Collection<ServiceTypeDetail> var1);

        public Builder serviceType(ServiceTypeDetail ... var1);

        public Builder serviceType(Consumer<ServiceTypeDetail.Builder> ... var1);

        public Builder serviceId(String var1);

        public Builder serviceName(String var1);

        public Builder serviceState(String var1);

        public Builder serviceState(ServiceState var1);

        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);

        public Builder acceptanceRequired(Boolean var1);

        public Builder managesVpcEndpoints(Boolean var1);

        public Builder networkLoadBalancerArns(Collection<String> var1);

        public Builder networkLoadBalancerArns(String ... var1);

        public Builder baseEndpointDnsNames(Collection<String> var1);

        public Builder baseEndpointDnsNames(String ... var1);

        public Builder privateDnsName(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

