/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.TrafficMirrorSession;
import software.amazon.awssdk.services.ec2.model.TrafficMirrorSessionSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTrafficMirrorSessionsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeTrafficMirrorSessionsResponse> {
    private static final SdkField<List<TrafficMirrorSession>> TRAFFIC_MIRROR_SESSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeTrafficMirrorSessionsResponse.getter(DescribeTrafficMirrorSessionsResponse::trafficMirrorSessions)).setter(DescribeTrafficMirrorSessionsResponse.setter(Builder::trafficMirrorSessions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorSessionSet").unmarshallLocationName("trafficMirrorSessionSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TrafficMirrorSession::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeTrafficMirrorSessionsResponse.getter(DescribeTrafficMirrorSessionsResponse::nextToken)).setter(DescribeTrafficMirrorSessionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAFFIC_MIRROR_SESSIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<TrafficMirrorSession> trafficMirrorSessions;
    private final String nextToken;

    private DescribeTrafficMirrorSessionsResponse(BuilderImpl builder) {
        super(builder);
        this.trafficMirrorSessions = builder.trafficMirrorSessions;
        this.nextToken = builder.nextToken;
    }

    public List<TrafficMirrorSession> trafficMirrorSessions() {
        return this.trafficMirrorSessions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficMirrorSessions());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrafficMirrorSessionsResponse)) {
            return false;
        }
        DescribeTrafficMirrorSessionsResponse other = (DescribeTrafficMirrorSessionsResponse)((Object)obj);
        return Objects.equals(this.trafficMirrorSessions(), other.trafficMirrorSessions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeTrafficMirrorSessionsResponse").add("TrafficMirrorSessions", this.trafficMirrorSessions()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrafficMirrorSessions": {
                return Optional.ofNullable(clazz.cast(this.trafficMirrorSessions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTrafficMirrorSessionsResponse, T> g) {
        return obj -> g.apply((DescribeTrafficMirrorSessionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<TrafficMirrorSession> trafficMirrorSessions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTrafficMirrorSessionsResponse model) {
            super(model);
            this.trafficMirrorSessions(model.trafficMirrorSessions);
            this.nextToken(model.nextToken);
        }

        public final Collection<TrafficMirrorSession.Builder> getTrafficMirrorSessions() {
            return this.trafficMirrorSessions != null ? (Collection)this.trafficMirrorSessions.stream().map(TrafficMirrorSession::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder trafficMirrorSessions(Collection<TrafficMirrorSession> trafficMirrorSessions) {
            this.trafficMirrorSessions = TrafficMirrorSessionSetCopier.copy(trafficMirrorSessions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trafficMirrorSessions(TrafficMirrorSession ... trafficMirrorSessions) {
            this.trafficMirrorSessions(Arrays.asList(trafficMirrorSessions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trafficMirrorSessions(Consumer<TrafficMirrorSession.Builder> ... trafficMirrorSessions) {
            this.trafficMirrorSessions(Stream.of(trafficMirrorSessions).map(c -> (TrafficMirrorSession)((TrafficMirrorSession.Builder)TrafficMirrorSession.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTrafficMirrorSessions(Collection<TrafficMirrorSession.BuilderImpl> trafficMirrorSessions) {
            this.trafficMirrorSessions = TrafficMirrorSessionSetCopier.copyFromBuilder(trafficMirrorSessions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeTrafficMirrorSessionsResponse build() {
            return new DescribeTrafficMirrorSessionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTrafficMirrorSessionsResponse> {
        public Builder trafficMirrorSessions(Collection<TrafficMirrorSession> var1);

        public Builder trafficMirrorSessions(TrafficMirrorSession ... var1);

        public Builder trafficMirrorSessions(Consumer<TrafficMirrorSession.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

