/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.IpPermission;
import software.amazon.awssdk.services.ec2.model.IpPermissionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSecurityGroupRuleDescriptionsIngressRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, UpdateSecurityGroupRuleDescriptionsIngressRequest> {
    private static final SdkField<String> GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateSecurityGroupRuleDescriptionsIngressRequest.getter(UpdateSecurityGroupRuleDescriptionsIngressRequest::groupId)).setter(UpdateSecurityGroupRuleDescriptionsIngressRequest.setter(Builder::groupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").unmarshallLocationName("GroupId").build()}).build();
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateSecurityGroupRuleDescriptionsIngressRequest.getter(UpdateSecurityGroupRuleDescriptionsIngressRequest::groupName)).setter(UpdateSecurityGroupRuleDescriptionsIngressRequest.setter(Builder::groupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").unmarshallLocationName("GroupName").build()}).build();
    private static final SdkField<List<IpPermission>> IP_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateSecurityGroupRuleDescriptionsIngressRequest.getter(UpdateSecurityGroupRuleDescriptionsIngressRequest::ipPermissions)).setter(UpdateSecurityGroupRuleDescriptionsIngressRequest.setter(Builder::ipPermissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpPermissions").unmarshallLocationName("IpPermissions").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpPermission::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_ID_FIELD, GROUP_NAME_FIELD, IP_PERMISSIONS_FIELD));
    private final String groupId;
    private final String groupName;
    private final List<IpPermission> ipPermissions;

    private UpdateSecurityGroupRuleDescriptionsIngressRequest(BuilderImpl builder) {
        super(builder);
        this.groupId = builder.groupId;
        this.groupName = builder.groupName;
        this.ipPermissions = builder.ipPermissions;
    }

    public String groupId() {
        return this.groupId;
    }

    public String groupName() {
        return this.groupName;
    }

    public List<IpPermission> ipPermissions() {
        return this.ipPermissions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.groupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipPermissions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSecurityGroupRuleDescriptionsIngressRequest)) {
            return false;
        }
        UpdateSecurityGroupRuleDescriptionsIngressRequest other = (UpdateSecurityGroupRuleDescriptionsIngressRequest)((Object)obj);
        return Objects.equals(this.groupId(), other.groupId()) && Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.ipPermissions(), other.ipPermissions());
    }

    public String toString() {
        return ToString.builder((String)"UpdateSecurityGroupRuleDescriptionsIngressRequest").add("GroupId", (Object)this.groupId()).add("GroupName", (Object)this.groupName()).add("IpPermissions", this.ipPermissions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupId": {
                return Optional.ofNullable(clazz.cast(this.groupId()));
            }
            case "GroupName": {
                return Optional.ofNullable(clazz.cast(this.groupName()));
            }
            case "IpPermissions": {
                return Optional.ofNullable(clazz.cast(this.ipPermissions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSecurityGroupRuleDescriptionsIngressRequest, T> g) {
        return obj -> g.apply((UpdateSecurityGroupRuleDescriptionsIngressRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String groupId;
        private String groupName;
        private List<IpPermission> ipPermissions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSecurityGroupRuleDescriptionsIngressRequest model) {
            super(model);
            this.groupId(model.groupId);
            this.groupName(model.groupName);
            this.ipPermissions(model.ipPermissions);
        }

        public final String getGroupId() {
            return this.groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public final String getGroupName() {
            return this.groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final Collection<IpPermission.Builder> getIpPermissions() {
            return this.ipPermissions != null ? (Collection)this.ipPermissions.stream().map(IpPermission::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ipPermissions(Collection<IpPermission> ipPermissions) {
            this.ipPermissions = IpPermissionListCopier.copy(ipPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPermissions(IpPermission ... ipPermissions) {
            this.ipPermissions(Arrays.asList(ipPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPermissions(Consumer<IpPermission.Builder> ... ipPermissions) {
            this.ipPermissions(Stream.of(ipPermissions).map(c -> (IpPermission)((IpPermission.Builder)IpPermission.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIpPermissions(Collection<IpPermission.BuilderImpl> ipPermissions) {
            this.ipPermissions = IpPermissionListCopier.copyFromBuilder(ipPermissions);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSecurityGroupRuleDescriptionsIngressRequest build() {
            return new UpdateSecurityGroupRuleDescriptionsIngressRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSecurityGroupRuleDescriptionsIngressRequest> {
        public Builder groupId(String var1);

        public Builder groupName(String var1);

        public Builder ipPermissions(Collection<IpPermission> var1);

        public Builder ipPermissions(IpPermission ... var1);

        public Builder ipPermissions(Consumer<IpPermission.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

