/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.ReservedInstances;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeReservedInstancesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeReservedInstancesResponse> {
    private static final SdkField<List<ReservedInstances>> RESERVED_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeReservedInstancesResponse.getter(DescribeReservedInstancesResponse::reservedInstances)).setter(DescribeReservedInstancesResponse.setter(Builder::reservedInstances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstancesSet").unmarshallLocationName("reservedInstancesSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReservedInstances::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVED_INSTANCES_FIELD));
    private final List<ReservedInstances> reservedInstances;

    private DescribeReservedInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.reservedInstances = builder.reservedInstances;
    }

    public List<ReservedInstances> reservedInstances() {
        return this.reservedInstances;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedInstances());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedInstancesResponse)) {
            return false;
        }
        DescribeReservedInstancesResponse other = (DescribeReservedInstancesResponse)((Object)obj);
        return Objects.equals(this.reservedInstances(), other.reservedInstances());
    }

    public String toString() {
        return ToString.builder((String)"DescribeReservedInstancesResponse").add("ReservedInstances", this.reservedInstances()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReservedInstances": {
                return Optional.ofNullable(clazz.cast(this.reservedInstances()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReservedInstancesResponse, T> g) {
        return obj -> g.apply((DescribeReservedInstancesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<ReservedInstances> reservedInstances = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedInstancesResponse model) {
            super(model);
            this.reservedInstances(model.reservedInstances);
        }

        public final Collection<ReservedInstances.Builder> getReservedInstances() {
            return this.reservedInstances != null ? (Collection)this.reservedInstances.stream().map(ReservedInstances::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder reservedInstances(Collection<ReservedInstances> reservedInstances) {
            this.reservedInstances = ReservedInstancesListCopier.copy(reservedInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstances(ReservedInstances ... reservedInstances) {
            this.reservedInstances(Arrays.asList(reservedInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstances(Consumer<ReservedInstances.Builder> ... reservedInstances) {
            this.reservedInstances(Stream.of(reservedInstances).map(c -> (ReservedInstances)((ReservedInstances.Builder)ReservedInstances.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReservedInstances(Collection<ReservedInstances.BuilderImpl> reservedInstances) {
            this.reservedInstances = ReservedInstancesListCopier.copyFromBuilder(reservedInstances);
        }

        @Override
        public DescribeReservedInstancesResponse build() {
            return new DescribeReservedInstancesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeReservedInstancesResponse> {
        public Builder reservedInstances(Collection<ReservedInstances> var1);

        public Builder reservedInstances(ReservedInstances ... var1);

        public Builder reservedInstances(Consumer<ReservedInstances.Builder> ... var1);
    }
}

