/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.ScheduledInstance;
import software.amazon.awssdk.services.ec2.model.ScheduledInstanceSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeScheduledInstancesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeScheduledInstancesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeScheduledInstancesResponse.getter(DescribeScheduledInstancesResponse::nextToken)).setter(DescribeScheduledInstancesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final SdkField<List<ScheduledInstance>> SCHEDULED_INSTANCE_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeScheduledInstancesResponse.getter(DescribeScheduledInstancesResponse::scheduledInstanceSet)).setter(DescribeScheduledInstancesResponse.setter(Builder::scheduledInstanceSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledInstanceSet").unmarshallLocationName("scheduledInstanceSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScheduledInstance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SCHEDULED_INSTANCE_SET_FIELD));
    private final String nextToken;
    private final List<ScheduledInstance> scheduledInstanceSet;

    private DescribeScheduledInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.scheduledInstanceSet = builder.scheduledInstanceSet;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<ScheduledInstance> scheduledInstanceSet() {
        return this.scheduledInstanceSet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledInstanceSet());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScheduledInstancesResponse)) {
            return false;
        }
        DescribeScheduledInstancesResponse other = (DescribeScheduledInstancesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.scheduledInstanceSet(), other.scheduledInstanceSet());
    }

    public String toString() {
        return ToString.builder((String)"DescribeScheduledInstancesResponse").add("NextToken", (Object)this.nextToken()).add("ScheduledInstanceSet", this.scheduledInstanceSet()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ScheduledInstanceSet": {
                return Optional.ofNullable(clazz.cast(this.scheduledInstanceSet()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeScheduledInstancesResponse, T> g) {
        return obj -> g.apply((DescribeScheduledInstancesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ScheduledInstance> scheduledInstanceSet = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScheduledInstancesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.scheduledInstanceSet(model.scheduledInstanceSet);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<ScheduledInstance.Builder> getScheduledInstanceSet() {
            return this.scheduledInstanceSet != null ? (Collection)this.scheduledInstanceSet.stream().map(ScheduledInstance::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder scheduledInstanceSet(Collection<ScheduledInstance> scheduledInstanceSet) {
            this.scheduledInstanceSet = ScheduledInstanceSetCopier.copy(scheduledInstanceSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledInstanceSet(ScheduledInstance ... scheduledInstanceSet) {
            this.scheduledInstanceSet(Arrays.asList(scheduledInstanceSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledInstanceSet(Consumer<ScheduledInstance.Builder> ... scheduledInstanceSet) {
            this.scheduledInstanceSet(Stream.of(scheduledInstanceSet).map(c -> (ScheduledInstance)((ScheduledInstance.Builder)ScheduledInstance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setScheduledInstanceSet(Collection<ScheduledInstance.BuilderImpl> scheduledInstanceSet) {
            this.scheduledInstanceSet = ScheduledInstanceSetCopier.copyFromBuilder(scheduledInstanceSet);
        }

        @Override
        public DescribeScheduledInstancesResponse build() {
            return new DescribeScheduledInstancesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeScheduledInstancesResponse> {
        public Builder nextToken(String var1);

        public Builder scheduledInstanceSet(Collection<ScheduledInstance> var1);

        public Builder scheduledInstanceSet(ScheduledInstance ... var1);

        public Builder scheduledInstanceSet(Consumer<ScheduledInstance.Builder> ... var1);
    }
}

