/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.DescribeDhcpOptionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeDhcpOptionsResponse;
import software.amazon.awssdk.services.ec2.model.DhcpOptions;

public class DescribeDhcpOptionsIterable
implements SdkIterable<DescribeDhcpOptionsResponse> {
    private final Ec2Client client;
    private final DescribeDhcpOptionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDhcpOptionsIterable(Ec2Client client, DescribeDhcpOptionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeDhcpOptionsResponseFetcher();
    }

    public Iterator<DescribeDhcpOptionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DhcpOptions> dhcpOptions() {
        Function<DescribeDhcpOptionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dhcpOptions() != null) {
                return response.dhcpOptions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeDhcpOptionsResponseFetcher
    implements SyncPageFetcher<DescribeDhcpOptionsResponse> {
        private DescribeDhcpOptionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDhcpOptionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeDhcpOptionsResponse nextPage(DescribeDhcpOptionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDhcpOptionsIterable.this.client.describeDhcpOptions(DescribeDhcpOptionsIterable.this.firstRequest);
            }
            return DescribeDhcpOptionsIterable.this.client.describeDhcpOptions((DescribeDhcpOptionsRequest)((Object)DescribeDhcpOptionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

