/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.LogDestinationType;
import software.amazon.awssdk.services.ec2.model.TrafficType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FlowLog
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FlowLog> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(FlowLog.getter(FlowLog::creationTime)).setter(FlowLog.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").unmarshallLocationName("creationTime").build()}).build();
    private static final SdkField<String> DELIVER_LOGS_ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FlowLog.getter(FlowLog::deliverLogsErrorMessage)).setter(FlowLog.setter(Builder::deliverLogsErrorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliverLogsErrorMessage").unmarshallLocationName("deliverLogsErrorMessage").build()}).build();
    private static final SdkField<String> DELIVER_LOGS_PERMISSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FlowLog.getter(FlowLog::deliverLogsPermissionArn)).setter(FlowLog.setter(Builder::deliverLogsPermissionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliverLogsPermissionArn").unmarshallLocationName("deliverLogsPermissionArn").build()}).build();
    private static final SdkField<String> DELIVER_LOGS_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FlowLog.getter(FlowLog::deliverLogsStatus)).setter(FlowLog.setter(Builder::deliverLogsStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliverLogsStatus").unmarshallLocationName("deliverLogsStatus").build()}).build();
    private static final SdkField<String> FLOW_LOG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FlowLog.getter(FlowLog::flowLogId)).setter(FlowLog.setter(Builder::flowLogId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowLogId").unmarshallLocationName("flowLogId").build()}).build();
    private static final SdkField<String> FLOW_LOG_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FlowLog.getter(FlowLog::flowLogStatus)).setter(FlowLog.setter(Builder::flowLogStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowLogStatus").unmarshallLocationName("flowLogStatus").build()}).build();
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FlowLog.getter(FlowLog::logGroupName)).setter(FlowLog.setter(Builder::logGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogGroupName").unmarshallLocationName("logGroupName").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FlowLog.getter(FlowLog::resourceId)).setter(FlowLog.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").unmarshallLocationName("resourceId").build()}).build();
    private static final SdkField<String> TRAFFIC_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FlowLog.getter(FlowLog::trafficTypeAsString)).setter(FlowLog.setter(Builder::trafficType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficType").unmarshallLocationName("trafficType").build()}).build();
    private static final SdkField<String> LOG_DESTINATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FlowLog.getter(FlowLog::logDestinationTypeAsString)).setter(FlowLog.setter(Builder::logDestinationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogDestinationType").unmarshallLocationName("logDestinationType").build()}).build();
    private static final SdkField<String> LOG_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FlowLog.getter(FlowLog::logDestination)).setter(FlowLog.setter(Builder::logDestination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogDestination").unmarshallLocationName("logDestination").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD, DELIVER_LOGS_ERROR_MESSAGE_FIELD, DELIVER_LOGS_PERMISSION_ARN_FIELD, DELIVER_LOGS_STATUS_FIELD, FLOW_LOG_ID_FIELD, FLOW_LOG_STATUS_FIELD, LOG_GROUP_NAME_FIELD, RESOURCE_ID_FIELD, TRAFFIC_TYPE_FIELD, LOG_DESTINATION_TYPE_FIELD, LOG_DESTINATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant creationTime;
    private final String deliverLogsErrorMessage;
    private final String deliverLogsPermissionArn;
    private final String deliverLogsStatus;
    private final String flowLogId;
    private final String flowLogStatus;
    private final String logGroupName;
    private final String resourceId;
    private final String trafficType;
    private final String logDestinationType;
    private final String logDestination;

    private FlowLog(BuilderImpl builder) {
        this.creationTime = builder.creationTime;
        this.deliverLogsErrorMessage = builder.deliverLogsErrorMessage;
        this.deliverLogsPermissionArn = builder.deliverLogsPermissionArn;
        this.deliverLogsStatus = builder.deliverLogsStatus;
        this.flowLogId = builder.flowLogId;
        this.flowLogStatus = builder.flowLogStatus;
        this.logGroupName = builder.logGroupName;
        this.resourceId = builder.resourceId;
        this.trafficType = builder.trafficType;
        this.logDestinationType = builder.logDestinationType;
        this.logDestination = builder.logDestination;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public String deliverLogsErrorMessage() {
        return this.deliverLogsErrorMessage;
    }

    public String deliverLogsPermissionArn() {
        return this.deliverLogsPermissionArn;
    }

    public String deliverLogsStatus() {
        return this.deliverLogsStatus;
    }

    public String flowLogId() {
        return this.flowLogId;
    }

    public String flowLogStatus() {
        return this.flowLogStatus;
    }

    public String logGroupName() {
        return this.logGroupName;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public TrafficType trafficType() {
        return TrafficType.fromValue(this.trafficType);
    }

    public String trafficTypeAsString() {
        return this.trafficType;
    }

    public LogDestinationType logDestinationType() {
        return LogDestinationType.fromValue(this.logDestinationType);
    }

    public String logDestinationTypeAsString() {
        return this.logDestinationType;
    }

    public String logDestination() {
        return this.logDestination;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliverLogsErrorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliverLogsPermissionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliverLogsStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowLogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowLogStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.logDestinationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.logDestination());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowLog)) {
            return false;
        }
        FlowLog other = (FlowLog)obj;
        return Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.deliverLogsErrorMessage(), other.deliverLogsErrorMessage()) && Objects.equals(this.deliverLogsPermissionArn(), other.deliverLogsPermissionArn()) && Objects.equals(this.deliverLogsStatus(), other.deliverLogsStatus()) && Objects.equals(this.flowLogId(), other.flowLogId()) && Objects.equals(this.flowLogStatus(), other.flowLogStatus()) && Objects.equals(this.logGroupName(), other.logGroupName()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.trafficTypeAsString(), other.trafficTypeAsString()) && Objects.equals(this.logDestinationTypeAsString(), other.logDestinationTypeAsString()) && Objects.equals(this.logDestination(), other.logDestination());
    }

    public String toString() {
        return ToString.builder((String)"FlowLog").add("CreationTime", (Object)this.creationTime()).add("DeliverLogsErrorMessage", (Object)this.deliverLogsErrorMessage()).add("DeliverLogsPermissionArn", (Object)this.deliverLogsPermissionArn()).add("DeliverLogsStatus", (Object)this.deliverLogsStatus()).add("FlowLogId", (Object)this.flowLogId()).add("FlowLogStatus", (Object)this.flowLogStatus()).add("LogGroupName", (Object)this.logGroupName()).add("ResourceId", (Object)this.resourceId()).add("TrafficType", (Object)this.trafficTypeAsString()).add("LogDestinationType", (Object)this.logDestinationTypeAsString()).add("LogDestination", (Object)this.logDestination()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "DeliverLogsErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.deliverLogsErrorMessage()));
            }
            case "DeliverLogsPermissionArn": {
                return Optional.ofNullable(clazz.cast(this.deliverLogsPermissionArn()));
            }
            case "DeliverLogsStatus": {
                return Optional.ofNullable(clazz.cast(this.deliverLogsStatus()));
            }
            case "FlowLogId": {
                return Optional.ofNullable(clazz.cast(this.flowLogId()));
            }
            case "FlowLogStatus": {
                return Optional.ofNullable(clazz.cast(this.flowLogStatus()));
            }
            case "LogGroupName": {
                return Optional.ofNullable(clazz.cast(this.logGroupName()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "TrafficType": {
                return Optional.ofNullable(clazz.cast(this.trafficTypeAsString()));
            }
            case "LogDestinationType": {
                return Optional.ofNullable(clazz.cast(this.logDestinationTypeAsString()));
            }
            case "LogDestination": {
                return Optional.ofNullable(clazz.cast(this.logDestination()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FlowLog, T> g) {
        return obj -> g.apply((FlowLog)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant creationTime;
        private String deliverLogsErrorMessage;
        private String deliverLogsPermissionArn;
        private String deliverLogsStatus;
        private String flowLogId;
        private String flowLogStatus;
        private String logGroupName;
        private String resourceId;
        private String trafficType;
        private String logDestinationType;
        private String logDestination;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowLog model) {
            this.creationTime(model.creationTime);
            this.deliverLogsErrorMessage(model.deliverLogsErrorMessage);
            this.deliverLogsPermissionArn(model.deliverLogsPermissionArn);
            this.deliverLogsStatus(model.deliverLogsStatus);
            this.flowLogId(model.flowLogId);
            this.flowLogStatus(model.flowLogStatus);
            this.logGroupName(model.logGroupName);
            this.resourceId(model.resourceId);
            this.trafficType(model.trafficType);
            this.logDestinationType(model.logDestinationType);
            this.logDestination(model.logDestination);
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final String getDeliverLogsErrorMessage() {
            return this.deliverLogsErrorMessage;
        }

        @Override
        public final Builder deliverLogsErrorMessage(String deliverLogsErrorMessage) {
            this.deliverLogsErrorMessage = deliverLogsErrorMessage;
            return this;
        }

        public final void setDeliverLogsErrorMessage(String deliverLogsErrorMessage) {
            this.deliverLogsErrorMessage = deliverLogsErrorMessage;
        }

        public final String getDeliverLogsPermissionArn() {
            return this.deliverLogsPermissionArn;
        }

        @Override
        public final Builder deliverLogsPermissionArn(String deliverLogsPermissionArn) {
            this.deliverLogsPermissionArn = deliverLogsPermissionArn;
            return this;
        }

        public final void setDeliverLogsPermissionArn(String deliverLogsPermissionArn) {
            this.deliverLogsPermissionArn = deliverLogsPermissionArn;
        }

        public final String getDeliverLogsStatus() {
            return this.deliverLogsStatus;
        }

        @Override
        public final Builder deliverLogsStatus(String deliverLogsStatus) {
            this.deliverLogsStatus = deliverLogsStatus;
            return this;
        }

        public final void setDeliverLogsStatus(String deliverLogsStatus) {
            this.deliverLogsStatus = deliverLogsStatus;
        }

        public final String getFlowLogId() {
            return this.flowLogId;
        }

        @Override
        public final Builder flowLogId(String flowLogId) {
            this.flowLogId = flowLogId;
            return this;
        }

        public final void setFlowLogId(String flowLogId) {
            this.flowLogId = flowLogId;
        }

        public final String getFlowLogStatus() {
            return this.flowLogStatus;
        }

        @Override
        public final Builder flowLogStatus(String flowLogStatus) {
            this.flowLogStatus = flowLogStatus;
            return this;
        }

        public final void setFlowLogStatus(String flowLogStatus) {
            this.flowLogStatus = flowLogStatus;
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getTrafficTypeAsString() {
            return this.trafficType;
        }

        @Override
        public final Builder trafficType(String trafficType) {
            this.trafficType = trafficType;
            return this;
        }

        @Override
        public final Builder trafficType(TrafficType trafficType) {
            this.trafficType(trafficType == null ? null : trafficType.toString());
            return this;
        }

        public final void setTrafficType(String trafficType) {
            this.trafficType = trafficType;
        }

        public final String getLogDestinationTypeAsString() {
            return this.logDestinationType;
        }

        @Override
        public final Builder logDestinationType(String logDestinationType) {
            this.logDestinationType = logDestinationType;
            return this;
        }

        @Override
        public final Builder logDestinationType(LogDestinationType logDestinationType) {
            this.logDestinationType(logDestinationType == null ? null : logDestinationType.toString());
            return this;
        }

        public final void setLogDestinationType(String logDestinationType) {
            this.logDestinationType = logDestinationType;
        }

        public final String getLogDestination() {
            return this.logDestination;
        }

        @Override
        public final Builder logDestination(String logDestination) {
            this.logDestination = logDestination;
            return this;
        }

        public final void setLogDestination(String logDestination) {
            this.logDestination = logDestination;
        }

        public FlowLog build() {
            return new FlowLog(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FlowLog> {
        public Builder creationTime(Instant var1);

        public Builder deliverLogsErrorMessage(String var1);

        public Builder deliverLogsPermissionArn(String var1);

        public Builder deliverLogsStatus(String var1);

        public Builder flowLogId(String var1);

        public Builder flowLogStatus(String var1);

        public Builder logGroupName(String var1);

        public Builder resourceId(String var1);

        public Builder trafficType(String var1);

        public Builder trafficType(TrafficType var1);

        public Builder logDestinationType(String var1);

        public Builder logDestinationType(LogDestinationType var1);

        public Builder logDestination(String var1);
    }
}

