/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CpuOptionsRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CpuOptionsRequest> {
    private static final SdkField<Integer> CORE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CpuOptionsRequest.getter(CpuOptionsRequest::coreCount)).setter(CpuOptionsRequest.setter(Builder::coreCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreCount").unmarshallLocationName("CoreCount").build()}).build();
    private static final SdkField<Integer> THREADS_PER_CORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CpuOptionsRequest.getter(CpuOptionsRequest::threadsPerCore)).setter(CpuOptionsRequest.setter(Builder::threadsPerCore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThreadsPerCore").unmarshallLocationName("ThreadsPerCore").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORE_COUNT_FIELD, THREADS_PER_CORE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer coreCount;
    private final Integer threadsPerCore;

    private CpuOptionsRequest(BuilderImpl builder) {
        this.coreCount = builder.coreCount;
        this.threadsPerCore = builder.threadsPerCore;
    }

    public Integer coreCount() {
        return this.coreCount;
    }

    public Integer threadsPerCore() {
        return this.threadsPerCore;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.coreCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.threadsPerCore());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CpuOptionsRequest)) {
            return false;
        }
        CpuOptionsRequest other = (CpuOptionsRequest)obj;
        return Objects.equals(this.coreCount(), other.coreCount()) && Objects.equals(this.threadsPerCore(), other.threadsPerCore());
    }

    public String toString() {
        return ToString.builder((String)"CpuOptionsRequest").add("CoreCount", (Object)this.coreCount()).add("ThreadsPerCore", (Object)this.threadsPerCore()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CoreCount": {
                return Optional.ofNullable(clazz.cast(this.coreCount()));
            }
            case "ThreadsPerCore": {
                return Optional.ofNullable(clazz.cast(this.threadsPerCore()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CpuOptionsRequest, T> g) {
        return obj -> g.apply((CpuOptionsRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer coreCount;
        private Integer threadsPerCore;

        private BuilderImpl() {
        }

        private BuilderImpl(CpuOptionsRequest model) {
            this.coreCount(model.coreCount);
            this.threadsPerCore(model.threadsPerCore);
        }

        public final Integer getCoreCount() {
            return this.coreCount;
        }

        @Override
        public final Builder coreCount(Integer coreCount) {
            this.coreCount = coreCount;
            return this;
        }

        public final void setCoreCount(Integer coreCount) {
            this.coreCount = coreCount;
        }

        public final Integer getThreadsPerCore() {
            return this.threadsPerCore;
        }

        @Override
        public final Builder threadsPerCore(Integer threadsPerCore) {
            this.threadsPerCore = threadsPerCore;
            return this;
        }

        public final void setThreadsPerCore(Integer threadsPerCore) {
            this.threadsPerCore = threadsPerCore;
        }

        public CpuOptionsRequest build() {
            return new CpuOptionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CpuOptionsRequest> {
        public Builder coreCount(Integer var1);

        public Builder threadsPerCore(Integer var1);
    }
}

