/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum RIProductDescription {
    LINUX_UNIX("Linux/UNIX"),
    LINUX_UNIX_AMAZON_VPC("Linux/UNIX (Amazon VPC)"),
    WINDOWS("Windows"),
    WINDOWS_AMAZON_VPC("Windows (Amazon VPC)"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private RIProductDescription(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RIProductDescription fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(RIProductDescription.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RIProductDescription> knownValues() {
        return Stream.of(RIProductDescription.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

