/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.TrafficMirrorNetworkService;
import software.amazon.awssdk.services.ec2.model.TrafficMirrorNetworkServiceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyTrafficMirrorFilterNetworkServicesRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyTrafficMirrorFilterNetworkServicesRequest> {
    private static final SdkField<String> TRAFFIC_MIRROR_FILTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyTrafficMirrorFilterNetworkServicesRequest.getter(ModifyTrafficMirrorFilterNetworkServicesRequest::trafficMirrorFilterId)).setter(ModifyTrafficMirrorFilterNetworkServicesRequest.setter(Builder::trafficMirrorFilterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorFilterId").unmarshallLocationName("TrafficMirrorFilterId").build()}).build();
    private static final SdkField<List<String>> ADD_NETWORK_SERVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ModifyTrafficMirrorFilterNetworkServicesRequest.getter(ModifyTrafficMirrorFilterNetworkServicesRequest::addNetworkServicesAsStrings)).setter(ModifyTrafficMirrorFilterNetworkServicesRequest.setter(Builder::addNetworkServicesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddNetworkService").unmarshallLocationName("AddNetworkService").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REMOVE_NETWORK_SERVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ModifyTrafficMirrorFilterNetworkServicesRequest.getter(ModifyTrafficMirrorFilterNetworkServicesRequest::removeNetworkServicesAsStrings)).setter(ModifyTrafficMirrorFilterNetworkServicesRequest.setter(Builder::removeNetworkServicesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveNetworkService").unmarshallLocationName("RemoveNetworkService").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAFFIC_MIRROR_FILTER_ID_FIELD, ADD_NETWORK_SERVICES_FIELD, REMOVE_NETWORK_SERVICES_FIELD));
    private final String trafficMirrorFilterId;
    private final List<String> addNetworkServices;
    private final List<String> removeNetworkServices;

    private ModifyTrafficMirrorFilterNetworkServicesRequest(BuilderImpl builder) {
        super(builder);
        this.trafficMirrorFilterId = builder.trafficMirrorFilterId;
        this.addNetworkServices = builder.addNetworkServices;
        this.removeNetworkServices = builder.removeNetworkServices;
    }

    public String trafficMirrorFilterId() {
        return this.trafficMirrorFilterId;
    }

    public List<TrafficMirrorNetworkService> addNetworkServices() {
        return TrafficMirrorNetworkServiceListCopier.copyStringToEnum(this.addNetworkServices);
    }

    public List<String> addNetworkServicesAsStrings() {
        return this.addNetworkServices;
    }

    public List<TrafficMirrorNetworkService> removeNetworkServices() {
        return TrafficMirrorNetworkServiceListCopier.copyStringToEnum(this.removeNetworkServices);
    }

    public List<String> removeNetworkServicesAsStrings() {
        return this.removeNetworkServices;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficMirrorFilterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.addNetworkServicesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.removeNetworkServicesAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyTrafficMirrorFilterNetworkServicesRequest)) {
            return false;
        }
        ModifyTrafficMirrorFilterNetworkServicesRequest other = (ModifyTrafficMirrorFilterNetworkServicesRequest)((Object)obj);
        return Objects.equals(this.trafficMirrorFilterId(), other.trafficMirrorFilterId()) && Objects.equals(this.addNetworkServicesAsStrings(), other.addNetworkServicesAsStrings()) && Objects.equals(this.removeNetworkServicesAsStrings(), other.removeNetworkServicesAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"ModifyTrafficMirrorFilterNetworkServicesRequest").add("TrafficMirrorFilterId", (Object)this.trafficMirrorFilterId()).add("AddNetworkServices", this.addNetworkServicesAsStrings()).add("RemoveNetworkServices", this.removeNetworkServicesAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrafficMirrorFilterId": {
                return Optional.ofNullable(clazz.cast(this.trafficMirrorFilterId()));
            }
            case "AddNetworkServices": {
                return Optional.ofNullable(clazz.cast(this.addNetworkServicesAsStrings()));
            }
            case "RemoveNetworkServices": {
                return Optional.ofNullable(clazz.cast(this.removeNetworkServicesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyTrafficMirrorFilterNetworkServicesRequest, T> g) {
        return obj -> g.apply((ModifyTrafficMirrorFilterNetworkServicesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String trafficMirrorFilterId;
        private List<String> addNetworkServices = DefaultSdkAutoConstructList.getInstance();
        private List<String> removeNetworkServices = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyTrafficMirrorFilterNetworkServicesRequest model) {
            super(model);
            this.trafficMirrorFilterId(model.trafficMirrorFilterId);
            this.addNetworkServicesWithStrings(model.addNetworkServices);
            this.removeNetworkServicesWithStrings(model.removeNetworkServices);
        }

        public final String getTrafficMirrorFilterId() {
            return this.trafficMirrorFilterId;
        }

        @Override
        public final Builder trafficMirrorFilterId(String trafficMirrorFilterId) {
            this.trafficMirrorFilterId = trafficMirrorFilterId;
            return this;
        }

        public final void setTrafficMirrorFilterId(String trafficMirrorFilterId) {
            this.trafficMirrorFilterId = trafficMirrorFilterId;
        }

        public final Collection<String> getAddNetworkServicesAsStrings() {
            return this.addNetworkServices;
        }

        @Override
        public final Builder addNetworkServicesWithStrings(Collection<String> addNetworkServices) {
            this.addNetworkServices = TrafficMirrorNetworkServiceListCopier.copy(addNetworkServices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addNetworkServicesWithStrings(String ... addNetworkServices) {
            this.addNetworkServicesWithStrings(Arrays.asList(addNetworkServices));
            return this;
        }

        @Override
        public final Builder addNetworkServices(Collection<TrafficMirrorNetworkService> addNetworkServices) {
            this.addNetworkServices = TrafficMirrorNetworkServiceListCopier.copyEnumToString(addNetworkServices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addNetworkServices(TrafficMirrorNetworkService ... addNetworkServices) {
            this.addNetworkServices(Arrays.asList(addNetworkServices));
            return this;
        }

        public final void setAddNetworkServicesWithStrings(Collection<String> addNetworkServices) {
            this.addNetworkServices = TrafficMirrorNetworkServiceListCopier.copy(addNetworkServices);
        }

        public final Collection<String> getRemoveNetworkServicesAsStrings() {
            return this.removeNetworkServices;
        }

        @Override
        public final Builder removeNetworkServicesWithStrings(Collection<String> removeNetworkServices) {
            this.removeNetworkServices = TrafficMirrorNetworkServiceListCopier.copy(removeNetworkServices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeNetworkServicesWithStrings(String ... removeNetworkServices) {
            this.removeNetworkServicesWithStrings(Arrays.asList(removeNetworkServices));
            return this;
        }

        @Override
        public final Builder removeNetworkServices(Collection<TrafficMirrorNetworkService> removeNetworkServices) {
            this.removeNetworkServices = TrafficMirrorNetworkServiceListCopier.copyEnumToString(removeNetworkServices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeNetworkServices(TrafficMirrorNetworkService ... removeNetworkServices) {
            this.removeNetworkServices(Arrays.asList(removeNetworkServices));
            return this;
        }

        public final void setRemoveNetworkServicesWithStrings(Collection<String> removeNetworkServices) {
            this.removeNetworkServices = TrafficMirrorNetworkServiceListCopier.copy(removeNetworkServices);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyTrafficMirrorFilterNetworkServicesRequest build() {
            return new ModifyTrafficMirrorFilterNetworkServicesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyTrafficMirrorFilterNetworkServicesRequest> {
        public Builder trafficMirrorFilterId(String var1);

        public Builder addNetworkServicesWithStrings(Collection<String> var1);

        public Builder addNetworkServicesWithStrings(String ... var1);

        public Builder addNetworkServices(Collection<TrafficMirrorNetworkService> var1);

        public Builder addNetworkServices(TrafficMirrorNetworkService ... var1);

        public Builder removeNetworkServicesWithStrings(Collection<String> var1);

        public Builder removeNetworkServicesWithStrings(String ... var1);

        public Builder removeNetworkServices(Collection<TrafficMirrorNetworkService> var1);

        public Builder removeNetworkServices(TrafficMirrorNetworkService ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

