/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AssociatedTargetNetwork;
import software.amazon.awssdk.services.ec2.model.AssociatedTargetNetworkSetCopier;
import software.amazon.awssdk.services.ec2.model.ClientVpnAuthentication;
import software.amazon.awssdk.services.ec2.model.ClientVpnAuthenticationListCopier;
import software.amazon.awssdk.services.ec2.model.ClientVpnEndpointStatus;
import software.amazon.awssdk.services.ec2.model.ConnectionLogResponseOptions;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.services.ec2.model.TransportProtocol;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.services.ec2.model.VpnProtocol;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClientVpnEndpoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClientVpnEndpoint> {
    private static final SdkField<String> CLIENT_VPN_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ClientVpnEndpoint.getter(ClientVpnEndpoint::clientVpnEndpointId)).setter(ClientVpnEndpoint.setter(Builder::clientVpnEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientVpnEndpointId").unmarshallLocationName("clientVpnEndpointId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ClientVpnEndpoint.getter(ClientVpnEndpoint::description)).setter(ClientVpnEndpoint.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<ClientVpnEndpointStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ClientVpnEndpoint.getter(ClientVpnEndpoint::status)).setter(ClientVpnEndpoint.setter(Builder::status)).constructor(ClientVpnEndpointStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("status").build()}).build();
    private static final SdkField<String> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ClientVpnEndpoint.getter(ClientVpnEndpoint::creationTime)).setter(ClientVpnEndpoint.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").unmarshallLocationName("creationTime").build()}).build();
    private static final SdkField<String> DELETION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ClientVpnEndpoint.getter(ClientVpnEndpoint::deletionTime)).setter(ClientVpnEndpoint.setter(Builder::deletionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionTime").unmarshallLocationName("deletionTime").build()}).build();
    private static final SdkField<String> DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ClientVpnEndpoint.getter(ClientVpnEndpoint::dnsName)).setter(ClientVpnEndpoint.setter(Builder::dnsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsName").unmarshallLocationName("dnsName").build()}).build();
    private static final SdkField<String> CLIENT_CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ClientVpnEndpoint.getter(ClientVpnEndpoint::clientCidrBlock)).setter(ClientVpnEndpoint.setter(Builder::clientCidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientCidrBlock").unmarshallLocationName("clientCidrBlock").build()}).build();
    private static final SdkField<List<String>> DNS_SERVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ClientVpnEndpoint.getter(ClientVpnEndpoint::dnsServers)).setter(ClientVpnEndpoint.setter(Builder::dnsServers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsServer").unmarshallLocationName("dnsServer").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Boolean> SPLIT_TUNNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ClientVpnEndpoint.getter(ClientVpnEndpoint::splitTunnel)).setter(ClientVpnEndpoint.setter(Builder::splitTunnel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SplitTunnel").unmarshallLocationName("splitTunnel").build()}).build();
    private static final SdkField<String> VPN_PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ClientVpnEndpoint.getter(ClientVpnEndpoint::vpnProtocolAsString)).setter(ClientVpnEndpoint.setter(Builder::vpnProtocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnProtocol").unmarshallLocationName("vpnProtocol").build()}).build();
    private static final SdkField<String> TRANSPORT_PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ClientVpnEndpoint.getter(ClientVpnEndpoint::transportProtocolAsString)).setter(ClientVpnEndpoint.setter(Builder::transportProtocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransportProtocol").unmarshallLocationName("transportProtocol").build()}).build();
    private static final SdkField<List<AssociatedTargetNetwork>> ASSOCIATED_TARGET_NETWORKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ClientVpnEndpoint.getter(ClientVpnEndpoint::associatedTargetNetworks)).setter(ClientVpnEndpoint.setter(Builder::associatedTargetNetworks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedTargetNetwork").unmarshallLocationName("associatedTargetNetwork").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssociatedTargetNetwork::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> SERVER_CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ClientVpnEndpoint.getter(ClientVpnEndpoint::serverCertificateArn)).setter(ClientVpnEndpoint.setter(Builder::serverCertificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerCertificateArn").unmarshallLocationName("serverCertificateArn").build()}).build();
    private static final SdkField<List<ClientVpnAuthentication>> AUTHENTICATION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ClientVpnEndpoint.getter(ClientVpnEndpoint::authenticationOptions)).setter(ClientVpnEndpoint.setter(Builder::authenticationOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationOptions").unmarshallLocationName("authenticationOptions").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClientVpnAuthentication::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<ConnectionLogResponseOptions> CONNECTION_LOG_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ClientVpnEndpoint.getter(ClientVpnEndpoint::connectionLogOptions)).setter(ClientVpnEndpoint.setter(Builder::connectionLogOptions)).constructor(ConnectionLogResponseOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionLogOptions").unmarshallLocationName("connectionLogOptions").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ClientVpnEndpoint.getter(ClientVpnEndpoint::tags)).setter(ClientVpnEndpoint.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_VPN_ENDPOINT_ID_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, DELETION_TIME_FIELD, DNS_NAME_FIELD, CLIENT_CIDR_BLOCK_FIELD, DNS_SERVERS_FIELD, SPLIT_TUNNEL_FIELD, VPN_PROTOCOL_FIELD, TRANSPORT_PROTOCOL_FIELD, ASSOCIATED_TARGET_NETWORKS_FIELD, SERVER_CERTIFICATE_ARN_FIELD, AUTHENTICATION_OPTIONS_FIELD, CONNECTION_LOG_OPTIONS_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String clientVpnEndpointId;
    private final String description;
    private final ClientVpnEndpointStatus status;
    private final String creationTime;
    private final String deletionTime;
    private final String dnsName;
    private final String clientCidrBlock;
    private final List<String> dnsServers;
    private final Boolean splitTunnel;
    private final String vpnProtocol;
    private final String transportProtocol;
    private final List<AssociatedTargetNetwork> associatedTargetNetworks;
    private final String serverCertificateArn;
    private final List<ClientVpnAuthentication> authenticationOptions;
    private final ConnectionLogResponseOptions connectionLogOptions;
    private final List<Tag> tags;

    private ClientVpnEndpoint(BuilderImpl builder) {
        this.clientVpnEndpointId = builder.clientVpnEndpointId;
        this.description = builder.description;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.deletionTime = builder.deletionTime;
        this.dnsName = builder.dnsName;
        this.clientCidrBlock = builder.clientCidrBlock;
        this.dnsServers = builder.dnsServers;
        this.splitTunnel = builder.splitTunnel;
        this.vpnProtocol = builder.vpnProtocol;
        this.transportProtocol = builder.transportProtocol;
        this.associatedTargetNetworks = builder.associatedTargetNetworks;
        this.serverCertificateArn = builder.serverCertificateArn;
        this.authenticationOptions = builder.authenticationOptions;
        this.connectionLogOptions = builder.connectionLogOptions;
        this.tags = builder.tags;
    }

    public String clientVpnEndpointId() {
        return this.clientVpnEndpointId;
    }

    public String description() {
        return this.description;
    }

    public ClientVpnEndpointStatus status() {
        return this.status;
    }

    public String creationTime() {
        return this.creationTime;
    }

    public String deletionTime() {
        return this.deletionTime;
    }

    public String dnsName() {
        return this.dnsName;
    }

    public String clientCidrBlock() {
        return this.clientCidrBlock;
    }

    public List<String> dnsServers() {
        return this.dnsServers;
    }

    public Boolean splitTunnel() {
        return this.splitTunnel;
    }

    public VpnProtocol vpnProtocol() {
        return VpnProtocol.fromValue(this.vpnProtocol);
    }

    public String vpnProtocolAsString() {
        return this.vpnProtocol;
    }

    public TransportProtocol transportProtocol() {
        return TransportProtocol.fromValue(this.transportProtocol);
    }

    public String transportProtocolAsString() {
        return this.transportProtocol;
    }

    public List<AssociatedTargetNetwork> associatedTargetNetworks() {
        return this.associatedTargetNetworks;
    }

    public String serverCertificateArn() {
        return this.serverCertificateArn;
    }

    public List<ClientVpnAuthentication> authenticationOptions() {
        return this.authenticationOptions;
    }

    public ConnectionLogResponseOptions connectionLogOptions() {
        return this.connectionLogOptions;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientVpnEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsServers());
        hashCode = 31 * hashCode + Objects.hashCode(this.splitTunnel());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpnProtocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.transportProtocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.associatedTargetNetworks());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverCertificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionLogOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClientVpnEndpoint)) {
            return false;
        }
        ClientVpnEndpoint other = (ClientVpnEndpoint)obj;
        return Objects.equals(this.clientVpnEndpointId(), other.clientVpnEndpointId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.deletionTime(), other.deletionTime()) && Objects.equals(this.dnsName(), other.dnsName()) && Objects.equals(this.clientCidrBlock(), other.clientCidrBlock()) && Objects.equals(this.dnsServers(), other.dnsServers()) && Objects.equals(this.splitTunnel(), other.splitTunnel()) && Objects.equals(this.vpnProtocolAsString(), other.vpnProtocolAsString()) && Objects.equals(this.transportProtocolAsString(), other.transportProtocolAsString()) && Objects.equals(this.associatedTargetNetworks(), other.associatedTargetNetworks()) && Objects.equals(this.serverCertificateArn(), other.serverCertificateArn()) && Objects.equals(this.authenticationOptions(), other.authenticationOptions()) && Objects.equals(this.connectionLogOptions(), other.connectionLogOptions()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"ClientVpnEndpoint").add("ClientVpnEndpointId", (Object)this.clientVpnEndpointId()).add("Description", (Object)this.description()).add("Status", (Object)this.status()).add("CreationTime", (Object)this.creationTime()).add("DeletionTime", (Object)this.deletionTime()).add("DnsName", (Object)this.dnsName()).add("ClientCidrBlock", (Object)this.clientCidrBlock()).add("DnsServers", this.dnsServers()).add("SplitTunnel", (Object)this.splitTunnel()).add("VpnProtocol", (Object)this.vpnProtocolAsString()).add("TransportProtocol", (Object)this.transportProtocolAsString()).add("AssociatedTargetNetworks", this.associatedTargetNetworks()).add("ServerCertificateArn", (Object)this.serverCertificateArn()).add("AuthenticationOptions", this.authenticationOptions()).add("ConnectionLogOptions", (Object)this.connectionLogOptions()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientVpnEndpointId": {
                return Optional.ofNullable(clazz.cast(this.clientVpnEndpointId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "DeletionTime": {
                return Optional.ofNullable(clazz.cast(this.deletionTime()));
            }
            case "DnsName": {
                return Optional.ofNullable(clazz.cast(this.dnsName()));
            }
            case "ClientCidrBlock": {
                return Optional.ofNullable(clazz.cast(this.clientCidrBlock()));
            }
            case "DnsServers": {
                return Optional.ofNullable(clazz.cast(this.dnsServers()));
            }
            case "SplitTunnel": {
                return Optional.ofNullable(clazz.cast(this.splitTunnel()));
            }
            case "VpnProtocol": {
                return Optional.ofNullable(clazz.cast(this.vpnProtocolAsString()));
            }
            case "TransportProtocol": {
                return Optional.ofNullable(clazz.cast(this.transportProtocolAsString()));
            }
            case "AssociatedTargetNetworks": {
                return Optional.ofNullable(clazz.cast(this.associatedTargetNetworks()));
            }
            case "ServerCertificateArn": {
                return Optional.ofNullable(clazz.cast(this.serverCertificateArn()));
            }
            case "AuthenticationOptions": {
                return Optional.ofNullable(clazz.cast(this.authenticationOptions()));
            }
            case "ConnectionLogOptions": {
                return Optional.ofNullable(clazz.cast(this.connectionLogOptions()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClientVpnEndpoint, T> g) {
        return obj -> g.apply((ClientVpnEndpoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clientVpnEndpointId;
        private String description;
        private ClientVpnEndpointStatus status;
        private String creationTime;
        private String deletionTime;
        private String dnsName;
        private String clientCidrBlock;
        private List<String> dnsServers = DefaultSdkAutoConstructList.getInstance();
        private Boolean splitTunnel;
        private String vpnProtocol;
        private String transportProtocol;
        private List<AssociatedTargetNetwork> associatedTargetNetworks = DefaultSdkAutoConstructList.getInstance();
        private String serverCertificateArn;
        private List<ClientVpnAuthentication> authenticationOptions = DefaultSdkAutoConstructList.getInstance();
        private ConnectionLogResponseOptions connectionLogOptions;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ClientVpnEndpoint model) {
            this.clientVpnEndpointId(model.clientVpnEndpointId);
            this.description(model.description);
            this.status(model.status);
            this.creationTime(model.creationTime);
            this.deletionTime(model.deletionTime);
            this.dnsName(model.dnsName);
            this.clientCidrBlock(model.clientCidrBlock);
            this.dnsServers(model.dnsServers);
            this.splitTunnel(model.splitTunnel);
            this.vpnProtocol(model.vpnProtocol);
            this.transportProtocol(model.transportProtocol);
            this.associatedTargetNetworks(model.associatedTargetNetworks);
            this.serverCertificateArn(model.serverCertificateArn);
            this.authenticationOptions(model.authenticationOptions);
            this.connectionLogOptions(model.connectionLogOptions);
            this.tags(model.tags);
        }

        public final String getClientVpnEndpointId() {
            return this.clientVpnEndpointId;
        }

        @Override
        public final Builder clientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
            return this;
        }

        public final void setClientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final ClientVpnEndpointStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        @Override
        public final Builder status(ClientVpnEndpointStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(ClientVpnEndpointStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public final String getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        public final String getDeletionTime() {
            return this.deletionTime;
        }

        @Override
        public final Builder deletionTime(String deletionTime) {
            this.deletionTime = deletionTime;
            return this;
        }

        public final void setDeletionTime(String deletionTime) {
            this.deletionTime = deletionTime;
        }

        public final String getDnsName() {
            return this.dnsName;
        }

        @Override
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public final void setDnsName(String dnsName) {
            this.dnsName = dnsName;
        }

        public final String getClientCidrBlock() {
            return this.clientCidrBlock;
        }

        @Override
        public final Builder clientCidrBlock(String clientCidrBlock) {
            this.clientCidrBlock = clientCidrBlock;
            return this;
        }

        public final void setClientCidrBlock(String clientCidrBlock) {
            this.clientCidrBlock = clientCidrBlock;
        }

        public final Collection<String> getDnsServers() {
            return this.dnsServers;
        }

        @Override
        public final Builder dnsServers(Collection<String> dnsServers) {
            this.dnsServers = ValueStringListCopier.copy(dnsServers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnsServers(String ... dnsServers) {
            this.dnsServers(Arrays.asList(dnsServers));
            return this;
        }

        public final void setDnsServers(Collection<String> dnsServers) {
            this.dnsServers = ValueStringListCopier.copy(dnsServers);
        }

        public final Boolean getSplitTunnel() {
            return this.splitTunnel;
        }

        @Override
        public final Builder splitTunnel(Boolean splitTunnel) {
            this.splitTunnel = splitTunnel;
            return this;
        }

        public final void setSplitTunnel(Boolean splitTunnel) {
            this.splitTunnel = splitTunnel;
        }

        public final String getVpnProtocolAsString() {
            return this.vpnProtocol;
        }

        @Override
        public final Builder vpnProtocol(String vpnProtocol) {
            this.vpnProtocol = vpnProtocol;
            return this;
        }

        @Override
        public final Builder vpnProtocol(VpnProtocol vpnProtocol) {
            this.vpnProtocol(vpnProtocol.toString());
            return this;
        }

        public final void setVpnProtocol(String vpnProtocol) {
            this.vpnProtocol = vpnProtocol;
        }

        public final String getTransportProtocolAsString() {
            return this.transportProtocol;
        }

        @Override
        public final Builder transportProtocol(String transportProtocol) {
            this.transportProtocol = transportProtocol;
            return this;
        }

        @Override
        public final Builder transportProtocol(TransportProtocol transportProtocol) {
            this.transportProtocol(transportProtocol.toString());
            return this;
        }

        public final void setTransportProtocol(String transportProtocol) {
            this.transportProtocol = transportProtocol;
        }

        public final Collection<AssociatedTargetNetwork.Builder> getAssociatedTargetNetworks() {
            return this.associatedTargetNetworks != null ? (Collection)this.associatedTargetNetworks.stream().map(AssociatedTargetNetwork::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder associatedTargetNetworks(Collection<AssociatedTargetNetwork> associatedTargetNetworks) {
            this.associatedTargetNetworks = AssociatedTargetNetworkSetCopier.copy(associatedTargetNetworks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedTargetNetworks(AssociatedTargetNetwork ... associatedTargetNetworks) {
            this.associatedTargetNetworks(Arrays.asList(associatedTargetNetworks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedTargetNetworks(Consumer<AssociatedTargetNetwork.Builder> ... associatedTargetNetworks) {
            this.associatedTargetNetworks(Stream.of(associatedTargetNetworks).map(c -> (AssociatedTargetNetwork)((AssociatedTargetNetwork.Builder)AssociatedTargetNetwork.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAssociatedTargetNetworks(Collection<AssociatedTargetNetwork.BuilderImpl> associatedTargetNetworks) {
            this.associatedTargetNetworks = AssociatedTargetNetworkSetCopier.copyFromBuilder(associatedTargetNetworks);
        }

        public final String getServerCertificateArn() {
            return this.serverCertificateArn;
        }

        @Override
        public final Builder serverCertificateArn(String serverCertificateArn) {
            this.serverCertificateArn = serverCertificateArn;
            return this;
        }

        public final void setServerCertificateArn(String serverCertificateArn) {
            this.serverCertificateArn = serverCertificateArn;
        }

        public final Collection<ClientVpnAuthentication.Builder> getAuthenticationOptions() {
            return this.authenticationOptions != null ? (Collection)this.authenticationOptions.stream().map(ClientVpnAuthentication::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder authenticationOptions(Collection<ClientVpnAuthentication> authenticationOptions) {
            this.authenticationOptions = ClientVpnAuthenticationListCopier.copy(authenticationOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authenticationOptions(ClientVpnAuthentication ... authenticationOptions) {
            this.authenticationOptions(Arrays.asList(authenticationOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authenticationOptions(Consumer<ClientVpnAuthentication.Builder> ... authenticationOptions) {
            this.authenticationOptions(Stream.of(authenticationOptions).map(c -> (ClientVpnAuthentication)((ClientVpnAuthentication.Builder)ClientVpnAuthentication.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAuthenticationOptions(Collection<ClientVpnAuthentication.BuilderImpl> authenticationOptions) {
            this.authenticationOptions = ClientVpnAuthenticationListCopier.copyFromBuilder(authenticationOptions);
        }

        public final ConnectionLogResponseOptions.Builder getConnectionLogOptions() {
            return this.connectionLogOptions != null ? this.connectionLogOptions.toBuilder() : null;
        }

        @Override
        public final Builder connectionLogOptions(ConnectionLogResponseOptions connectionLogOptions) {
            this.connectionLogOptions = connectionLogOptions;
            return this;
        }

        public final void setConnectionLogOptions(ConnectionLogResponseOptions.BuilderImpl connectionLogOptions) {
            this.connectionLogOptions = connectionLogOptions != null ? connectionLogOptions.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public ClientVpnEndpoint build() {
            return new ClientVpnEndpoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClientVpnEndpoint> {
        public Builder clientVpnEndpointId(String var1);

        public Builder description(String var1);

        public Builder status(ClientVpnEndpointStatus var1);

        default public Builder status(Consumer<ClientVpnEndpointStatus.Builder> status) {
            return this.status((ClientVpnEndpointStatus)((ClientVpnEndpointStatus.Builder)ClientVpnEndpointStatus.builder().applyMutation(status)).build());
        }

        public Builder creationTime(String var1);

        public Builder deletionTime(String var1);

        public Builder dnsName(String var1);

        public Builder clientCidrBlock(String var1);

        public Builder dnsServers(Collection<String> var1);

        public Builder dnsServers(String ... var1);

        public Builder splitTunnel(Boolean var1);

        public Builder vpnProtocol(String var1);

        public Builder vpnProtocol(VpnProtocol var1);

        public Builder transportProtocol(String var1);

        public Builder transportProtocol(TransportProtocol var1);

        public Builder associatedTargetNetworks(Collection<AssociatedTargetNetwork> var1);

        public Builder associatedTargetNetworks(AssociatedTargetNetwork ... var1);

        public Builder associatedTargetNetworks(Consumer<AssociatedTargetNetwork.Builder> ... var1);

        public Builder serverCertificateArn(String var1);

        public Builder authenticationOptions(Collection<ClientVpnAuthentication> var1);

        public Builder authenticationOptions(ClientVpnAuthentication ... var1);

        public Builder authenticationOptions(Consumer<ClientVpnAuthentication.Builder> ... var1);

        public Builder connectionLogOptions(ConnectionLogResponseOptions var1);

        default public Builder connectionLogOptions(Consumer<ConnectionLogResponseOptions.Builder> connectionLogOptions) {
            return this.connectionLogOptions((ConnectionLogResponseOptions)((ConnectionLogResponseOptions.Builder)ConnectionLogResponseOptions.builder().applyMutation(connectionLogOptions)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

