/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.FleetExcessCapacityTerminationPolicy;
import software.amazon.awssdk.services.ec2.model.TargetCapacitySpecificationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyFleetRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyFleetRequest> {
    private static final SdkField<String> EXCESS_CAPACITY_TERMINATION_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyFleetRequest.getter(ModifyFleetRequest::excessCapacityTerminationPolicyAsString)).setter(ModifyFleetRequest.setter(Builder::excessCapacityTerminationPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcessCapacityTerminationPolicy").unmarshallLocationName("ExcessCapacityTerminationPolicy").build()}).build();
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyFleetRequest.getter(ModifyFleetRequest::fleetId)).setter(ModifyFleetRequest.setter(Builder::fleetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").unmarshallLocationName("FleetId").build()}).build();
    private static final SdkField<TargetCapacitySpecificationRequest> TARGET_CAPACITY_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ModifyFleetRequest.getter(ModifyFleetRequest::targetCapacitySpecification)).setter(ModifyFleetRequest.setter(Builder::targetCapacitySpecification)).constructor(TargetCapacitySpecificationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetCapacitySpecification").unmarshallLocationName("TargetCapacitySpecification").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXCESS_CAPACITY_TERMINATION_POLICY_FIELD, FLEET_ID_FIELD, TARGET_CAPACITY_SPECIFICATION_FIELD));
    private final String excessCapacityTerminationPolicy;
    private final String fleetId;
    private final TargetCapacitySpecificationRequest targetCapacitySpecification;

    private ModifyFleetRequest(BuilderImpl builder) {
        super(builder);
        this.excessCapacityTerminationPolicy = builder.excessCapacityTerminationPolicy;
        this.fleetId = builder.fleetId;
        this.targetCapacitySpecification = builder.targetCapacitySpecification;
    }

    public FleetExcessCapacityTerminationPolicy excessCapacityTerminationPolicy() {
        return FleetExcessCapacityTerminationPolicy.fromValue(this.excessCapacityTerminationPolicy);
    }

    public String excessCapacityTerminationPolicyAsString() {
        return this.excessCapacityTerminationPolicy;
    }

    public String fleetId() {
        return this.fleetId;
    }

    public TargetCapacitySpecificationRequest targetCapacitySpecification() {
        return this.targetCapacitySpecification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.excessCapacityTerminationPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetCapacitySpecification());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyFleetRequest)) {
            return false;
        }
        ModifyFleetRequest other = (ModifyFleetRequest)((Object)obj);
        return Objects.equals(this.excessCapacityTerminationPolicyAsString(), other.excessCapacityTerminationPolicyAsString()) && Objects.equals(this.fleetId(), other.fleetId()) && Objects.equals(this.targetCapacitySpecification(), other.targetCapacitySpecification());
    }

    public String toString() {
        return ToString.builder((String)"ModifyFleetRequest").add("ExcessCapacityTerminationPolicy", (Object)this.excessCapacityTerminationPolicyAsString()).add("FleetId", (Object)this.fleetId()).add("TargetCapacitySpecification", (Object)this.targetCapacitySpecification()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExcessCapacityTerminationPolicy": {
                return Optional.ofNullable(clazz.cast(this.excessCapacityTerminationPolicyAsString()));
            }
            case "FleetId": {
                return Optional.ofNullable(clazz.cast(this.fleetId()));
            }
            case "TargetCapacitySpecification": {
                return Optional.ofNullable(clazz.cast(this.targetCapacitySpecification()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyFleetRequest, T> g) {
        return obj -> g.apply((ModifyFleetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String excessCapacityTerminationPolicy;
        private String fleetId;
        private TargetCapacitySpecificationRequest targetCapacitySpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyFleetRequest model) {
            super(model);
            this.excessCapacityTerminationPolicy(model.excessCapacityTerminationPolicy);
            this.fleetId(model.fleetId);
            this.targetCapacitySpecification(model.targetCapacitySpecification);
        }

        public final String getExcessCapacityTerminationPolicyAsString() {
            return this.excessCapacityTerminationPolicy;
        }

        @Override
        public final Builder excessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
            return this;
        }

        @Override
        public final Builder excessCapacityTerminationPolicy(FleetExcessCapacityTerminationPolicy excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy(excessCapacityTerminationPolicy.toString());
            return this;
        }

        public final void setExcessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final TargetCapacitySpecificationRequest.Builder getTargetCapacitySpecification() {
            return this.targetCapacitySpecification != null ? this.targetCapacitySpecification.toBuilder() : null;
        }

        @Override
        public final Builder targetCapacitySpecification(TargetCapacitySpecificationRequest targetCapacitySpecification) {
            this.targetCapacitySpecification = targetCapacitySpecification;
            return this;
        }

        public final void setTargetCapacitySpecification(TargetCapacitySpecificationRequest.BuilderImpl targetCapacitySpecification) {
            this.targetCapacitySpecification = targetCapacitySpecification != null ? targetCapacitySpecification.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyFleetRequest build() {
            return new ModifyFleetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyFleetRequest> {
        public Builder excessCapacityTerminationPolicy(String var1);

        public Builder excessCapacityTerminationPolicy(FleetExcessCapacityTerminationPolicy var1);

        public Builder fleetId(String var1);

        public Builder targetCapacitySpecification(TargetCapacitySpecificationRequest var1);

        default public Builder targetCapacitySpecification(Consumer<TargetCapacitySpecificationRequest.Builder> targetCapacitySpecification) {
            return this.targetCapacitySpecification((TargetCapacitySpecificationRequest)((TargetCapacitySpecificationRequest.Builder)TargetCapacitySpecificationRequest.builder().applyMutation(targetCapacitySpecification)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

