/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceSpecification> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceSpecification.getter(InstanceSpecification::instanceId)).setter(InstanceSpecification.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").unmarshallLocationName("InstanceId").build()}).build();
    private static final SdkField<Boolean> EXCLUDE_BOOT_VOLUME_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(InstanceSpecification.getter(InstanceSpecification::excludeBootVolume)).setter(InstanceSpecification.setter(Builder::excludeBootVolume)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeBootVolume").unmarshallLocationName("ExcludeBootVolume").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, EXCLUDE_BOOT_VOLUME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String instanceId;
    private final Boolean excludeBootVolume;

    private InstanceSpecification(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.excludeBootVolume = builder.excludeBootVolume;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public Boolean excludeBootVolume() {
        return this.excludeBootVolume;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.excludeBootVolume());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceSpecification)) {
            return false;
        }
        InstanceSpecification other = (InstanceSpecification)obj;
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.excludeBootVolume(), other.excludeBootVolume());
    }

    public String toString() {
        return ToString.builder((String)"InstanceSpecification").add("InstanceId", (Object)this.instanceId()).add("ExcludeBootVolume", (Object)this.excludeBootVolume()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "ExcludeBootVolume": {
                return Optional.ofNullable(clazz.cast(this.excludeBootVolume()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceSpecification, T> g) {
        return obj -> g.apply((InstanceSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private Boolean excludeBootVolume;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceSpecification model) {
            this.instanceId(model.instanceId);
            this.excludeBootVolume(model.excludeBootVolume);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Boolean getExcludeBootVolume() {
            return this.excludeBootVolume;
        }

        @Override
        public final Builder excludeBootVolume(Boolean excludeBootVolume) {
            this.excludeBootVolume = excludeBootVolume;
            return this;
        }

        public final void setExcludeBootVolume(Boolean excludeBootVolume) {
            this.excludeBootVolume = excludeBootVolume;
        }

        public InstanceSpecification build() {
            return new InstanceSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceSpecification> {
        public Builder instanceId(String var1);

        public Builder excludeBootVolume(Boolean var1);
    }
}

