/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.ClientVpnAuthorizationRuleStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuthorizationRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AuthorizationRule> {
    private static final SdkField<String> CLIENT_VPN_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AuthorizationRule.getter(AuthorizationRule::clientVpnEndpointId)).setter(AuthorizationRule.setter(Builder::clientVpnEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientVpnEndpointId").unmarshallLocationName("clientVpnEndpointId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AuthorizationRule.getter(AuthorizationRule::description)).setter(AuthorizationRule.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<String> GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AuthorizationRule.getter(AuthorizationRule::groupId)).setter(AuthorizationRule.setter(Builder::groupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").unmarshallLocationName("groupId").build()}).build();
    private static final SdkField<Boolean> ACCESS_ALL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(AuthorizationRule.getter(AuthorizationRule::accessAll)).setter(AuthorizationRule.setter(Builder::accessAll)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessAll").unmarshallLocationName("accessAll").build()}).build();
    private static final SdkField<String> DESTINATION_CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AuthorizationRule.getter(AuthorizationRule::destinationCidr)).setter(AuthorizationRule.setter(Builder::destinationCidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCidr").unmarshallLocationName("destinationCidr").build()}).build();
    private static final SdkField<ClientVpnAuthorizationRuleStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(AuthorizationRule.getter(AuthorizationRule::status)).setter(AuthorizationRule.setter(Builder::status)).constructor(ClientVpnAuthorizationRuleStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_VPN_ENDPOINT_ID_FIELD, DESCRIPTION_FIELD, GROUP_ID_FIELD, ACCESS_ALL_FIELD, DESTINATION_CIDR_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String clientVpnEndpointId;
    private final String description;
    private final String groupId;
    private final Boolean accessAll;
    private final String destinationCidr;
    private final ClientVpnAuthorizationRuleStatus status;

    private AuthorizationRule(BuilderImpl builder) {
        this.clientVpnEndpointId = builder.clientVpnEndpointId;
        this.description = builder.description;
        this.groupId = builder.groupId;
        this.accessAll = builder.accessAll;
        this.destinationCidr = builder.destinationCidr;
        this.status = builder.status;
    }

    public String clientVpnEndpointId() {
        return this.clientVpnEndpointId;
    }

    public String description() {
        return this.description;
    }

    public String groupId() {
        return this.groupId;
    }

    public Boolean accessAll() {
        return this.accessAll;
    }

    public String destinationCidr() {
        return this.destinationCidr;
    }

    public ClientVpnAuthorizationRuleStatus status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientVpnEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessAll());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationCidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthorizationRule)) {
            return false;
        }
        AuthorizationRule other = (AuthorizationRule)obj;
        return Objects.equals(this.clientVpnEndpointId(), other.clientVpnEndpointId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.groupId(), other.groupId()) && Objects.equals(this.accessAll(), other.accessAll()) && Objects.equals(this.destinationCidr(), other.destinationCidr()) && Objects.equals(this.status(), other.status());
    }

    public String toString() {
        return ToString.builder((String)"AuthorizationRule").add("ClientVpnEndpointId", (Object)this.clientVpnEndpointId()).add("Description", (Object)this.description()).add("GroupId", (Object)this.groupId()).add("AccessAll", (Object)this.accessAll()).add("DestinationCidr", (Object)this.destinationCidr()).add("Status", (Object)this.status()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientVpnEndpointId": {
                return Optional.ofNullable(clazz.cast(this.clientVpnEndpointId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "GroupId": {
                return Optional.ofNullable(clazz.cast(this.groupId()));
            }
            case "AccessAll": {
                return Optional.ofNullable(clazz.cast(this.accessAll()));
            }
            case "DestinationCidr": {
                return Optional.ofNullable(clazz.cast(this.destinationCidr()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AuthorizationRule, T> g) {
        return obj -> g.apply((AuthorizationRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clientVpnEndpointId;
        private String description;
        private String groupId;
        private Boolean accessAll;
        private String destinationCidr;
        private ClientVpnAuthorizationRuleStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthorizationRule model) {
            this.clientVpnEndpointId(model.clientVpnEndpointId);
            this.description(model.description);
            this.groupId(model.groupId);
            this.accessAll(model.accessAll);
            this.destinationCidr(model.destinationCidr);
            this.status(model.status);
        }

        public final String getClientVpnEndpointId() {
            return this.clientVpnEndpointId;
        }

        @Override
        public final Builder clientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
            return this;
        }

        public final void setClientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getGroupId() {
            return this.groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public final Boolean getAccessAll() {
            return this.accessAll;
        }

        @Override
        public final Builder accessAll(Boolean accessAll) {
            this.accessAll = accessAll;
            return this;
        }

        public final void setAccessAll(Boolean accessAll) {
            this.accessAll = accessAll;
        }

        public final String getDestinationCidr() {
            return this.destinationCidr;
        }

        @Override
        public final Builder destinationCidr(String destinationCidr) {
            this.destinationCidr = destinationCidr;
            return this;
        }

        public final void setDestinationCidr(String destinationCidr) {
            this.destinationCidr = destinationCidr;
        }

        public final ClientVpnAuthorizationRuleStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        @Override
        public final Builder status(ClientVpnAuthorizationRuleStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(ClientVpnAuthorizationRuleStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public AuthorizationRule build() {
            return new AuthorizationRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AuthorizationRule> {
        public Builder clientVpnEndpointId(String var1);

        public Builder description(String var1);

        public Builder groupId(String var1);

        public Builder accessAll(Boolean var1);

        public Builder destinationCidr(String var1);

        public Builder status(ClientVpnAuthorizationRuleStatus var1);

        default public Builder status(Consumer<ClientVpnAuthorizationRuleStatus.Builder> status) {
            return this.status((ClientVpnAuthorizationRuleStatus)((ClientVpnAuthorizationRuleStatus.Builder)ClientVpnAuthorizationRuleStatus.builder().applyMutation(status)).build());
        }
    }
}

