/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.PropagatingVgw;
import software.amazon.awssdk.services.ec2.model.PropagatingVgwListCopier;
import software.amazon.awssdk.services.ec2.model.Route;
import software.amazon.awssdk.services.ec2.model.RouteListCopier;
import software.amazon.awssdk.services.ec2.model.RouteTableAssociation;
import software.amazon.awssdk.services.ec2.model.RouteTableAssociationListCopier;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouteTable
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouteTable> {
    private static final SdkField<List<RouteTableAssociation>> ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(RouteTable.getter(RouteTable::associations)).setter(RouteTable.setter(Builder::associations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationSet").unmarshallLocationName("associationSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouteTableAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<PropagatingVgw>> PROPAGATING_VGWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(RouteTable.getter(RouteTable::propagatingVgws)).setter(RouteTable.setter(Builder::propagatingVgws)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropagatingVgwSet").unmarshallLocationName("propagatingVgwSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PropagatingVgw::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> ROUTE_TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RouteTable.getter(RouteTable::routeTableId)).setter(RouteTable.setter(Builder::routeTableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableId").unmarshallLocationName("routeTableId").build()}).build();
    private static final SdkField<List<Route>> ROUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(RouteTable.getter(RouteTable::routes)).setter(RouteTable.setter(Builder::routes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteSet").unmarshallLocationName("routeSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Route::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(RouteTable.getter(RouteTable::tags)).setter(RouteTable.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RouteTable.getter(RouteTable::vpcId)).setter(RouteTable.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").unmarshallLocationName("vpcId").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RouteTable.getter(RouteTable::ownerId)).setter(RouteTable.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").unmarshallLocationName("ownerId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATIONS_FIELD, PROPAGATING_VGWS_FIELD, ROUTE_TABLE_ID_FIELD, ROUTES_FIELD, TAGS_FIELD, VPC_ID_FIELD, OWNER_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<RouteTableAssociation> associations;
    private final List<PropagatingVgw> propagatingVgws;
    private final String routeTableId;
    private final List<Route> routes;
    private final List<Tag> tags;
    private final String vpcId;
    private final String ownerId;

    private RouteTable(BuilderImpl builder) {
        this.associations = builder.associations;
        this.propagatingVgws = builder.propagatingVgws;
        this.routeTableId = builder.routeTableId;
        this.routes = builder.routes;
        this.tags = builder.tags;
        this.vpcId = builder.vpcId;
        this.ownerId = builder.ownerId;
    }

    public List<RouteTableAssociation> associations() {
        return this.associations;
    }

    public List<PropagatingVgw> propagatingVgws() {
        return this.propagatingVgws;
    }

    public String routeTableId() {
        return this.routeTableId;
    }

    public List<Route> routes() {
        return this.routes;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public String ownerId() {
        return this.ownerId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.associations());
        hashCode = 31 * hashCode + Objects.hashCode(this.propagatingVgws());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeTableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.routes());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteTable)) {
            return false;
        }
        RouteTable other = (RouteTable)obj;
        return Objects.equals(this.associations(), other.associations()) && Objects.equals(this.propagatingVgws(), other.propagatingVgws()) && Objects.equals(this.routeTableId(), other.routeTableId()) && Objects.equals(this.routes(), other.routes()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.ownerId(), other.ownerId());
    }

    public String toString() {
        return ToString.builder((String)"RouteTable").add("Associations", this.associations()).add("PropagatingVgws", this.propagatingVgws()).add("RouteTableId", (Object)this.routeTableId()).add("Routes", this.routes()).add("Tags", this.tags()).add("VpcId", (Object)this.vpcId()).add("OwnerId", (Object)this.ownerId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Associations": {
                return Optional.ofNullable(clazz.cast(this.associations()));
            }
            case "PropagatingVgws": {
                return Optional.ofNullable(clazz.cast(this.propagatingVgws()));
            }
            case "RouteTableId": {
                return Optional.ofNullable(clazz.cast(this.routeTableId()));
            }
            case "Routes": {
                return Optional.ofNullable(clazz.cast(this.routes()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RouteTable, T> g) {
        return obj -> g.apply((RouteTable)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<RouteTableAssociation> associations = DefaultSdkAutoConstructList.getInstance();
        private List<PropagatingVgw> propagatingVgws = DefaultSdkAutoConstructList.getInstance();
        private String routeTableId;
        private List<Route> routes = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String vpcId;
        private String ownerId;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteTable model) {
            this.associations(model.associations);
            this.propagatingVgws(model.propagatingVgws);
            this.routeTableId(model.routeTableId);
            this.routes(model.routes);
            this.tags(model.tags);
            this.vpcId(model.vpcId);
            this.ownerId(model.ownerId);
        }

        public final Collection<RouteTableAssociation.Builder> getAssociations() {
            return this.associations != null ? (Collection)this.associations.stream().map(RouteTableAssociation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder associations(Collection<RouteTableAssociation> associations) {
            this.associations = RouteTableAssociationListCopier.copy(associations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(RouteTableAssociation ... associations) {
            this.associations(Arrays.asList(associations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(Consumer<RouteTableAssociation.Builder> ... associations) {
            this.associations(Stream.of(associations).map(c -> (RouteTableAssociation)((RouteTableAssociation.Builder)RouteTableAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAssociations(Collection<RouteTableAssociation.BuilderImpl> associations) {
            this.associations = RouteTableAssociationListCopier.copyFromBuilder(associations);
        }

        public final Collection<PropagatingVgw.Builder> getPropagatingVgws() {
            return this.propagatingVgws != null ? (Collection)this.propagatingVgws.stream().map(PropagatingVgw::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder propagatingVgws(Collection<PropagatingVgw> propagatingVgws) {
            this.propagatingVgws = PropagatingVgwListCopier.copy(propagatingVgws);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propagatingVgws(PropagatingVgw ... propagatingVgws) {
            this.propagatingVgws(Arrays.asList(propagatingVgws));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propagatingVgws(Consumer<PropagatingVgw.Builder> ... propagatingVgws) {
            this.propagatingVgws(Stream.of(propagatingVgws).map(c -> (PropagatingVgw)((PropagatingVgw.Builder)PropagatingVgw.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPropagatingVgws(Collection<PropagatingVgw.BuilderImpl> propagatingVgws) {
            this.propagatingVgws = PropagatingVgwListCopier.copyFromBuilder(propagatingVgws);
        }

        public final String getRouteTableId() {
            return this.routeTableId;
        }

        @Override
        public final Builder routeTableId(String routeTableId) {
            this.routeTableId = routeTableId;
            return this;
        }

        public final void setRouteTableId(String routeTableId) {
            this.routeTableId = routeTableId;
        }

        public final Collection<Route.Builder> getRoutes() {
            return this.routes != null ? (Collection)this.routes.stream().map(Route::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder routes(Collection<Route> routes) {
            this.routes = RouteListCopier.copy(routes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(Route ... routes) {
            this.routes(Arrays.asList(routes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(Consumer<Route.Builder> ... routes) {
            this.routes(Stream.of(routes).map(c -> (Route)((Route.Builder)Route.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRoutes(Collection<Route.BuilderImpl> routes) {
            this.routes = RouteListCopier.copyFromBuilder(routes);
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public RouteTable build() {
            return new RouteTable(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouteTable> {
        public Builder associations(Collection<RouteTableAssociation> var1);

        public Builder associations(RouteTableAssociation ... var1);

        public Builder associations(Consumer<RouteTableAssociation.Builder> ... var1);

        public Builder propagatingVgws(Collection<PropagatingVgw> var1);

        public Builder propagatingVgws(PropagatingVgw ... var1);

        public Builder propagatingVgws(Consumer<PropagatingVgw.Builder> ... var1);

        public Builder routeTableId(String var1);

        public Builder routes(Collection<Route> var1);

        public Builder routes(Route ... var1);

        public Builder routes(Consumer<Route.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder vpcId(String var1);

        public Builder ownerId(String var1);
    }
}

