/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportClientVpnClientCertificateRevocationListRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ImportClientVpnClientCertificateRevocationListRequest> {
    private static final SdkField<String> CLIENT_VPN_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImportClientVpnClientCertificateRevocationListRequest.getter(ImportClientVpnClientCertificateRevocationListRequest::clientVpnEndpointId)).setter(ImportClientVpnClientCertificateRevocationListRequest.setter(Builder::clientVpnEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientVpnEndpointId").unmarshallLocationName("ClientVpnEndpointId").build()}).build();
    private static final SdkField<String> CERTIFICATE_REVOCATION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImportClientVpnClientCertificateRevocationListRequest.getter(ImportClientVpnClientCertificateRevocationListRequest::certificateRevocationList)).setter(ImportClientVpnClientCertificateRevocationListRequest.setter(Builder::certificateRevocationList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateRevocationList").unmarshallLocationName("CertificateRevocationList").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_VPN_ENDPOINT_ID_FIELD, CERTIFICATE_REVOCATION_LIST_FIELD));
    private final String clientVpnEndpointId;
    private final String certificateRevocationList;

    private ImportClientVpnClientCertificateRevocationListRequest(BuilderImpl builder) {
        super(builder);
        this.clientVpnEndpointId = builder.clientVpnEndpointId;
        this.certificateRevocationList = builder.certificateRevocationList;
    }

    public String clientVpnEndpointId() {
        return this.clientVpnEndpointId;
    }

    public String certificateRevocationList() {
        return this.certificateRevocationList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientVpnEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateRevocationList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportClientVpnClientCertificateRevocationListRequest)) {
            return false;
        }
        ImportClientVpnClientCertificateRevocationListRequest other = (ImportClientVpnClientCertificateRevocationListRequest)((Object)obj);
        return Objects.equals(this.clientVpnEndpointId(), other.clientVpnEndpointId()) && Objects.equals(this.certificateRevocationList(), other.certificateRevocationList());
    }

    public String toString() {
        return ToString.builder((String)"ImportClientVpnClientCertificateRevocationListRequest").add("ClientVpnEndpointId", (Object)this.clientVpnEndpointId()).add("CertificateRevocationList", (Object)this.certificateRevocationList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientVpnEndpointId": {
                return Optional.ofNullable(clazz.cast(this.clientVpnEndpointId()));
            }
            case "CertificateRevocationList": {
                return Optional.ofNullable(clazz.cast(this.certificateRevocationList()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportClientVpnClientCertificateRevocationListRequest, T> g) {
        return obj -> g.apply((ImportClientVpnClientCertificateRevocationListRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String clientVpnEndpointId;
        private String certificateRevocationList;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportClientVpnClientCertificateRevocationListRequest model) {
            super(model);
            this.clientVpnEndpointId(model.clientVpnEndpointId);
            this.certificateRevocationList(model.certificateRevocationList);
        }

        public final String getClientVpnEndpointId() {
            return this.clientVpnEndpointId;
        }

        @Override
        public final Builder clientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
            return this;
        }

        public final void setClientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
        }

        public final String getCertificateRevocationList() {
            return this.certificateRevocationList;
        }

        @Override
        public final Builder certificateRevocationList(String certificateRevocationList) {
            this.certificateRevocationList = certificateRevocationList;
            return this;
        }

        public final void setCertificateRevocationList(String certificateRevocationList) {
            this.certificateRevocationList = certificateRevocationList;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportClientVpnClientCertificateRevocationListRequest build() {
            return new ImportClientVpnClientCertificateRevocationListRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ImportClientVpnClientCertificateRevocationListRequest> {
        public Builder clientVpnEndpointId(String var1);

        public Builder certificateRevocationList(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

