/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.AutoAcceptSharedAttachmentsValue;
import software.amazon.awssdk.services.ec2.model.DefaultRouteTableAssociationValue;
import software.amazon.awssdk.services.ec2.model.DefaultRouteTablePropagationValue;
import software.amazon.awssdk.services.ec2.model.DnsSupportValue;
import software.amazon.awssdk.services.ec2.model.VpnEcmpSupportValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransitGatewayRequestOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransitGatewayRequestOptions> {
    private static final SdkField<Long> AMAZON_SIDE_ASN_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(TransitGatewayRequestOptions.getter(TransitGatewayRequestOptions::amazonSideAsn)).setter(TransitGatewayRequestOptions.setter(Builder::amazonSideAsn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmazonSideAsn").unmarshallLocationName("AmazonSideAsn").build()}).build();
    private static final SdkField<String> AUTO_ACCEPT_SHARED_ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TransitGatewayRequestOptions.getter(TransitGatewayRequestOptions::autoAcceptSharedAttachmentsAsString)).setter(TransitGatewayRequestOptions.setter(Builder::autoAcceptSharedAttachments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoAcceptSharedAttachments").unmarshallLocationName("AutoAcceptSharedAttachments").build()}).build();
    private static final SdkField<String> DEFAULT_ROUTE_TABLE_ASSOCIATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TransitGatewayRequestOptions.getter(TransitGatewayRequestOptions::defaultRouteTableAssociationAsString)).setter(TransitGatewayRequestOptions.setter(Builder::defaultRouteTableAssociation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRouteTableAssociation").unmarshallLocationName("DefaultRouteTableAssociation").build()}).build();
    private static final SdkField<String> DEFAULT_ROUTE_TABLE_PROPAGATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TransitGatewayRequestOptions.getter(TransitGatewayRequestOptions::defaultRouteTablePropagationAsString)).setter(TransitGatewayRequestOptions.setter(Builder::defaultRouteTablePropagation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRouteTablePropagation").unmarshallLocationName("DefaultRouteTablePropagation").build()}).build();
    private static final SdkField<String> VPN_ECMP_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TransitGatewayRequestOptions.getter(TransitGatewayRequestOptions::vpnEcmpSupportAsString)).setter(TransitGatewayRequestOptions.setter(Builder::vpnEcmpSupport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnEcmpSupport").unmarshallLocationName("VpnEcmpSupport").build()}).build();
    private static final SdkField<String> DNS_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TransitGatewayRequestOptions.getter(TransitGatewayRequestOptions::dnsSupportAsString)).setter(TransitGatewayRequestOptions.setter(Builder::dnsSupport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsSupport").unmarshallLocationName("DnsSupport").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMAZON_SIDE_ASN_FIELD, AUTO_ACCEPT_SHARED_ATTACHMENTS_FIELD, DEFAULT_ROUTE_TABLE_ASSOCIATION_FIELD, DEFAULT_ROUTE_TABLE_PROPAGATION_FIELD, VPN_ECMP_SUPPORT_FIELD, DNS_SUPPORT_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long amazonSideAsn;
    private final String autoAcceptSharedAttachments;
    private final String defaultRouteTableAssociation;
    private final String defaultRouteTablePropagation;
    private final String vpnEcmpSupport;
    private final String dnsSupport;

    private TransitGatewayRequestOptions(BuilderImpl builder) {
        this.amazonSideAsn = builder.amazonSideAsn;
        this.autoAcceptSharedAttachments = builder.autoAcceptSharedAttachments;
        this.defaultRouteTableAssociation = builder.defaultRouteTableAssociation;
        this.defaultRouteTablePropagation = builder.defaultRouteTablePropagation;
        this.vpnEcmpSupport = builder.vpnEcmpSupport;
        this.dnsSupport = builder.dnsSupport;
    }

    public Long amazonSideAsn() {
        return this.amazonSideAsn;
    }

    public AutoAcceptSharedAttachmentsValue autoAcceptSharedAttachments() {
        return AutoAcceptSharedAttachmentsValue.fromValue(this.autoAcceptSharedAttachments);
    }

    public String autoAcceptSharedAttachmentsAsString() {
        return this.autoAcceptSharedAttachments;
    }

    public DefaultRouteTableAssociationValue defaultRouteTableAssociation() {
        return DefaultRouteTableAssociationValue.fromValue(this.defaultRouteTableAssociation);
    }

    public String defaultRouteTableAssociationAsString() {
        return this.defaultRouteTableAssociation;
    }

    public DefaultRouteTablePropagationValue defaultRouteTablePropagation() {
        return DefaultRouteTablePropagationValue.fromValue(this.defaultRouteTablePropagation);
    }

    public String defaultRouteTablePropagationAsString() {
        return this.defaultRouteTablePropagation;
    }

    public VpnEcmpSupportValue vpnEcmpSupport() {
        return VpnEcmpSupportValue.fromValue(this.vpnEcmpSupport);
    }

    public String vpnEcmpSupportAsString() {
        return this.vpnEcmpSupport;
    }

    public DnsSupportValue dnsSupport() {
        return DnsSupportValue.fromValue(this.dnsSupport);
    }

    public String dnsSupportAsString() {
        return this.dnsSupport;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.amazonSideAsn());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoAcceptSharedAttachmentsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultRouteTableAssociationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultRouteTablePropagationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpnEcmpSupportAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsSupportAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayRequestOptions)) {
            return false;
        }
        TransitGatewayRequestOptions other = (TransitGatewayRequestOptions)obj;
        return Objects.equals(this.amazonSideAsn(), other.amazonSideAsn()) && Objects.equals(this.autoAcceptSharedAttachmentsAsString(), other.autoAcceptSharedAttachmentsAsString()) && Objects.equals(this.defaultRouteTableAssociationAsString(), other.defaultRouteTableAssociationAsString()) && Objects.equals(this.defaultRouteTablePropagationAsString(), other.defaultRouteTablePropagationAsString()) && Objects.equals(this.vpnEcmpSupportAsString(), other.vpnEcmpSupportAsString()) && Objects.equals(this.dnsSupportAsString(), other.dnsSupportAsString());
    }

    public String toString() {
        return ToString.builder((String)"TransitGatewayRequestOptions").add("AmazonSideAsn", (Object)this.amazonSideAsn()).add("AutoAcceptSharedAttachments", (Object)this.autoAcceptSharedAttachmentsAsString()).add("DefaultRouteTableAssociation", (Object)this.defaultRouteTableAssociationAsString()).add("DefaultRouteTablePropagation", (Object)this.defaultRouteTablePropagationAsString()).add("VpnEcmpSupport", (Object)this.vpnEcmpSupportAsString()).add("DnsSupport", (Object)this.dnsSupportAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AmazonSideAsn": {
                return Optional.ofNullable(clazz.cast(this.amazonSideAsn()));
            }
            case "AutoAcceptSharedAttachments": {
                return Optional.ofNullable(clazz.cast(this.autoAcceptSharedAttachmentsAsString()));
            }
            case "DefaultRouteTableAssociation": {
                return Optional.ofNullable(clazz.cast(this.defaultRouteTableAssociationAsString()));
            }
            case "DefaultRouteTablePropagation": {
                return Optional.ofNullable(clazz.cast(this.defaultRouteTablePropagationAsString()));
            }
            case "VpnEcmpSupport": {
                return Optional.ofNullable(clazz.cast(this.vpnEcmpSupportAsString()));
            }
            case "DnsSupport": {
                return Optional.ofNullable(clazz.cast(this.dnsSupportAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayRequestOptions, T> g) {
        return obj -> g.apply((TransitGatewayRequestOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long amazonSideAsn;
        private String autoAcceptSharedAttachments;
        private String defaultRouteTableAssociation;
        private String defaultRouteTablePropagation;
        private String vpnEcmpSupport;
        private String dnsSupport;

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayRequestOptions model) {
            this.amazonSideAsn(model.amazonSideAsn);
            this.autoAcceptSharedAttachments(model.autoAcceptSharedAttachments);
            this.defaultRouteTableAssociation(model.defaultRouteTableAssociation);
            this.defaultRouteTablePropagation(model.defaultRouteTablePropagation);
            this.vpnEcmpSupport(model.vpnEcmpSupport);
            this.dnsSupport(model.dnsSupport);
        }

        public final Long getAmazonSideAsn() {
            return this.amazonSideAsn;
        }

        @Override
        public final Builder amazonSideAsn(Long amazonSideAsn) {
            this.amazonSideAsn = amazonSideAsn;
            return this;
        }

        public final void setAmazonSideAsn(Long amazonSideAsn) {
            this.amazonSideAsn = amazonSideAsn;
        }

        public final String getAutoAcceptSharedAttachmentsAsString() {
            return this.autoAcceptSharedAttachments;
        }

        @Override
        public final Builder autoAcceptSharedAttachments(String autoAcceptSharedAttachments) {
            this.autoAcceptSharedAttachments = autoAcceptSharedAttachments;
            return this;
        }

        @Override
        public final Builder autoAcceptSharedAttachments(AutoAcceptSharedAttachmentsValue autoAcceptSharedAttachments) {
            this.autoAcceptSharedAttachments(autoAcceptSharedAttachments.toString());
            return this;
        }

        public final void setAutoAcceptSharedAttachments(String autoAcceptSharedAttachments) {
            this.autoAcceptSharedAttachments = autoAcceptSharedAttachments;
        }

        public final String getDefaultRouteTableAssociationAsString() {
            return this.defaultRouteTableAssociation;
        }

        @Override
        public final Builder defaultRouteTableAssociation(String defaultRouteTableAssociation) {
            this.defaultRouteTableAssociation = defaultRouteTableAssociation;
            return this;
        }

        @Override
        public final Builder defaultRouteTableAssociation(DefaultRouteTableAssociationValue defaultRouteTableAssociation) {
            this.defaultRouteTableAssociation(defaultRouteTableAssociation.toString());
            return this;
        }

        public final void setDefaultRouteTableAssociation(String defaultRouteTableAssociation) {
            this.defaultRouteTableAssociation = defaultRouteTableAssociation;
        }

        public final String getDefaultRouteTablePropagationAsString() {
            return this.defaultRouteTablePropagation;
        }

        @Override
        public final Builder defaultRouteTablePropagation(String defaultRouteTablePropagation) {
            this.defaultRouteTablePropagation = defaultRouteTablePropagation;
            return this;
        }

        @Override
        public final Builder defaultRouteTablePropagation(DefaultRouteTablePropagationValue defaultRouteTablePropagation) {
            this.defaultRouteTablePropagation(defaultRouteTablePropagation.toString());
            return this;
        }

        public final void setDefaultRouteTablePropagation(String defaultRouteTablePropagation) {
            this.defaultRouteTablePropagation = defaultRouteTablePropagation;
        }

        public final String getVpnEcmpSupportAsString() {
            return this.vpnEcmpSupport;
        }

        @Override
        public final Builder vpnEcmpSupport(String vpnEcmpSupport) {
            this.vpnEcmpSupport = vpnEcmpSupport;
            return this;
        }

        @Override
        public final Builder vpnEcmpSupport(VpnEcmpSupportValue vpnEcmpSupport) {
            this.vpnEcmpSupport(vpnEcmpSupport.toString());
            return this;
        }

        public final void setVpnEcmpSupport(String vpnEcmpSupport) {
            this.vpnEcmpSupport = vpnEcmpSupport;
        }

        public final String getDnsSupportAsString() {
            return this.dnsSupport;
        }

        @Override
        public final Builder dnsSupport(String dnsSupport) {
            this.dnsSupport = dnsSupport;
            return this;
        }

        @Override
        public final Builder dnsSupport(DnsSupportValue dnsSupport) {
            this.dnsSupport(dnsSupport.toString());
            return this;
        }

        public final void setDnsSupport(String dnsSupport) {
            this.dnsSupport = dnsSupport;
        }

        public TransitGatewayRequestOptions build() {
            return new TransitGatewayRequestOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransitGatewayRequestOptions> {
        public Builder amazonSideAsn(Long var1);

        public Builder autoAcceptSharedAttachments(String var1);

        public Builder autoAcceptSharedAttachments(AutoAcceptSharedAttachmentsValue var1);

        public Builder defaultRouteTableAssociation(String var1);

        public Builder defaultRouteTableAssociation(DefaultRouteTableAssociationValue var1);

        public Builder defaultRouteTablePropagation(String var1);

        public Builder defaultRouteTablePropagation(DefaultRouteTablePropagationValue var1);

        public Builder vpnEcmpSupport(String var1);

        public Builder vpnEcmpSupport(VpnEcmpSupportValue var1);

        public Builder dnsSupport(String var1);

        public Builder dnsSupport(DnsSupportValue var1);
    }
}

