/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ImageTypeValues {
    MACHINE("machine"),
    KERNEL("kernel"),
    RAMDISK("ramdisk"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ImageTypeValues(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ImageTypeValues fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ImageTypeValues.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ImageTypeValues> knownValues() {
        return Stream.of(ImageTypeValues.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

