/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ActiveInstance;
import software.amazon.awssdk.services.ec2.model.ActiveInstanceSetCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSpotFleetInstancesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeSpotFleetInstancesResponse> {
    private static final SdkField<List<ActiveInstance>> ACTIVE_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeSpotFleetInstancesResponse.getter(DescribeSpotFleetInstancesResponse::activeInstances)).setter(DescribeSpotFleetInstancesResponse.setter(Builder::activeInstances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveInstanceSet").unmarshallLocationName("activeInstanceSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ActiveInstance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeSpotFleetInstancesResponse.getter(DescribeSpotFleetInstancesResponse::nextToken)).setter(DescribeSpotFleetInstancesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final SdkField<String> SPOT_FLEET_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeSpotFleetInstancesResponse.getter(DescribeSpotFleetInstancesResponse::spotFleetRequestId)).setter(DescribeSpotFleetInstancesResponse.setter(Builder::spotFleetRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotFleetRequestId").unmarshallLocationName("spotFleetRequestId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_INSTANCES_FIELD, NEXT_TOKEN_FIELD, SPOT_FLEET_REQUEST_ID_FIELD));
    private final List<ActiveInstance> activeInstances;
    private final String nextToken;
    private final String spotFleetRequestId;

    private DescribeSpotFleetInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.activeInstances = builder.activeInstances;
        this.nextToken = builder.nextToken;
        this.spotFleetRequestId = builder.spotFleetRequestId;
    }

    public List<ActiveInstance> activeInstances() {
        return this.activeInstances;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public String spotFleetRequestId() {
        return this.spotFleetRequestId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.activeInstances());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.spotFleetRequestId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSpotFleetInstancesResponse)) {
            return false;
        }
        DescribeSpotFleetInstancesResponse other = (DescribeSpotFleetInstancesResponse)((Object)obj);
        return Objects.equals(this.activeInstances(), other.activeInstances()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.spotFleetRequestId(), other.spotFleetRequestId());
    }

    public String toString() {
        return ToString.builder((String)"DescribeSpotFleetInstancesResponse").add("ActiveInstances", this.activeInstances()).add("NextToken", (Object)this.nextToken()).add("SpotFleetRequestId", (Object)this.spotFleetRequestId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActiveInstances": {
                return Optional.ofNullable(clazz.cast(this.activeInstances()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "SpotFleetRequestId": {
                return Optional.ofNullable(clazz.cast(this.spotFleetRequestId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSpotFleetInstancesResponse, T> g) {
        return obj -> g.apply((DescribeSpotFleetInstancesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<ActiveInstance> activeInstances = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private String spotFleetRequestId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSpotFleetInstancesResponse model) {
            super(model);
            this.activeInstances(model.activeInstances);
            this.nextToken(model.nextToken);
            this.spotFleetRequestId(model.spotFleetRequestId);
        }

        public final Collection<ActiveInstance.Builder> getActiveInstances() {
            return this.activeInstances != null ? (Collection)this.activeInstances.stream().map(ActiveInstance::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder activeInstances(Collection<ActiveInstance> activeInstances) {
            this.activeInstances = ActiveInstanceSetCopier.copy(activeInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activeInstances(ActiveInstance ... activeInstances) {
            this.activeInstances(Arrays.asList(activeInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activeInstances(Consumer<ActiveInstance.Builder> ... activeInstances) {
            this.activeInstances(Stream.of(activeInstances).map(c -> (ActiveInstance)((ActiveInstance.Builder)ActiveInstance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setActiveInstances(Collection<ActiveInstance.BuilderImpl> activeInstances) {
            this.activeInstances = ActiveInstanceSetCopier.copyFromBuilder(activeInstances);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getSpotFleetRequestId() {
            return this.spotFleetRequestId;
        }

        @Override
        public final Builder spotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
            return this;
        }

        public final void setSpotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
        }

        @Override
        public DescribeSpotFleetInstancesResponse build() {
            return new DescribeSpotFleetInstancesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSpotFleetInstancesResponse> {
        public Builder activeInstances(Collection<ActiveInstance> var1);

        public Builder activeInstances(ActiveInstance ... var1);

        public Builder activeInstances(Consumer<ActiveInstance.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder spotFleetRequestId(String var1);
    }
}

