/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.DescribeFleetError;
import software.amazon.awssdk.services.ec2.model.DescribeFleetsErrorSetCopier;
import software.amazon.awssdk.services.ec2.model.DescribeFleetsInstances;
import software.amazon.awssdk.services.ec2.model.DescribeFleetsInstancesSetCopier;
import software.amazon.awssdk.services.ec2.model.FleetActivityStatus;
import software.amazon.awssdk.services.ec2.model.FleetExcessCapacityTerminationPolicy;
import software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateConfig;
import software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateConfigListCopier;
import software.amazon.awssdk.services.ec2.model.FleetStateCode;
import software.amazon.awssdk.services.ec2.model.FleetType;
import software.amazon.awssdk.services.ec2.model.OnDemandOptions;
import software.amazon.awssdk.services.ec2.model.SpotOptions;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.services.ec2.model.TargetCapacitySpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FleetData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FleetData> {
    private static final SdkField<String> ACTIVITY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FleetData.getter(FleetData::activityStatusAsString)).setter(FleetData.setter(Builder::activityStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivityStatus").unmarshallLocationName("activityStatus").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(FleetData.getter(FleetData::createTime)).setter(FleetData.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").unmarshallLocationName("createTime").build()}).build();
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FleetData.getter(FleetData::fleetId)).setter(FleetData.setter(Builder::fleetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").unmarshallLocationName("fleetId").build()}).build();
    private static final SdkField<String> FLEET_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FleetData.getter(FleetData::fleetStateAsString)).setter(FleetData.setter(Builder::fleetState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetState").unmarshallLocationName("fleetState").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FleetData.getter(FleetData::clientToken)).setter(FleetData.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("clientToken").build()}).build();
    private static final SdkField<String> EXCESS_CAPACITY_TERMINATION_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FleetData.getter(FleetData::excessCapacityTerminationPolicyAsString)).setter(FleetData.setter(Builder::excessCapacityTerminationPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcessCapacityTerminationPolicy").unmarshallLocationName("excessCapacityTerminationPolicy").build()}).build();
    private static final SdkField<Double> FULFILLED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(FleetData.getter(FleetData::fulfilledCapacity)).setter(FleetData.setter(Builder::fulfilledCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FulfilledCapacity").unmarshallLocationName("fulfilledCapacity").build()}).build();
    private static final SdkField<Double> FULFILLED_ON_DEMAND_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(FleetData.getter(FleetData::fulfilledOnDemandCapacity)).setter(FleetData.setter(Builder::fulfilledOnDemandCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FulfilledOnDemandCapacity").unmarshallLocationName("fulfilledOnDemandCapacity").build()}).build();
    private static final SdkField<List<FleetLaunchTemplateConfig>> LAUNCH_TEMPLATE_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(FleetData.getter(FleetData::launchTemplateConfigs)).setter(FleetData.setter(Builder::launchTemplateConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateConfigs").unmarshallLocationName("launchTemplateConfigs").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FleetLaunchTemplateConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<TargetCapacitySpecification> TARGET_CAPACITY_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(FleetData.getter(FleetData::targetCapacitySpecification)).setter(FleetData.setter(Builder::targetCapacitySpecification)).constructor(TargetCapacitySpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetCapacitySpecification").unmarshallLocationName("targetCapacitySpecification").build()}).build();
    private static final SdkField<Boolean> TERMINATE_INSTANCES_WITH_EXPIRATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(FleetData.getter(FleetData::terminateInstancesWithExpiration)).setter(FleetData.setter(Builder::terminateInstancesWithExpiration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminateInstancesWithExpiration").unmarshallLocationName("terminateInstancesWithExpiration").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FleetData.getter(FleetData::typeAsString)).setter(FleetData.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").unmarshallLocationName("type").build()}).build();
    private static final SdkField<Instant> VALID_FROM_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(FleetData.getter(FleetData::validFrom)).setter(FleetData.setter(Builder::validFrom)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidFrom").unmarshallLocationName("validFrom").build()}).build();
    private static final SdkField<Instant> VALID_UNTIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(FleetData.getter(FleetData::validUntil)).setter(FleetData.setter(Builder::validUntil)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidUntil").unmarshallLocationName("validUntil").build()}).build();
    private static final SdkField<Boolean> REPLACE_UNHEALTHY_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(FleetData.getter(FleetData::replaceUnhealthyInstances)).setter(FleetData.setter(Builder::replaceUnhealthyInstances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplaceUnhealthyInstances").unmarshallLocationName("replaceUnhealthyInstances").build()}).build();
    private static final SdkField<SpotOptions> SPOT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(FleetData.getter(FleetData::spotOptions)).setter(FleetData.setter(Builder::spotOptions)).constructor(SpotOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotOptions").unmarshallLocationName("spotOptions").build()}).build();
    private static final SdkField<OnDemandOptions> ON_DEMAND_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(FleetData.getter(FleetData::onDemandOptions)).setter(FleetData.setter(Builder::onDemandOptions)).constructor(OnDemandOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandOptions").unmarshallLocationName("onDemandOptions").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(FleetData.getter(FleetData::tags)).setter(FleetData.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<DescribeFleetError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(FleetData.getter(FleetData::errors)).setter(FleetData.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorSet").unmarshallLocationName("errorSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DescribeFleetError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<DescribeFleetsInstances>> INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(FleetData.getter(FleetData::instances)).setter(FleetData.setter(Builder::instances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetInstanceSet").unmarshallLocationName("fleetInstanceSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DescribeFleetsInstances::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVITY_STATUS_FIELD, CREATE_TIME_FIELD, FLEET_ID_FIELD, FLEET_STATE_FIELD, CLIENT_TOKEN_FIELD, EXCESS_CAPACITY_TERMINATION_POLICY_FIELD, FULFILLED_CAPACITY_FIELD, FULFILLED_ON_DEMAND_CAPACITY_FIELD, LAUNCH_TEMPLATE_CONFIGS_FIELD, TARGET_CAPACITY_SPECIFICATION_FIELD, TERMINATE_INSTANCES_WITH_EXPIRATION_FIELD, TYPE_FIELD, VALID_FROM_FIELD, VALID_UNTIL_FIELD, REPLACE_UNHEALTHY_INSTANCES_FIELD, SPOT_OPTIONS_FIELD, ON_DEMAND_OPTIONS_FIELD, TAGS_FIELD, ERRORS_FIELD, INSTANCES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String activityStatus;
    private final Instant createTime;
    private final String fleetId;
    private final String fleetState;
    private final String clientToken;
    private final String excessCapacityTerminationPolicy;
    private final Double fulfilledCapacity;
    private final Double fulfilledOnDemandCapacity;
    private final List<FleetLaunchTemplateConfig> launchTemplateConfigs;
    private final TargetCapacitySpecification targetCapacitySpecification;
    private final Boolean terminateInstancesWithExpiration;
    private final String type;
    private final Instant validFrom;
    private final Instant validUntil;
    private final Boolean replaceUnhealthyInstances;
    private final SpotOptions spotOptions;
    private final OnDemandOptions onDemandOptions;
    private final List<Tag> tags;
    private final List<DescribeFleetError> errors;
    private final List<DescribeFleetsInstances> instances;

    private FleetData(BuilderImpl builder) {
        this.activityStatus = builder.activityStatus;
        this.createTime = builder.createTime;
        this.fleetId = builder.fleetId;
        this.fleetState = builder.fleetState;
        this.clientToken = builder.clientToken;
        this.excessCapacityTerminationPolicy = builder.excessCapacityTerminationPolicy;
        this.fulfilledCapacity = builder.fulfilledCapacity;
        this.fulfilledOnDemandCapacity = builder.fulfilledOnDemandCapacity;
        this.launchTemplateConfigs = builder.launchTemplateConfigs;
        this.targetCapacitySpecification = builder.targetCapacitySpecification;
        this.terminateInstancesWithExpiration = builder.terminateInstancesWithExpiration;
        this.type = builder.type;
        this.validFrom = builder.validFrom;
        this.validUntil = builder.validUntil;
        this.replaceUnhealthyInstances = builder.replaceUnhealthyInstances;
        this.spotOptions = builder.spotOptions;
        this.onDemandOptions = builder.onDemandOptions;
        this.tags = builder.tags;
        this.errors = builder.errors;
        this.instances = builder.instances;
    }

    public FleetActivityStatus activityStatus() {
        return FleetActivityStatus.fromValue(this.activityStatus);
    }

    public String activityStatusAsString() {
        return this.activityStatus;
    }

    public Instant createTime() {
        return this.createTime;
    }

    public String fleetId() {
        return this.fleetId;
    }

    public FleetStateCode fleetState() {
        return FleetStateCode.fromValue(this.fleetState);
    }

    public String fleetStateAsString() {
        return this.fleetState;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public FleetExcessCapacityTerminationPolicy excessCapacityTerminationPolicy() {
        return FleetExcessCapacityTerminationPolicy.fromValue(this.excessCapacityTerminationPolicy);
    }

    public String excessCapacityTerminationPolicyAsString() {
        return this.excessCapacityTerminationPolicy;
    }

    public Double fulfilledCapacity() {
        return this.fulfilledCapacity;
    }

    public Double fulfilledOnDemandCapacity() {
        return this.fulfilledOnDemandCapacity;
    }

    public List<FleetLaunchTemplateConfig> launchTemplateConfigs() {
        return this.launchTemplateConfigs;
    }

    public TargetCapacitySpecification targetCapacitySpecification() {
        return this.targetCapacitySpecification;
    }

    public Boolean terminateInstancesWithExpiration() {
        return this.terminateInstancesWithExpiration;
    }

    public FleetType type() {
        return FleetType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public Instant validFrom() {
        return this.validFrom;
    }

    public Instant validUntil() {
        return this.validUntil;
    }

    public Boolean replaceUnhealthyInstances() {
        return this.replaceUnhealthyInstances;
    }

    public SpotOptions spotOptions() {
        return this.spotOptions;
    }

    public OnDemandOptions onDemandOptions() {
        return this.onDemandOptions;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public List<DescribeFleetError> errors() {
        return this.errors;
    }

    public List<DescribeFleetsInstances> instances() {
        return this.instances;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.activityStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.excessCapacityTerminationPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fulfilledCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.fulfilledOnDemandCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplateConfigs());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetCapacitySpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.terminateInstancesWithExpiration());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.validFrom());
        hashCode = 31 * hashCode + Objects.hashCode(this.validUntil());
        hashCode = 31 * hashCode + Objects.hashCode(this.replaceUnhealthyInstances());
        hashCode = 31 * hashCode + Objects.hashCode(this.spotOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.onDemandOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.errors());
        hashCode = 31 * hashCode + Objects.hashCode(this.instances());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetData)) {
            return false;
        }
        FleetData other = (FleetData)obj;
        return Objects.equals(this.activityStatusAsString(), other.activityStatusAsString()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.fleetId(), other.fleetId()) && Objects.equals(this.fleetStateAsString(), other.fleetStateAsString()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.excessCapacityTerminationPolicyAsString(), other.excessCapacityTerminationPolicyAsString()) && Objects.equals(this.fulfilledCapacity(), other.fulfilledCapacity()) && Objects.equals(this.fulfilledOnDemandCapacity(), other.fulfilledOnDemandCapacity()) && Objects.equals(this.launchTemplateConfigs(), other.launchTemplateConfigs()) && Objects.equals(this.targetCapacitySpecification(), other.targetCapacitySpecification()) && Objects.equals(this.terminateInstancesWithExpiration(), other.terminateInstancesWithExpiration()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.validFrom(), other.validFrom()) && Objects.equals(this.validUntil(), other.validUntil()) && Objects.equals(this.replaceUnhealthyInstances(), other.replaceUnhealthyInstances()) && Objects.equals(this.spotOptions(), other.spotOptions()) && Objects.equals(this.onDemandOptions(), other.onDemandOptions()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.errors(), other.errors()) && Objects.equals(this.instances(), other.instances());
    }

    public String toString() {
        return ToString.builder((String)"FleetData").add("ActivityStatus", (Object)this.activityStatusAsString()).add("CreateTime", (Object)this.createTime()).add("FleetId", (Object)this.fleetId()).add("FleetState", (Object)this.fleetStateAsString()).add("ClientToken", (Object)this.clientToken()).add("ExcessCapacityTerminationPolicy", (Object)this.excessCapacityTerminationPolicyAsString()).add("FulfilledCapacity", (Object)this.fulfilledCapacity()).add("FulfilledOnDemandCapacity", (Object)this.fulfilledOnDemandCapacity()).add("LaunchTemplateConfigs", this.launchTemplateConfigs()).add("TargetCapacitySpecification", (Object)this.targetCapacitySpecification()).add("TerminateInstancesWithExpiration", (Object)this.terminateInstancesWithExpiration()).add("Type", (Object)this.typeAsString()).add("ValidFrom", (Object)this.validFrom()).add("ValidUntil", (Object)this.validUntil()).add("ReplaceUnhealthyInstances", (Object)this.replaceUnhealthyInstances()).add("SpotOptions", (Object)this.spotOptions()).add("OnDemandOptions", (Object)this.onDemandOptions()).add("Tags", this.tags()).add("Errors", this.errors()).add("Instances", this.instances()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActivityStatus": {
                return Optional.ofNullable(clazz.cast(this.activityStatusAsString()));
            }
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "FleetId": {
                return Optional.ofNullable(clazz.cast(this.fleetId()));
            }
            case "FleetState": {
                return Optional.ofNullable(clazz.cast(this.fleetStateAsString()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "ExcessCapacityTerminationPolicy": {
                return Optional.ofNullable(clazz.cast(this.excessCapacityTerminationPolicyAsString()));
            }
            case "FulfilledCapacity": {
                return Optional.ofNullable(clazz.cast(this.fulfilledCapacity()));
            }
            case "FulfilledOnDemandCapacity": {
                return Optional.ofNullable(clazz.cast(this.fulfilledOnDemandCapacity()));
            }
            case "LaunchTemplateConfigs": {
                return Optional.ofNullable(clazz.cast(this.launchTemplateConfigs()));
            }
            case "TargetCapacitySpecification": {
                return Optional.ofNullable(clazz.cast(this.targetCapacitySpecification()));
            }
            case "TerminateInstancesWithExpiration": {
                return Optional.ofNullable(clazz.cast(this.terminateInstancesWithExpiration()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "ValidFrom": {
                return Optional.ofNullable(clazz.cast(this.validFrom()));
            }
            case "ValidUntil": {
                return Optional.ofNullable(clazz.cast(this.validUntil()));
            }
            case "ReplaceUnhealthyInstances": {
                return Optional.ofNullable(clazz.cast(this.replaceUnhealthyInstances()));
            }
            case "SpotOptions": {
                return Optional.ofNullable(clazz.cast(this.spotOptions()));
            }
            case "OnDemandOptions": {
                return Optional.ofNullable(clazz.cast(this.onDemandOptions()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
            case "Instances": {
                return Optional.ofNullable(clazz.cast(this.instances()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FleetData, T> g) {
        return obj -> g.apply((FleetData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String activityStatus;
        private Instant createTime;
        private String fleetId;
        private String fleetState;
        private String clientToken;
        private String excessCapacityTerminationPolicy;
        private Double fulfilledCapacity;
        private Double fulfilledOnDemandCapacity;
        private List<FleetLaunchTemplateConfig> launchTemplateConfigs = DefaultSdkAutoConstructList.getInstance();
        private TargetCapacitySpecification targetCapacitySpecification;
        private Boolean terminateInstancesWithExpiration;
        private String type;
        private Instant validFrom;
        private Instant validUntil;
        private Boolean replaceUnhealthyInstances;
        private SpotOptions spotOptions;
        private OnDemandOptions onDemandOptions;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private List<DescribeFleetError> errors = DefaultSdkAutoConstructList.getInstance();
        private List<DescribeFleetsInstances> instances = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FleetData model) {
            this.activityStatus(model.activityStatus);
            this.createTime(model.createTime);
            this.fleetId(model.fleetId);
            this.fleetState(model.fleetState);
            this.clientToken(model.clientToken);
            this.excessCapacityTerminationPolicy(model.excessCapacityTerminationPolicy);
            this.fulfilledCapacity(model.fulfilledCapacity);
            this.fulfilledOnDemandCapacity(model.fulfilledOnDemandCapacity);
            this.launchTemplateConfigs(model.launchTemplateConfigs);
            this.targetCapacitySpecification(model.targetCapacitySpecification);
            this.terminateInstancesWithExpiration(model.terminateInstancesWithExpiration);
            this.type(model.type);
            this.validFrom(model.validFrom);
            this.validUntil(model.validUntil);
            this.replaceUnhealthyInstances(model.replaceUnhealthyInstances);
            this.spotOptions(model.spotOptions);
            this.onDemandOptions(model.onDemandOptions);
            this.tags(model.tags);
            this.errors(model.errors);
            this.instances(model.instances);
        }

        public final String getActivityStatusAsString() {
            return this.activityStatus;
        }

        @Override
        public final Builder activityStatus(String activityStatus) {
            this.activityStatus = activityStatus;
            return this;
        }

        @Override
        public final Builder activityStatus(FleetActivityStatus activityStatus) {
            this.activityStatus(activityStatus.toString());
            return this;
        }

        public final void setActivityStatus(String activityStatus) {
            this.activityStatus = activityStatus;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final String getFleetStateAsString() {
            return this.fleetState;
        }

        @Override
        public final Builder fleetState(String fleetState) {
            this.fleetState = fleetState;
            return this;
        }

        @Override
        public final Builder fleetState(FleetStateCode fleetState) {
            this.fleetState(fleetState.toString());
            return this;
        }

        public final void setFleetState(String fleetState) {
            this.fleetState = fleetState;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getExcessCapacityTerminationPolicyAsString() {
            return this.excessCapacityTerminationPolicy;
        }

        @Override
        public final Builder excessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
            return this;
        }

        @Override
        public final Builder excessCapacityTerminationPolicy(FleetExcessCapacityTerminationPolicy excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy(excessCapacityTerminationPolicy.toString());
            return this;
        }

        public final void setExcessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
        }

        public final Double getFulfilledCapacity() {
            return this.fulfilledCapacity;
        }

        @Override
        public final Builder fulfilledCapacity(Double fulfilledCapacity) {
            this.fulfilledCapacity = fulfilledCapacity;
            return this;
        }

        public final void setFulfilledCapacity(Double fulfilledCapacity) {
            this.fulfilledCapacity = fulfilledCapacity;
        }

        public final Double getFulfilledOnDemandCapacity() {
            return this.fulfilledOnDemandCapacity;
        }

        @Override
        public final Builder fulfilledOnDemandCapacity(Double fulfilledOnDemandCapacity) {
            this.fulfilledOnDemandCapacity = fulfilledOnDemandCapacity;
            return this;
        }

        public final void setFulfilledOnDemandCapacity(Double fulfilledOnDemandCapacity) {
            this.fulfilledOnDemandCapacity = fulfilledOnDemandCapacity;
        }

        public final Collection<FleetLaunchTemplateConfig.Builder> getLaunchTemplateConfigs() {
            return this.launchTemplateConfigs != null ? (Collection)this.launchTemplateConfigs.stream().map(FleetLaunchTemplateConfig::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder launchTemplateConfigs(Collection<FleetLaunchTemplateConfig> launchTemplateConfigs) {
            this.launchTemplateConfigs = FleetLaunchTemplateConfigListCopier.copy(launchTemplateConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchTemplateConfigs(FleetLaunchTemplateConfig ... launchTemplateConfigs) {
            this.launchTemplateConfigs(Arrays.asList(launchTemplateConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchTemplateConfigs(Consumer<FleetLaunchTemplateConfig.Builder> ... launchTemplateConfigs) {
            this.launchTemplateConfigs(Stream.of(launchTemplateConfigs).map(c -> (FleetLaunchTemplateConfig)((FleetLaunchTemplateConfig.Builder)FleetLaunchTemplateConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLaunchTemplateConfigs(Collection<FleetLaunchTemplateConfig.BuilderImpl> launchTemplateConfigs) {
            this.launchTemplateConfigs = FleetLaunchTemplateConfigListCopier.copyFromBuilder(launchTemplateConfigs);
        }

        public final TargetCapacitySpecification.Builder getTargetCapacitySpecification() {
            return this.targetCapacitySpecification != null ? this.targetCapacitySpecification.toBuilder() : null;
        }

        @Override
        public final Builder targetCapacitySpecification(TargetCapacitySpecification targetCapacitySpecification) {
            this.targetCapacitySpecification = targetCapacitySpecification;
            return this;
        }

        public final void setTargetCapacitySpecification(TargetCapacitySpecification.BuilderImpl targetCapacitySpecification) {
            this.targetCapacitySpecification = targetCapacitySpecification != null ? targetCapacitySpecification.build() : null;
        }

        public final Boolean getTerminateInstancesWithExpiration() {
            return this.terminateInstancesWithExpiration;
        }

        @Override
        public final Builder terminateInstancesWithExpiration(Boolean terminateInstancesWithExpiration) {
            this.terminateInstancesWithExpiration = terminateInstancesWithExpiration;
            return this;
        }

        public final void setTerminateInstancesWithExpiration(Boolean terminateInstancesWithExpiration) {
            this.terminateInstancesWithExpiration = terminateInstancesWithExpiration;
        }

        public final String getTypeAsString() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FleetType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Instant getValidFrom() {
            return this.validFrom;
        }

        @Override
        public final Builder validFrom(Instant validFrom) {
            this.validFrom = validFrom;
            return this;
        }

        public final void setValidFrom(Instant validFrom) {
            this.validFrom = validFrom;
        }

        public final Instant getValidUntil() {
            return this.validUntil;
        }

        @Override
        public final Builder validUntil(Instant validUntil) {
            this.validUntil = validUntil;
            return this;
        }

        public final void setValidUntil(Instant validUntil) {
            this.validUntil = validUntil;
        }

        public final Boolean getReplaceUnhealthyInstances() {
            return this.replaceUnhealthyInstances;
        }

        @Override
        public final Builder replaceUnhealthyInstances(Boolean replaceUnhealthyInstances) {
            this.replaceUnhealthyInstances = replaceUnhealthyInstances;
            return this;
        }

        public final void setReplaceUnhealthyInstances(Boolean replaceUnhealthyInstances) {
            this.replaceUnhealthyInstances = replaceUnhealthyInstances;
        }

        public final SpotOptions.Builder getSpotOptions() {
            return this.spotOptions != null ? this.spotOptions.toBuilder() : null;
        }

        @Override
        public final Builder spotOptions(SpotOptions spotOptions) {
            this.spotOptions = spotOptions;
            return this;
        }

        public final void setSpotOptions(SpotOptions.BuilderImpl spotOptions) {
            this.spotOptions = spotOptions != null ? spotOptions.build() : null;
        }

        public final OnDemandOptions.Builder getOnDemandOptions() {
            return this.onDemandOptions != null ? this.onDemandOptions.toBuilder() : null;
        }

        @Override
        public final Builder onDemandOptions(OnDemandOptions onDemandOptions) {
            this.onDemandOptions = onDemandOptions;
            return this;
        }

        public final void setOnDemandOptions(OnDemandOptions.BuilderImpl onDemandOptions) {
            this.onDemandOptions = onDemandOptions != null ? onDemandOptions.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Collection<DescribeFleetError.Builder> getErrors() {
            return this.errors != null ? (Collection)this.errors.stream().map(DescribeFleetError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder errors(Collection<DescribeFleetError> errors) {
            this.errors = DescribeFleetsErrorSetCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(DescribeFleetError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<DescribeFleetError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (DescribeFleetError)((DescribeFleetError.Builder)DescribeFleetError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setErrors(Collection<DescribeFleetError.BuilderImpl> errors) {
            this.errors = DescribeFleetsErrorSetCopier.copyFromBuilder(errors);
        }

        public final Collection<DescribeFleetsInstances.Builder> getInstances() {
            return this.instances != null ? (Collection)this.instances.stream().map(DescribeFleetsInstances::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instances(Collection<DescribeFleetsInstances> instances) {
            this.instances = DescribeFleetsInstancesSetCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(DescribeFleetsInstances ... instances) {
            this.instances(Arrays.asList(instances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Consumer<DescribeFleetsInstances.Builder> ... instances) {
            this.instances(Stream.of(instances).map(c -> (DescribeFleetsInstances)((DescribeFleetsInstances.Builder)DescribeFleetsInstances.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstances(Collection<DescribeFleetsInstances.BuilderImpl> instances) {
            this.instances = DescribeFleetsInstancesSetCopier.copyFromBuilder(instances);
        }

        public FleetData build() {
            return new FleetData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FleetData> {
        public Builder activityStatus(String var1);

        public Builder activityStatus(FleetActivityStatus var1);

        public Builder createTime(Instant var1);

        public Builder fleetId(String var1);

        public Builder fleetState(String var1);

        public Builder fleetState(FleetStateCode var1);

        public Builder clientToken(String var1);

        public Builder excessCapacityTerminationPolicy(String var1);

        public Builder excessCapacityTerminationPolicy(FleetExcessCapacityTerminationPolicy var1);

        public Builder fulfilledCapacity(Double var1);

        public Builder fulfilledOnDemandCapacity(Double var1);

        public Builder launchTemplateConfigs(Collection<FleetLaunchTemplateConfig> var1);

        public Builder launchTemplateConfigs(FleetLaunchTemplateConfig ... var1);

        public Builder launchTemplateConfigs(Consumer<FleetLaunchTemplateConfig.Builder> ... var1);

        public Builder targetCapacitySpecification(TargetCapacitySpecification var1);

        default public Builder targetCapacitySpecification(Consumer<TargetCapacitySpecification.Builder> targetCapacitySpecification) {
            return this.targetCapacitySpecification((TargetCapacitySpecification)((TargetCapacitySpecification.Builder)TargetCapacitySpecification.builder().applyMutation(targetCapacitySpecification)).build());
        }

        public Builder terminateInstancesWithExpiration(Boolean var1);

        public Builder type(String var1);

        public Builder type(FleetType var1);

        public Builder validFrom(Instant var1);

        public Builder validUntil(Instant var1);

        public Builder replaceUnhealthyInstances(Boolean var1);

        public Builder spotOptions(SpotOptions var1);

        default public Builder spotOptions(Consumer<SpotOptions.Builder> spotOptions) {
            return this.spotOptions((SpotOptions)((SpotOptions.Builder)SpotOptions.builder().applyMutation(spotOptions)).build());
        }

        public Builder onDemandOptions(OnDemandOptions var1);

        default public Builder onDemandOptions(Consumer<OnDemandOptions.Builder> onDemandOptions) {
            return this.onDemandOptions((OnDemandOptions)((OnDemandOptions.Builder)OnDemandOptions.builder().applyMutation(onDemandOptions)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder errors(Collection<DescribeFleetError> var1);

        public Builder errors(DescribeFleetError ... var1);

        public Builder errors(Consumer<DescribeFleetError.Builder> ... var1);

        public Builder instances(Collection<DescribeFleetsInstances> var1);

        public Builder instances(DescribeFleetsInstances ... var1);

        public Builder instances(Consumer<DescribeFleetsInstances.Builder> ... var1);
    }
}

