/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform.internal;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.auth.signer.AwsSignerExecutionAttribute;
import software.amazon.awssdk.auth.signer.params.Aws4PresignerParams;
import software.amazon.awssdk.awscore.util.AwsHostNameUtils;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.protocols.query.AwsEc2ProtocolFactory;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.CopySnapshotRequest;
import software.amazon.awssdk.services.ec2.transform.CopySnapshotRequestMarshaller;

@SdkInternalApi
public final class GeneratePreSignUrlInterceptor
implements ExecutionInterceptor {
    private static final AwsEc2ProtocolFactory PROTOCOL_FACTORY = ((AwsEc2ProtocolFactory.Builder)AwsEc2ProtocolFactory.builder().clientConfiguration(SdkClientConfiguration.builder().option((ClientOption)SdkClientOption.ENDPOINT, (Object)URI.create("http://localhost")).build())).build();
    private static final CopySnapshotRequestMarshaller MARSHALLER = new CopySnapshotRequestMarshaller((AwsQueryProtocolFactory)PROTOCOL_FACTORY);

    public SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        SdkHttpRequest request = context.httpRequest();
        SdkRequest originalRequest = context.request();
        if (originalRequest instanceof CopySnapshotRequest) {
            CopySnapshotRequest originalCopySnapshotRequest = (CopySnapshotRequest)originalRequest;
            if (originalCopySnapshotRequest.presignedUrl() != null) {
                return request;
            }
            String serviceName = "ec2";
            String sourceRegion = originalCopySnapshotRequest.sourceRegion();
            String sourceSnapshotId = originalCopySnapshotRequest.sourceSnapshotId();
            String destinationRegion = originalCopySnapshotRequest.destinationRegion();
            if (destinationRegion == null) {
                destinationRegion = ((Region)AwsHostNameUtils.parseSigningRegion((String)request.host(), (String)serviceName).orElseThrow(() -> new IllegalArgumentException("Could not determine region for " + request.host()))).id();
            }
            URI endPointSource = this.createEndpoint(sourceRegion, serviceName);
            SdkHttpFullRequest requestForPresigning = this.generateRequestForPresigning(sourceSnapshotId, sourceRegion, destinationRegion).toBuilder().uri(endPointSource).method(SdkHttpMethod.GET).build();
            Aws4Signer signer = Aws4Signer.create();
            Aws4PresignerParams signingParams = this.getPresignerParams(executionAttributes, sourceRegion, serviceName);
            SdkHttpFullRequest presignedRequest = signer.presign(requestForPresigning, signingParams);
            return (SdkHttpRequest)((SdkHttpRequest.Builder)request.toBuilder()).putRawQueryParameter("DestinationRegion", destinationRegion).putRawQueryParameter("PresignedUrl", presignedRequest.getUri().toString()).build();
        }
        return request;
    }

    private Aws4PresignerParams getPresignerParams(ExecutionAttributes attributes, String signingRegion, String signingName) {
        return ((Aws4PresignerParams.Builder)((Aws4PresignerParams.Builder)((Aws4PresignerParams.Builder)Aws4PresignerParams.builder().signingRegion(Region.of((String)signingRegion))).signingName(signingName)).awsCredentials((AwsCredentials)attributes.getAttribute(AwsSignerExecutionAttribute.AWS_CREDENTIALS))).build();
    }

    private SdkHttpFullRequest generateRequestForPresigning(String sourceSnapshotId, String sourceRegion, String destinationRegion) {
        CopySnapshotRequest copySnapshotRequest = (CopySnapshotRequest)((Object)CopySnapshotRequest.builder().sourceSnapshotId(sourceSnapshotId).sourceRegion(sourceRegion).destinationRegion(destinationRegion).build());
        return MARSHALLER.marshall(copySnapshotRequest);
    }

    private URI createEndpoint(String regionName, String serviceName) {
        Region region = Region.of((String)regionName);
        if (region == null) {
            throw SdkClientException.builder().message("{" + serviceName + ", " + regionName + "} was not found in region metadata. Update to latest version of SDK and try again.").build();
        }
        return Ec2Client.serviceMetadata().endpointFor(region);
    }
}

