/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Address;
import software.amazon.awssdk.services.ec2.model.AddressListCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAddressesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeAddressesResponse> {
    private static final SdkField<List<Address>> ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeAddressesResponse.getter(DescribeAddressesResponse::addresses)).setter(DescribeAddressesResponse.setter(Builder::addresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressesSet").unmarshallLocationName("addressesSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Address::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESSES_FIELD));
    private final List<Address> addresses;

    private DescribeAddressesResponse(BuilderImpl builder) {
        super(builder);
        this.addresses = builder.addresses;
    }

    public List<Address> addresses() {
        return this.addresses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.addresses());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAddressesResponse)) {
            return false;
        }
        DescribeAddressesResponse other = (DescribeAddressesResponse)((Object)obj);
        return Objects.equals(this.addresses(), other.addresses());
    }

    public String toString() {
        return ToString.builder((String)"DescribeAddressesResponse").add("Addresses", this.addresses()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Addresses": {
                return Optional.ofNullable(clazz.cast(this.addresses()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAddressesResponse, T> g) {
        return obj -> g.apply((DescribeAddressesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<Address> addresses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAddressesResponse model) {
            super(model);
            this.addresses(model.addresses);
        }

        public final Collection<Address.Builder> getAddresses() {
            return this.addresses != null ? (Collection)this.addresses.stream().map(Address::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder addresses(Collection<Address> addresses) {
            this.addresses = AddressListCopier.copy(addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addresses(Address ... addresses) {
            this.addresses(Arrays.asList(addresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addresses(Consumer<Address.Builder> ... addresses) {
            this.addresses(Stream.of(addresses).map(c -> (Address)((Address.Builder)Address.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAddresses(Collection<Address.BuilderImpl> addresses) {
            this.addresses = AddressListCopier.copyFromBuilder(addresses);
        }

        @Override
        public DescribeAddressesResponse build() {
            return new DescribeAddressesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAddressesResponse> {
        public Builder addresses(Collection<Address> var1);

        public Builder addresses(Address ... var1);

        public Builder addresses(Consumer<Address.Builder> ... var1);
    }
}

