/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.ReservedInstanceIdSetCopier;
import software.amazon.awssdk.services.ec2.model.TargetConfigurationRequest;
import software.amazon.awssdk.services.ec2.model.TargetConfigurationRequestSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetReservedInstancesExchangeQuoteRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, GetReservedInstancesExchangeQuoteRequest> {
    private static final SdkField<List<String>> RESERVED_INSTANCE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetReservedInstancesExchangeQuoteRequest.getter(GetReservedInstancesExchangeQuoteRequest::reservedInstanceIds)).setter(GetReservedInstancesExchangeQuoteRequest.setter(Builder::reservedInstanceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstanceId").unmarshallLocationName("ReservedInstanceId").build(), ListTrait.builder().memberLocationName("ReservedInstanceId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstanceId").unmarshallLocationName("ReservedInstanceId").build()}).build()).build()}).build();
    private static final SdkField<List<TargetConfigurationRequest>> TARGET_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetReservedInstancesExchangeQuoteRequest.getter(GetReservedInstancesExchangeQuoteRequest::targetConfigurations)).setter(GetReservedInstancesExchangeQuoteRequest.setter(Builder::targetConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetConfiguration").unmarshallLocationName("TargetConfiguration").build(), ListTrait.builder().memberLocationName("TargetConfigurationRequest").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TargetConfigurationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetConfigurationRequest").unmarshallLocationName("TargetConfigurationRequest").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVED_INSTANCE_IDS_FIELD, TARGET_CONFIGURATIONS_FIELD));
    private final List<String> reservedInstanceIds;
    private final List<TargetConfigurationRequest> targetConfigurations;

    private GetReservedInstancesExchangeQuoteRequest(BuilderImpl builder) {
        super(builder);
        this.reservedInstanceIds = builder.reservedInstanceIds;
        this.targetConfigurations = builder.targetConfigurations;
    }

    public List<String> reservedInstanceIds() {
        return this.reservedInstanceIds;
    }

    public List<TargetConfigurationRequest> targetConfigurations() {
        return this.targetConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedInstanceIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetConfigurations());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReservedInstancesExchangeQuoteRequest)) {
            return false;
        }
        GetReservedInstancesExchangeQuoteRequest other = (GetReservedInstancesExchangeQuoteRequest)((Object)obj);
        return Objects.equals(this.reservedInstanceIds(), other.reservedInstanceIds()) && Objects.equals(this.targetConfigurations(), other.targetConfigurations());
    }

    public String toString() {
        return ToString.builder((String)"GetReservedInstancesExchangeQuoteRequest").add("ReservedInstanceIds", this.reservedInstanceIds()).add("TargetConfigurations", this.targetConfigurations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReservedInstanceIds": {
                return Optional.ofNullable(clazz.cast(this.reservedInstanceIds()));
            }
            case "TargetConfigurations": {
                return Optional.ofNullable(clazz.cast(this.targetConfigurations()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetReservedInstancesExchangeQuoteRequest, T> g) {
        return obj -> g.apply((GetReservedInstancesExchangeQuoteRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<String> reservedInstanceIds = DefaultSdkAutoConstructList.getInstance();
        private List<TargetConfigurationRequest> targetConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetReservedInstancesExchangeQuoteRequest model) {
            super(model);
            this.reservedInstanceIds(model.reservedInstanceIds);
            this.targetConfigurations(model.targetConfigurations);
        }

        public final Collection<String> getReservedInstanceIds() {
            return this.reservedInstanceIds;
        }

        @Override
        public final Builder reservedInstanceIds(Collection<String> reservedInstanceIds) {
            this.reservedInstanceIds = ReservedInstanceIdSetCopier.copy(reservedInstanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstanceIds(String ... reservedInstanceIds) {
            this.reservedInstanceIds(Arrays.asList(reservedInstanceIds));
            return this;
        }

        public final void setReservedInstanceIds(Collection<String> reservedInstanceIds) {
            this.reservedInstanceIds = ReservedInstanceIdSetCopier.copy(reservedInstanceIds);
        }

        public final Collection<TargetConfigurationRequest.Builder> getTargetConfigurations() {
            return this.targetConfigurations != null ? (Collection)this.targetConfigurations.stream().map(TargetConfigurationRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targetConfigurations(Collection<TargetConfigurationRequest> targetConfigurations) {
            this.targetConfigurations = TargetConfigurationRequestSetCopier.copy(targetConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetConfigurations(TargetConfigurationRequest ... targetConfigurations) {
            this.targetConfigurations(Arrays.asList(targetConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetConfigurations(Consumer<TargetConfigurationRequest.Builder> ... targetConfigurations) {
            this.targetConfigurations(Stream.of(targetConfigurations).map(c -> (TargetConfigurationRequest)((TargetConfigurationRequest.Builder)TargetConfigurationRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTargetConfigurations(Collection<TargetConfigurationRequest.BuilderImpl> targetConfigurations) {
            this.targetConfigurations = TargetConfigurationRequestSetCopier.copyFromBuilder(targetConfigurations);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetReservedInstancesExchangeQuoteRequest build() {
            return new GetReservedInstancesExchangeQuoteRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetReservedInstancesExchangeQuoteRequest> {
        public Builder reservedInstanceIds(Collection<String> var1);

        public Builder reservedInstanceIds(String ... var1);

        public Builder targetConfigurations(Collection<TargetConfigurationRequest> var1);

        public Builder targetConfigurations(TargetConfigurationRequest ... var1);

        public Builder targetConfigurations(Consumer<TargetConfigurationRequest.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

