/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ClientVpnAuthenticationRequest;
import software.amazon.awssdk.services.ec2.model.ClientVpnAuthenticationRequestListCopier;
import software.amazon.awssdk.services.ec2.model.ConnectionLogOptions;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.services.ec2.model.TransportProtocol;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateClientVpnEndpointRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateClientVpnEndpointRequest> {
    private static final SdkField<String> CLIENT_CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateClientVpnEndpointRequest.getter(CreateClientVpnEndpointRequest::clientCidrBlock)).setter(CreateClientVpnEndpointRequest.setter(Builder::clientCidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientCidrBlock").unmarshallLocationName("ClientCidrBlock").build()}).build();
    private static final SdkField<String> SERVER_CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateClientVpnEndpointRequest.getter(CreateClientVpnEndpointRequest::serverCertificateArn)).setter(CreateClientVpnEndpointRequest.setter(Builder::serverCertificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerCertificateArn").unmarshallLocationName("ServerCertificateArn").build()}).build();
    private static final SdkField<List<ClientVpnAuthenticationRequest>> AUTHENTICATION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateClientVpnEndpointRequest.getter(CreateClientVpnEndpointRequest::authenticationOptions)).setter(CreateClientVpnEndpointRequest.setter(Builder::authenticationOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Authentication").unmarshallLocationName("Authentication").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClientVpnAuthenticationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<ConnectionLogOptions> CONNECTION_LOG_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateClientVpnEndpointRequest.getter(CreateClientVpnEndpointRequest::connectionLogOptions)).setter(CreateClientVpnEndpointRequest.setter(Builder::connectionLogOptions)).constructor(ConnectionLogOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionLogOptions").unmarshallLocationName("ConnectionLogOptions").build()}).build();
    private static final SdkField<List<String>> DNS_SERVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateClientVpnEndpointRequest.getter(CreateClientVpnEndpointRequest::dnsServers)).setter(CreateClientVpnEndpointRequest.setter(Builder::dnsServers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsServers").unmarshallLocationName("DnsServers").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> TRANSPORT_PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateClientVpnEndpointRequest.getter(CreateClientVpnEndpointRequest::transportProtocolAsString)).setter(CreateClientVpnEndpointRequest.setter(Builder::transportProtocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransportProtocol").unmarshallLocationName("TransportProtocol").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateClientVpnEndpointRequest.getter(CreateClientVpnEndpointRequest::description)).setter(CreateClientVpnEndpointRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("Description").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateClientVpnEndpointRequest.getter(CreateClientVpnEndpointRequest::clientToken)).setter(CreateClientVpnEndpointRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateClientVpnEndpointRequest.getter(CreateClientVpnEndpointRequest::tagSpecifications)).setter(CreateClientVpnEndpointRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_CIDR_BLOCK_FIELD, SERVER_CERTIFICATE_ARN_FIELD, AUTHENTICATION_OPTIONS_FIELD, CONNECTION_LOG_OPTIONS_FIELD, DNS_SERVERS_FIELD, TRANSPORT_PROTOCOL_FIELD, DESCRIPTION_FIELD, CLIENT_TOKEN_FIELD, TAG_SPECIFICATIONS_FIELD));
    private final String clientCidrBlock;
    private final String serverCertificateArn;
    private final List<ClientVpnAuthenticationRequest> authenticationOptions;
    private final ConnectionLogOptions connectionLogOptions;
    private final List<String> dnsServers;
    private final String transportProtocol;
    private final String description;
    private final String clientToken;
    private final List<TagSpecification> tagSpecifications;

    private CreateClientVpnEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.clientCidrBlock = builder.clientCidrBlock;
        this.serverCertificateArn = builder.serverCertificateArn;
        this.authenticationOptions = builder.authenticationOptions;
        this.connectionLogOptions = builder.connectionLogOptions;
        this.dnsServers = builder.dnsServers;
        this.transportProtocol = builder.transportProtocol;
        this.description = builder.description;
        this.clientToken = builder.clientToken;
        this.tagSpecifications = builder.tagSpecifications;
    }

    public String clientCidrBlock() {
        return this.clientCidrBlock;
    }

    public String serverCertificateArn() {
        return this.serverCertificateArn;
    }

    public List<ClientVpnAuthenticationRequest> authenticationOptions() {
        return this.authenticationOptions;
    }

    public ConnectionLogOptions connectionLogOptions() {
        return this.connectionLogOptions;
    }

    public List<String> dnsServers() {
        return this.dnsServers;
    }

    public TransportProtocol transportProtocol() {
        return TransportProtocol.fromValue(this.transportProtocol);
    }

    public String transportProtocolAsString() {
        return this.transportProtocol;
    }

    public String description() {
        return this.description;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverCertificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionLogOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsServers());
        hashCode = 31 * hashCode + Objects.hashCode(this.transportProtocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagSpecifications());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClientVpnEndpointRequest)) {
            return false;
        }
        CreateClientVpnEndpointRequest other = (CreateClientVpnEndpointRequest)((Object)obj);
        return Objects.equals(this.clientCidrBlock(), other.clientCidrBlock()) && Objects.equals(this.serverCertificateArn(), other.serverCertificateArn()) && Objects.equals(this.authenticationOptions(), other.authenticationOptions()) && Objects.equals(this.connectionLogOptions(), other.connectionLogOptions()) && Objects.equals(this.dnsServers(), other.dnsServers()) && Objects.equals(this.transportProtocolAsString(), other.transportProtocolAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.tagSpecifications(), other.tagSpecifications());
    }

    public String toString() {
        return ToString.builder((String)"CreateClientVpnEndpointRequest").add("ClientCidrBlock", (Object)this.clientCidrBlock()).add("ServerCertificateArn", (Object)this.serverCertificateArn()).add("AuthenticationOptions", this.authenticationOptions()).add("ConnectionLogOptions", (Object)this.connectionLogOptions()).add("DnsServers", this.dnsServers()).add("TransportProtocol", (Object)this.transportProtocolAsString()).add("Description", (Object)this.description()).add("ClientToken", (Object)this.clientToken()).add("TagSpecifications", this.tagSpecifications()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientCidrBlock": {
                return Optional.ofNullable(clazz.cast(this.clientCidrBlock()));
            }
            case "ServerCertificateArn": {
                return Optional.ofNullable(clazz.cast(this.serverCertificateArn()));
            }
            case "AuthenticationOptions": {
                return Optional.ofNullable(clazz.cast(this.authenticationOptions()));
            }
            case "ConnectionLogOptions": {
                return Optional.ofNullable(clazz.cast(this.connectionLogOptions()));
            }
            case "DnsServers": {
                return Optional.ofNullable(clazz.cast(this.dnsServers()));
            }
            case "TransportProtocol": {
                return Optional.ofNullable(clazz.cast(this.transportProtocolAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateClientVpnEndpointRequest, T> g) {
        return obj -> g.apply((CreateClientVpnEndpointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String clientCidrBlock;
        private String serverCertificateArn;
        private List<ClientVpnAuthenticationRequest> authenticationOptions = DefaultSdkAutoConstructList.getInstance();
        private ConnectionLogOptions connectionLogOptions;
        private List<String> dnsServers = DefaultSdkAutoConstructList.getInstance();
        private String transportProtocol;
        private String description;
        private String clientToken;
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClientVpnEndpointRequest model) {
            super(model);
            this.clientCidrBlock(model.clientCidrBlock);
            this.serverCertificateArn(model.serverCertificateArn);
            this.authenticationOptions(model.authenticationOptions);
            this.connectionLogOptions(model.connectionLogOptions);
            this.dnsServers(model.dnsServers);
            this.transportProtocol(model.transportProtocol);
            this.description(model.description);
            this.clientToken(model.clientToken);
            this.tagSpecifications(model.tagSpecifications);
        }

        public final String getClientCidrBlock() {
            return this.clientCidrBlock;
        }

        @Override
        public final Builder clientCidrBlock(String clientCidrBlock) {
            this.clientCidrBlock = clientCidrBlock;
            return this;
        }

        public final void setClientCidrBlock(String clientCidrBlock) {
            this.clientCidrBlock = clientCidrBlock;
        }

        public final String getServerCertificateArn() {
            return this.serverCertificateArn;
        }

        @Override
        public final Builder serverCertificateArn(String serverCertificateArn) {
            this.serverCertificateArn = serverCertificateArn;
            return this;
        }

        public final void setServerCertificateArn(String serverCertificateArn) {
            this.serverCertificateArn = serverCertificateArn;
        }

        public final Collection<ClientVpnAuthenticationRequest.Builder> getAuthenticationOptions() {
            return this.authenticationOptions != null ? (Collection)this.authenticationOptions.stream().map(ClientVpnAuthenticationRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder authenticationOptions(Collection<ClientVpnAuthenticationRequest> authenticationOptions) {
            this.authenticationOptions = ClientVpnAuthenticationRequestListCopier.copy(authenticationOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authenticationOptions(ClientVpnAuthenticationRequest ... authenticationOptions) {
            this.authenticationOptions(Arrays.asList(authenticationOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authenticationOptions(Consumer<ClientVpnAuthenticationRequest.Builder> ... authenticationOptions) {
            this.authenticationOptions(Stream.of(authenticationOptions).map(c -> (ClientVpnAuthenticationRequest)((ClientVpnAuthenticationRequest.Builder)ClientVpnAuthenticationRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAuthenticationOptions(Collection<ClientVpnAuthenticationRequest.BuilderImpl> authenticationOptions) {
            this.authenticationOptions = ClientVpnAuthenticationRequestListCopier.copyFromBuilder(authenticationOptions);
        }

        public final ConnectionLogOptions.Builder getConnectionLogOptions() {
            return this.connectionLogOptions != null ? this.connectionLogOptions.toBuilder() : null;
        }

        @Override
        public final Builder connectionLogOptions(ConnectionLogOptions connectionLogOptions) {
            this.connectionLogOptions = connectionLogOptions;
            return this;
        }

        public final void setConnectionLogOptions(ConnectionLogOptions.BuilderImpl connectionLogOptions) {
            this.connectionLogOptions = connectionLogOptions != null ? connectionLogOptions.build() : null;
        }

        public final Collection<String> getDnsServers() {
            return this.dnsServers;
        }

        @Override
        public final Builder dnsServers(Collection<String> dnsServers) {
            this.dnsServers = ValueStringListCopier.copy(dnsServers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnsServers(String ... dnsServers) {
            this.dnsServers(Arrays.asList(dnsServers));
            return this;
        }

        public final void setDnsServers(Collection<String> dnsServers) {
            this.dnsServers = ValueStringListCopier.copy(dnsServers);
        }

        public final String getTransportProtocolAsString() {
            return this.transportProtocol;
        }

        @Override
        public final Builder transportProtocol(String transportProtocol) {
            this.transportProtocol = transportProtocol;
            return this;
        }

        @Override
        public final Builder transportProtocol(TransportProtocol transportProtocol) {
            this.transportProtocol(transportProtocol.toString());
            return this;
        }

        public final void setTransportProtocol(String transportProtocol) {
            this.transportProtocol = transportProtocol;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Collection<TagSpecification.Builder> getTagSpecifications() {
            return this.tagSpecifications != null ? (Collection)this.tagSpecifications.stream().map(TagSpecification::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateClientVpnEndpointRequest build() {
            return new CreateClientVpnEndpointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateClientVpnEndpointRequest> {
        public Builder clientCidrBlock(String var1);

        public Builder serverCertificateArn(String var1);

        public Builder authenticationOptions(Collection<ClientVpnAuthenticationRequest> var1);

        public Builder authenticationOptions(ClientVpnAuthenticationRequest ... var1);

        public Builder authenticationOptions(Consumer<ClientVpnAuthenticationRequest.Builder> ... var1);

        public Builder connectionLogOptions(ConnectionLogOptions var1);

        default public Builder connectionLogOptions(Consumer<ConnectionLogOptions.Builder> connectionLogOptions) {
            return this.connectionLogOptions((ConnectionLogOptions)((ConnectionLogOptions.Builder)ConnectionLogOptions.builder().applyMutation(connectionLogOptions)).build());
        }

        public Builder dnsServers(Collection<String> var1);

        public Builder dnsServers(String ... var1);

        public Builder transportProtocol(String var1);

        public Builder transportProtocol(TransportProtocol var1);

        public Builder description(String var1);

        public Builder clientToken(String var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

