/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.FleetOnDemandAllocationStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OnDemandOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OnDemandOptions> {
    private static final SdkField<String> ALLOCATION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(OnDemandOptions.getter(OnDemandOptions::allocationStrategyAsString)).setter(OnDemandOptions.setter(Builder::allocationStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationStrategy").unmarshallLocationName("allocationStrategy").build()}).build();
    private static final SdkField<Boolean> SINGLE_INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(OnDemandOptions.getter(OnDemandOptions::singleInstanceType)).setter(OnDemandOptions.setter(Builder::singleInstanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleInstanceType").unmarshallLocationName("singleInstanceType").build()}).build();
    private static final SdkField<Boolean> SINGLE_AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(OnDemandOptions.getter(OnDemandOptions::singleAvailabilityZone)).setter(OnDemandOptions.setter(Builder::singleAvailabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleAvailabilityZone").unmarshallLocationName("singleAvailabilityZone").build()}).build();
    private static final SdkField<Integer> MIN_TARGET_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(OnDemandOptions.getter(OnDemandOptions::minTargetCapacity)).setter(OnDemandOptions.setter(Builder::minTargetCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinTargetCapacity").unmarshallLocationName("minTargetCapacity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOCATION_STRATEGY_FIELD, SINGLE_INSTANCE_TYPE_FIELD, SINGLE_AVAILABILITY_ZONE_FIELD, MIN_TARGET_CAPACITY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String allocationStrategy;
    private final Boolean singleInstanceType;
    private final Boolean singleAvailabilityZone;
    private final Integer minTargetCapacity;

    private OnDemandOptions(BuilderImpl builder) {
        this.allocationStrategy = builder.allocationStrategy;
        this.singleInstanceType = builder.singleInstanceType;
        this.singleAvailabilityZone = builder.singleAvailabilityZone;
        this.minTargetCapacity = builder.minTargetCapacity;
    }

    public FleetOnDemandAllocationStrategy allocationStrategy() {
        return FleetOnDemandAllocationStrategy.fromValue(this.allocationStrategy);
    }

    public String allocationStrategyAsString() {
        return this.allocationStrategy;
    }

    public Boolean singleInstanceType() {
        return this.singleInstanceType;
    }

    public Boolean singleAvailabilityZone() {
        return this.singleAvailabilityZone;
    }

    public Integer minTargetCapacity() {
        return this.minTargetCapacity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allocationStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.singleInstanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.singleAvailabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.minTargetCapacity());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OnDemandOptions)) {
            return false;
        }
        OnDemandOptions other = (OnDemandOptions)obj;
        return Objects.equals(this.allocationStrategyAsString(), other.allocationStrategyAsString()) && Objects.equals(this.singleInstanceType(), other.singleInstanceType()) && Objects.equals(this.singleAvailabilityZone(), other.singleAvailabilityZone()) && Objects.equals(this.minTargetCapacity(), other.minTargetCapacity());
    }

    public String toString() {
        return ToString.builder((String)"OnDemandOptions").add("AllocationStrategy", (Object)this.allocationStrategyAsString()).add("SingleInstanceType", (Object)this.singleInstanceType()).add("SingleAvailabilityZone", (Object)this.singleAvailabilityZone()).add("MinTargetCapacity", (Object)this.minTargetCapacity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllocationStrategy": {
                return Optional.ofNullable(clazz.cast(this.allocationStrategyAsString()));
            }
            case "SingleInstanceType": {
                return Optional.ofNullable(clazz.cast(this.singleInstanceType()));
            }
            case "SingleAvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.singleAvailabilityZone()));
            }
            case "MinTargetCapacity": {
                return Optional.ofNullable(clazz.cast(this.minTargetCapacity()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OnDemandOptions, T> g) {
        return obj -> g.apply((OnDemandOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String allocationStrategy;
        private Boolean singleInstanceType;
        private Boolean singleAvailabilityZone;
        private Integer minTargetCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(OnDemandOptions model) {
            this.allocationStrategy(model.allocationStrategy);
            this.singleInstanceType(model.singleInstanceType);
            this.singleAvailabilityZone(model.singleAvailabilityZone);
            this.minTargetCapacity(model.minTargetCapacity);
        }

        public final String getAllocationStrategyAsString() {
            return this.allocationStrategy;
        }

        @Override
        public final Builder allocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
            return this;
        }

        @Override
        public final Builder allocationStrategy(FleetOnDemandAllocationStrategy allocationStrategy) {
            this.allocationStrategy(allocationStrategy.toString());
            return this;
        }

        public final void setAllocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
        }

        public final Boolean getSingleInstanceType() {
            return this.singleInstanceType;
        }

        @Override
        public final Builder singleInstanceType(Boolean singleInstanceType) {
            this.singleInstanceType = singleInstanceType;
            return this;
        }

        public final void setSingleInstanceType(Boolean singleInstanceType) {
            this.singleInstanceType = singleInstanceType;
        }

        public final Boolean getSingleAvailabilityZone() {
            return this.singleAvailabilityZone;
        }

        @Override
        public final Builder singleAvailabilityZone(Boolean singleAvailabilityZone) {
            this.singleAvailabilityZone = singleAvailabilityZone;
            return this;
        }

        public final void setSingleAvailabilityZone(Boolean singleAvailabilityZone) {
            this.singleAvailabilityZone = singleAvailabilityZone;
        }

        public final Integer getMinTargetCapacity() {
            return this.minTargetCapacity;
        }

        @Override
        public final Builder minTargetCapacity(Integer minTargetCapacity) {
            this.minTargetCapacity = minTargetCapacity;
            return this;
        }

        public final void setMinTargetCapacity(Integer minTargetCapacity) {
            this.minTargetCapacity = minTargetCapacity;
        }

        public OnDemandOptions build() {
            return new OnDemandOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OnDemandOptions> {
        public Builder allocationStrategy(String var1);

        public Builder allocationStrategy(FleetOnDemandAllocationStrategy var1);

        public Builder singleInstanceType(Boolean var1);

        public Builder singleAvailabilityZone(Boolean var1);

        public Builder minTargetCapacity(Integer var1);
    }
}

