/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.VolumeModificationState;
import software.amazon.awssdk.services.ec2.model.VolumeType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VolumeModification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VolumeModification> {
    private static final SdkField<String> VOLUME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VolumeModification.getter(VolumeModification::volumeId)).setter(VolumeModification.setter(Builder::volumeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId").unmarshallLocationName("volumeId").build()}).build();
    private static final SdkField<String> MODIFICATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VolumeModification.getter(VolumeModification::modificationStateAsString)).setter(VolumeModification.setter(Builder::modificationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModificationState").unmarshallLocationName("modificationState").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VolumeModification.getter(VolumeModification::statusMessage)).setter(VolumeModification.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").unmarshallLocationName("statusMessage").build()}).build();
    private static final SdkField<Integer> TARGET_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(VolumeModification.getter(VolumeModification::targetSize)).setter(VolumeModification.setter(Builder::targetSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetSize").unmarshallLocationName("targetSize").build()}).build();
    private static final SdkField<Integer> TARGET_IOPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(VolumeModification.getter(VolumeModification::targetIops)).setter(VolumeModification.setter(Builder::targetIops)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetIops").unmarshallLocationName("targetIops").build()}).build();
    private static final SdkField<String> TARGET_VOLUME_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VolumeModification.getter(VolumeModification::targetVolumeTypeAsString)).setter(VolumeModification.setter(Builder::targetVolumeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetVolumeType").unmarshallLocationName("targetVolumeType").build()}).build();
    private static final SdkField<Integer> ORIGINAL_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(VolumeModification.getter(VolumeModification::originalSize)).setter(VolumeModification.setter(Builder::originalSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginalSize").unmarshallLocationName("originalSize").build()}).build();
    private static final SdkField<Integer> ORIGINAL_IOPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(VolumeModification.getter(VolumeModification::originalIops)).setter(VolumeModification.setter(Builder::originalIops)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginalIops").unmarshallLocationName("originalIops").build()}).build();
    private static final SdkField<String> ORIGINAL_VOLUME_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VolumeModification.getter(VolumeModification::originalVolumeTypeAsString)).setter(VolumeModification.setter(Builder::originalVolumeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginalVolumeType").unmarshallLocationName("originalVolumeType").build()}).build();
    private static final SdkField<Long> PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(VolumeModification.getter(VolumeModification::progress)).setter(VolumeModification.setter(Builder::progress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Progress").unmarshallLocationName("progress").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(VolumeModification.getter(VolumeModification::startTime)).setter(VolumeModification.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").unmarshallLocationName("startTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(VolumeModification.getter(VolumeModification::endTime)).setter(VolumeModification.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").unmarshallLocationName("endTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_ID_FIELD, MODIFICATION_STATE_FIELD, STATUS_MESSAGE_FIELD, TARGET_SIZE_FIELD, TARGET_IOPS_FIELD, TARGET_VOLUME_TYPE_FIELD, ORIGINAL_SIZE_FIELD, ORIGINAL_IOPS_FIELD, ORIGINAL_VOLUME_TYPE_FIELD, PROGRESS_FIELD, START_TIME_FIELD, END_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String volumeId;
    private final String modificationState;
    private final String statusMessage;
    private final Integer targetSize;
    private final Integer targetIops;
    private final String targetVolumeType;
    private final Integer originalSize;
    private final Integer originalIops;
    private final String originalVolumeType;
    private final Long progress;
    private final Instant startTime;
    private final Instant endTime;

    private VolumeModification(BuilderImpl builder) {
        this.volumeId = builder.volumeId;
        this.modificationState = builder.modificationState;
        this.statusMessage = builder.statusMessage;
        this.targetSize = builder.targetSize;
        this.targetIops = builder.targetIops;
        this.targetVolumeType = builder.targetVolumeType;
        this.originalSize = builder.originalSize;
        this.originalIops = builder.originalIops;
        this.originalVolumeType = builder.originalVolumeType;
        this.progress = builder.progress;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    public String volumeId() {
        return this.volumeId;
    }

    public VolumeModificationState modificationState() {
        return VolumeModificationState.fromValue(this.modificationState);
    }

    public String modificationStateAsString() {
        return this.modificationState;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public Integer targetSize() {
        return this.targetSize;
    }

    public Integer targetIops() {
        return this.targetIops;
    }

    public VolumeType targetVolumeType() {
        return VolumeType.fromValue(this.targetVolumeType);
    }

    public String targetVolumeTypeAsString() {
        return this.targetVolumeType;
    }

    public Integer originalSize() {
        return this.originalSize;
    }

    public Integer originalIops() {
        return this.originalIops;
    }

    public VolumeType originalVolumeType() {
        return VolumeType.fromValue(this.originalVolumeType);
    }

    public String originalVolumeTypeAsString() {
        return this.originalVolumeType;
    }

    public Long progress() {
        return this.progress;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.modificationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetIops());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetVolumeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.originalSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.originalIops());
        hashCode = 31 * hashCode + Objects.hashCode(this.originalVolumeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.progress());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeModification)) {
            return false;
        }
        VolumeModification other = (VolumeModification)obj;
        return Objects.equals(this.volumeId(), other.volumeId()) && Objects.equals(this.modificationStateAsString(), other.modificationStateAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.targetSize(), other.targetSize()) && Objects.equals(this.targetIops(), other.targetIops()) && Objects.equals(this.targetVolumeTypeAsString(), other.targetVolumeTypeAsString()) && Objects.equals(this.originalSize(), other.originalSize()) && Objects.equals(this.originalIops(), other.originalIops()) && Objects.equals(this.originalVolumeTypeAsString(), other.originalVolumeTypeAsString()) && Objects.equals(this.progress(), other.progress()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime());
    }

    public String toString() {
        return ToString.builder((String)"VolumeModification").add("VolumeId", (Object)this.volumeId()).add("ModificationState", (Object)this.modificationStateAsString()).add("StatusMessage", (Object)this.statusMessage()).add("TargetSize", (Object)this.targetSize()).add("TargetIops", (Object)this.targetIops()).add("TargetVolumeType", (Object)this.targetVolumeTypeAsString()).add("OriginalSize", (Object)this.originalSize()).add("OriginalIops", (Object)this.originalIops()).add("OriginalVolumeType", (Object)this.originalVolumeTypeAsString()).add("Progress", (Object)this.progress()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VolumeId": {
                return Optional.ofNullable(clazz.cast(this.volumeId()));
            }
            case "ModificationState": {
                return Optional.ofNullable(clazz.cast(this.modificationStateAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "TargetSize": {
                return Optional.ofNullable(clazz.cast(this.targetSize()));
            }
            case "TargetIops": {
                return Optional.ofNullable(clazz.cast(this.targetIops()));
            }
            case "TargetVolumeType": {
                return Optional.ofNullable(clazz.cast(this.targetVolumeTypeAsString()));
            }
            case "OriginalSize": {
                return Optional.ofNullable(clazz.cast(this.originalSize()));
            }
            case "OriginalIops": {
                return Optional.ofNullable(clazz.cast(this.originalIops()));
            }
            case "OriginalVolumeType": {
                return Optional.ofNullable(clazz.cast(this.originalVolumeTypeAsString()));
            }
            case "Progress": {
                return Optional.ofNullable(clazz.cast(this.progress()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VolumeModification, T> g) {
        return obj -> g.apply((VolumeModification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String volumeId;
        private String modificationState;
        private String statusMessage;
        private Integer targetSize;
        private Integer targetIops;
        private String targetVolumeType;
        private Integer originalSize;
        private Integer originalIops;
        private String originalVolumeType;
        private Long progress;
        private Instant startTime;
        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeModification model) {
            this.volumeId(model.volumeId);
            this.modificationState(model.modificationState);
            this.statusMessage(model.statusMessage);
            this.targetSize(model.targetSize);
            this.targetIops(model.targetIops);
            this.targetVolumeType(model.targetVolumeType);
            this.originalSize(model.originalSize);
            this.originalIops(model.originalIops);
            this.originalVolumeType(model.originalVolumeType);
            this.progress(model.progress);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
        }

        public final String getVolumeId() {
            return this.volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        public final String getModificationStateAsString() {
            return this.modificationState;
        }

        @Override
        public final Builder modificationState(String modificationState) {
            this.modificationState = modificationState;
            return this;
        }

        @Override
        public final Builder modificationState(VolumeModificationState modificationState) {
            this.modificationState(modificationState.toString());
            return this;
        }

        public final void setModificationState(String modificationState) {
            this.modificationState = modificationState;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final Integer getTargetSize() {
            return this.targetSize;
        }

        @Override
        public final Builder targetSize(Integer targetSize) {
            this.targetSize = targetSize;
            return this;
        }

        public final void setTargetSize(Integer targetSize) {
            this.targetSize = targetSize;
        }

        public final Integer getTargetIops() {
            return this.targetIops;
        }

        @Override
        public final Builder targetIops(Integer targetIops) {
            this.targetIops = targetIops;
            return this;
        }

        public final void setTargetIops(Integer targetIops) {
            this.targetIops = targetIops;
        }

        public final String getTargetVolumeTypeAsString() {
            return this.targetVolumeType;
        }

        @Override
        public final Builder targetVolumeType(String targetVolumeType) {
            this.targetVolumeType = targetVolumeType;
            return this;
        }

        @Override
        public final Builder targetVolumeType(VolumeType targetVolumeType) {
            this.targetVolumeType(targetVolumeType.toString());
            return this;
        }

        public final void setTargetVolumeType(String targetVolumeType) {
            this.targetVolumeType = targetVolumeType;
        }

        public final Integer getOriginalSize() {
            return this.originalSize;
        }

        @Override
        public final Builder originalSize(Integer originalSize) {
            this.originalSize = originalSize;
            return this;
        }

        public final void setOriginalSize(Integer originalSize) {
            this.originalSize = originalSize;
        }

        public final Integer getOriginalIops() {
            return this.originalIops;
        }

        @Override
        public final Builder originalIops(Integer originalIops) {
            this.originalIops = originalIops;
            return this;
        }

        public final void setOriginalIops(Integer originalIops) {
            this.originalIops = originalIops;
        }

        public final String getOriginalVolumeTypeAsString() {
            return this.originalVolumeType;
        }

        @Override
        public final Builder originalVolumeType(String originalVolumeType) {
            this.originalVolumeType = originalVolumeType;
            return this;
        }

        @Override
        public final Builder originalVolumeType(VolumeType originalVolumeType) {
            this.originalVolumeType(originalVolumeType.toString());
            return this;
        }

        public final void setOriginalVolumeType(String originalVolumeType) {
            this.originalVolumeType = originalVolumeType;
        }

        public final Long getProgress() {
            return this.progress;
        }

        @Override
        public final Builder progress(Long progress) {
            this.progress = progress;
            return this;
        }

        public final void setProgress(Long progress) {
            this.progress = progress;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public VolumeModification build() {
            return new VolumeModification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VolumeModification> {
        public Builder volumeId(String var1);

        public Builder modificationState(String var1);

        public Builder modificationState(VolumeModificationState var1);

        public Builder statusMessage(String var1);

        public Builder targetSize(Integer var1);

        public Builder targetIops(Integer var1);

        public Builder targetVolumeType(String var1);

        public Builder targetVolumeType(VolumeType var1);

        public Builder originalSize(Integer var1);

        public Builder originalIops(Integer var1);

        public Builder originalVolumeType(String var1);

        public Builder originalVolumeType(VolumeType var1);

        public Builder progress(Long var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);
    }
}

