/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.RouteTable;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRouteTableResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, CreateRouteTableResponse> {
    private static final SdkField<RouteTable> ROUTE_TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateRouteTableResponse.getter(CreateRouteTableResponse::routeTable)).setter(CreateRouteTableResponse.setter(Builder::routeTable)).constructor(RouteTable::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTable").unmarshallLocationName("routeTable").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTE_TABLE_FIELD));
    private final RouteTable routeTable;

    private CreateRouteTableResponse(BuilderImpl builder) {
        super(builder);
        this.routeTable = builder.routeTable;
    }

    public RouteTable routeTable() {
        return this.routeTable;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.routeTable());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRouteTableResponse)) {
            return false;
        }
        CreateRouteTableResponse other = (CreateRouteTableResponse)((Object)obj);
        return Objects.equals(this.routeTable(), other.routeTable());
    }

    public String toString() {
        return ToString.builder((String)"CreateRouteTableResponse").add("RouteTable", (Object)this.routeTable()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RouteTable": {
                return Optional.ofNullable(clazz.cast(this.routeTable()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRouteTableResponse, T> g) {
        return obj -> g.apply((CreateRouteTableResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private RouteTable routeTable;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRouteTableResponse model) {
            super(model);
            this.routeTable(model.routeTable);
        }

        public final RouteTable.Builder getRouteTable() {
            return this.routeTable != null ? this.routeTable.toBuilder() : null;
        }

        @Override
        public final Builder routeTable(RouteTable routeTable) {
            this.routeTable = routeTable;
            return this;
        }

        public final void setRouteTable(RouteTable.BuilderImpl routeTable) {
            this.routeTable = routeTable != null ? routeTable.build() : null;
        }

        @Override
        public CreateRouteTableResponse build() {
            return new CreateRouteTableResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRouteTableResponse> {
        public Builder routeTable(RouteTable var1);

        default public Builder routeTable(Consumer<RouteTable.Builder> routeTable) {
            return this.routeTable((RouteTable)((RouteTable.Builder)RouteTable.builder().applyMutation(routeTable)).build());
        }
    }
}

