/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectionLogOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConnectionLogOptions> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ConnectionLogOptions.getter(ConnectionLogOptions::enabled)).setter(ConnectionLogOptions.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").unmarshallLocationName("Enabled").build()}).build();
    private static final SdkField<String> CLOUDWATCH_LOG_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ConnectionLogOptions.getter(ConnectionLogOptions::cloudwatchLogGroup)).setter(ConnectionLogOptions.setter(Builder::cloudwatchLogGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudwatchLogGroup").unmarshallLocationName("CloudwatchLogGroup").build()}).build();
    private static final SdkField<String> CLOUDWATCH_LOG_STREAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ConnectionLogOptions.getter(ConnectionLogOptions::cloudwatchLogStream)).setter(ConnectionLogOptions.setter(Builder::cloudwatchLogStream)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudwatchLogStream").unmarshallLocationName("CloudwatchLogStream").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, CLOUDWATCH_LOG_GROUP_FIELD, CLOUDWATCH_LOG_STREAM_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean enabled;
    private final String cloudwatchLogGroup;
    private final String cloudwatchLogStream;

    private ConnectionLogOptions(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.cloudwatchLogGroup = builder.cloudwatchLogGroup;
        this.cloudwatchLogStream = builder.cloudwatchLogStream;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public String cloudwatchLogGroup() {
        return this.cloudwatchLogGroup;
    }

    public String cloudwatchLogStream() {
        return this.cloudwatchLogStream;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudwatchLogGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudwatchLogStream());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionLogOptions)) {
            return false;
        }
        ConnectionLogOptions other = (ConnectionLogOptions)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.cloudwatchLogGroup(), other.cloudwatchLogGroup()) && Objects.equals(this.cloudwatchLogStream(), other.cloudwatchLogStream());
    }

    public String toString() {
        return ToString.builder((String)"ConnectionLogOptions").add("Enabled", (Object)this.enabled()).add("CloudwatchLogGroup", (Object)this.cloudwatchLogGroup()).add("CloudwatchLogStream", (Object)this.cloudwatchLogStream()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "CloudwatchLogGroup": {
                return Optional.ofNullable(clazz.cast(this.cloudwatchLogGroup()));
            }
            case "CloudwatchLogStream": {
                return Optional.ofNullable(clazz.cast(this.cloudwatchLogStream()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectionLogOptions, T> g) {
        return obj -> g.apply((ConnectionLogOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private String cloudwatchLogGroup;
        private String cloudwatchLogStream;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionLogOptions model) {
            this.enabled(model.enabled);
            this.cloudwatchLogGroup(model.cloudwatchLogGroup);
            this.cloudwatchLogStream(model.cloudwatchLogStream);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getCloudwatchLogGroup() {
            return this.cloudwatchLogGroup;
        }

        @Override
        public final Builder cloudwatchLogGroup(String cloudwatchLogGroup) {
            this.cloudwatchLogGroup = cloudwatchLogGroup;
            return this;
        }

        public final void setCloudwatchLogGroup(String cloudwatchLogGroup) {
            this.cloudwatchLogGroup = cloudwatchLogGroup;
        }

        public final String getCloudwatchLogStream() {
            return this.cloudwatchLogStream;
        }

        @Override
        public final Builder cloudwatchLogStream(String cloudwatchLogStream) {
            this.cloudwatchLogStream = cloudwatchLogStream;
            return this;
        }

        public final void setCloudwatchLogStream(String cloudwatchLogStream) {
            this.cloudwatchLogStream = cloudwatchLogStream;
        }

        public ConnectionLogOptions build() {
            return new ConnectionLogOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConnectionLogOptions> {
        public Builder enabled(Boolean var1);

        public Builder cloudwatchLogGroup(String var1);

        public Builder cloudwatchLogStream(String var1);
    }
}

