/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum BatchState {
    SUBMITTED("submitted"),
    ACTIVE("active"),
    CANCELLED("cancelled"),
    FAILED("failed"),
    CANCELLED_RUNNING("cancelled_running"),
    CANCELLED_TERMINATING("cancelled_terminating"),
    MODIFYING("modifying"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private BatchState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BatchState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(BatchState.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BatchState> knownValues() {
        return Stream.of(BatchState.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

