/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.PriceScheduleSpecification;
import software.amazon.awssdk.services.ec2.model.PriceScheduleSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateReservedInstancesListingRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateReservedInstancesListingRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateReservedInstancesListingRequest.getter(CreateReservedInstancesListingRequest::clientToken)).setter(CreateReservedInstancesListingRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("clientToken").build()}).build();
    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CreateReservedInstancesListingRequest.getter(CreateReservedInstancesListingRequest::instanceCount)).setter(CreateReservedInstancesListingRequest.setter(Builder::instanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").unmarshallLocationName("instanceCount").build()}).build();
    private static final SdkField<List<PriceScheduleSpecification>> PRICE_SCHEDULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateReservedInstancesListingRequest.getter(CreateReservedInstancesListingRequest::priceSchedules)).setter(CreateReservedInstancesListingRequest.setter(Builder::priceSchedules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PriceSchedules").unmarshallLocationName("priceSchedules").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PriceScheduleSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> RESERVED_INSTANCES_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateReservedInstancesListingRequest.getter(CreateReservedInstancesListingRequest::reservedInstancesId)).setter(CreateReservedInstancesListingRequest.setter(Builder::reservedInstancesId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstancesId").unmarshallLocationName("reservedInstancesId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, INSTANCE_COUNT_FIELD, PRICE_SCHEDULES_FIELD, RESERVED_INSTANCES_ID_FIELD));
    private final String clientToken;
    private final Integer instanceCount;
    private final List<PriceScheduleSpecification> priceSchedules;
    private final String reservedInstancesId;

    private CreateReservedInstancesListingRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.instanceCount = builder.instanceCount;
        this.priceSchedules = builder.priceSchedules;
        this.reservedInstancesId = builder.reservedInstancesId;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public Integer instanceCount() {
        return this.instanceCount;
    }

    public List<PriceScheduleSpecification> priceSchedules() {
        return this.priceSchedules;
    }

    public String reservedInstancesId() {
        return this.reservedInstancesId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.priceSchedules());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedInstancesId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReservedInstancesListingRequest)) {
            return false;
        }
        CreateReservedInstancesListingRequest other = (CreateReservedInstancesListingRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.instanceCount(), other.instanceCount()) && Objects.equals(this.priceSchedules(), other.priceSchedules()) && Objects.equals(this.reservedInstancesId(), other.reservedInstancesId());
    }

    public String toString() {
        return ToString.builder((String)"CreateReservedInstancesListingRequest").add("ClientToken", (Object)this.clientToken()).add("InstanceCount", (Object)this.instanceCount()).add("PriceSchedules", this.priceSchedules()).add("ReservedInstancesId", (Object)this.reservedInstancesId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "InstanceCount": {
                return Optional.ofNullable(clazz.cast(this.instanceCount()));
            }
            case "PriceSchedules": {
                return Optional.ofNullable(clazz.cast(this.priceSchedules()));
            }
            case "ReservedInstancesId": {
                return Optional.ofNullable(clazz.cast(this.reservedInstancesId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateReservedInstancesListingRequest, T> g) {
        return obj -> g.apply((CreateReservedInstancesListingRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String clientToken;
        private Integer instanceCount;
        private List<PriceScheduleSpecification> priceSchedules = DefaultSdkAutoConstructList.getInstance();
        private String reservedInstancesId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReservedInstancesListingRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.instanceCount(model.instanceCount);
            this.priceSchedules(model.priceSchedules);
            this.reservedInstancesId(model.reservedInstancesId);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final Collection<PriceScheduleSpecification.Builder> getPriceSchedules() {
            return this.priceSchedules != null ? (Collection)this.priceSchedules.stream().map(PriceScheduleSpecification::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder priceSchedules(Collection<PriceScheduleSpecification> priceSchedules) {
            this.priceSchedules = PriceScheduleSpecificationListCopier.copy(priceSchedules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder priceSchedules(PriceScheduleSpecification ... priceSchedules) {
            this.priceSchedules(Arrays.asList(priceSchedules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder priceSchedules(Consumer<PriceScheduleSpecification.Builder> ... priceSchedules) {
            this.priceSchedules(Stream.of(priceSchedules).map(c -> (PriceScheduleSpecification)((PriceScheduleSpecification.Builder)PriceScheduleSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPriceSchedules(Collection<PriceScheduleSpecification.BuilderImpl> priceSchedules) {
            this.priceSchedules = PriceScheduleSpecificationListCopier.copyFromBuilder(priceSchedules);
        }

        public final String getReservedInstancesId() {
            return this.reservedInstancesId;
        }

        @Override
        public final Builder reservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
            return this;
        }

        public final void setReservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateReservedInstancesListingRequest build() {
            return new CreateReservedInstancesListingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateReservedInstancesListingRequest> {
        public Builder clientToken(String var1);

        public Builder instanceCount(Integer var1);

        public Builder priceSchedules(Collection<PriceScheduleSpecification> var1);

        public Builder priceSchedules(PriceScheduleSpecification ... var1);

        public Builder priceSchedules(Consumer<PriceScheduleSpecification.Builder> ... var1);

        public Builder reservedInstancesId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

