/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.VpcEndpointConnection;
import software.amazon.awssdk.services.ec2.model.VpcEndpointConnectionSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeVpcEndpointConnectionsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeVpcEndpointConnectionsResponse> {
    private static final SdkField<List<VpcEndpointConnection>> VPC_ENDPOINT_CONNECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeVpcEndpointConnectionsResponse.getter(DescribeVpcEndpointConnectionsResponse::vpcEndpointConnections)).setter(DescribeVpcEndpointConnectionsResponse.setter(Builder::vpcEndpointConnections)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointConnectionSet").unmarshallLocationName("vpcEndpointConnectionSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VpcEndpointConnection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeVpcEndpointConnectionsResponse.getter(DescribeVpcEndpointConnectionsResponse::nextToken)).setter(DescribeVpcEndpointConnectionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_ENDPOINT_CONNECTIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<VpcEndpointConnection> vpcEndpointConnections;
    private final String nextToken;

    private DescribeVpcEndpointConnectionsResponse(BuilderImpl builder) {
        super(builder);
        this.vpcEndpointConnections = builder.vpcEndpointConnections;
        this.nextToken = builder.nextToken;
    }

    public List<VpcEndpointConnection> vpcEndpointConnections() {
        return this.vpcEndpointConnections;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointConnections());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcEndpointConnectionsResponse)) {
            return false;
        }
        DescribeVpcEndpointConnectionsResponse other = (DescribeVpcEndpointConnectionsResponse)((Object)obj);
        return Objects.equals(this.vpcEndpointConnections(), other.vpcEndpointConnections()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeVpcEndpointConnectionsResponse").add("VpcEndpointConnections", this.vpcEndpointConnections()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VpcEndpointConnections": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointConnections()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVpcEndpointConnectionsResponse, T> g) {
        return obj -> g.apply((DescribeVpcEndpointConnectionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<VpcEndpointConnection> vpcEndpointConnections = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcEndpointConnectionsResponse model) {
            super(model);
            this.vpcEndpointConnections(model.vpcEndpointConnections);
            this.nextToken(model.nextToken);
        }

        public final Collection<VpcEndpointConnection.Builder> getVpcEndpointConnections() {
            return this.vpcEndpointConnections != null ? (Collection)this.vpcEndpointConnections.stream().map(VpcEndpointConnection::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder vpcEndpointConnections(Collection<VpcEndpointConnection> vpcEndpointConnections) {
            this.vpcEndpointConnections = VpcEndpointConnectionSetCopier.copy(vpcEndpointConnections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEndpointConnections(VpcEndpointConnection ... vpcEndpointConnections) {
            this.vpcEndpointConnections(Arrays.asList(vpcEndpointConnections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEndpointConnections(Consumer<VpcEndpointConnection.Builder> ... vpcEndpointConnections) {
            this.vpcEndpointConnections(Stream.of(vpcEndpointConnections).map(c -> (VpcEndpointConnection)((VpcEndpointConnection.Builder)VpcEndpointConnection.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVpcEndpointConnections(Collection<VpcEndpointConnection.BuilderImpl> vpcEndpointConnections) {
            this.vpcEndpointConnections = VpcEndpointConnectionSetCopier.copyFromBuilder(vpcEndpointConnections);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeVpcEndpointConnectionsResponse build() {
            return new DescribeVpcEndpointConnectionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeVpcEndpointConnectionsResponse> {
        public Builder vpcEndpointConnections(Collection<VpcEndpointConnection> var1);

        public Builder vpcEndpointConnections(VpcEndpointConnection ... var1);

        public Builder vpcEndpointConnections(Consumer<VpcEndpointConnection.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

