/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteIpamPrefixListResolverTargetRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DeleteIpamPrefixListResolverTargetRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(DeleteIpamPrefixListResolverTargetRequest.getter(DeleteIpamPrefixListResolverTargetRequest::dryRun)).setter(DeleteIpamPrefixListResolverTargetRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<String> IPAM_PREFIX_LIST_RESOLVER_TARGET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamPrefixListResolverTargetId").getter(DeleteIpamPrefixListResolverTargetRequest.getter(DeleteIpamPrefixListResolverTargetRequest::ipamPrefixListResolverTargetId)).setter(DeleteIpamPrefixListResolverTargetRequest.setter(Builder::ipamPrefixListResolverTargetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPrefixListResolverTargetId").unmarshallLocationName("IpamPrefixListResolverTargetId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, IPAM_PREFIX_LIST_RESOLVER_TARGET_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteIpamPrefixListResolverTargetRequest.memberNameToFieldInitializer();
    private final Boolean dryRun;
    private final String ipamPrefixListResolverTargetId;

    private DeleteIpamPrefixListResolverTargetRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.ipamPrefixListResolverTargetId = builder.ipamPrefixListResolverTargetId;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String ipamPrefixListResolverTargetId() {
        return this.ipamPrefixListResolverTargetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamPrefixListResolverTargetId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteIpamPrefixListResolverTargetRequest)) {
            return false;
        }
        DeleteIpamPrefixListResolverTargetRequest other = (DeleteIpamPrefixListResolverTargetRequest)((Object)obj);
        return Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.ipamPrefixListResolverTargetId(), other.ipamPrefixListResolverTargetId());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteIpamPrefixListResolverTargetRequest").add("DryRun", (Object)this.dryRun()).add("IpamPrefixListResolverTargetId", (Object)this.ipamPrefixListResolverTargetId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "IpamPrefixListResolverTargetId": {
                return Optional.ofNullable(clazz.cast(this.ipamPrefixListResolverTargetId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("IpamPrefixListResolverTargetId", IPAM_PREFIX_LIST_RESOLVER_TARGET_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteIpamPrefixListResolverTargetRequest, T> g) {
        return obj -> g.apply((DeleteIpamPrefixListResolverTargetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean dryRun;
        private String ipamPrefixListResolverTargetId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteIpamPrefixListResolverTargetRequest model) {
            super(model);
            this.dryRun(model.dryRun);
            this.ipamPrefixListResolverTargetId(model.ipamPrefixListResolverTargetId);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getIpamPrefixListResolverTargetId() {
            return this.ipamPrefixListResolverTargetId;
        }

        public final void setIpamPrefixListResolverTargetId(String ipamPrefixListResolverTargetId) {
            this.ipamPrefixListResolverTargetId = ipamPrefixListResolverTargetId;
        }

        @Override
        public final Builder ipamPrefixListResolverTargetId(String ipamPrefixListResolverTargetId) {
            this.ipamPrefixListResolverTargetId = ipamPrefixListResolverTargetId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteIpamPrefixListResolverTargetRequest build() {
            return new DeleteIpamPrefixListResolverTargetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteIpamPrefixListResolverTargetRequest> {
        public Builder dryRun(Boolean var1);

        public Builder ipamPrefixListResolverTargetId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

