/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyRuleMetaData;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransitGatewayPolicyRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransitGatewayPolicyRule> {
    private static final SdkField<String> SOURCE_CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceCidrBlock").getter(TransitGatewayPolicyRule.getter(TransitGatewayPolicyRule::sourceCidrBlock)).setter(TransitGatewayPolicyRule.setter(Builder::sourceCidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceCidrBlock").unmarshallLocationName("sourceCidrBlock").build()}).build();
    private static final SdkField<String> SOURCE_PORT_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourcePortRange").getter(TransitGatewayPolicyRule.getter(TransitGatewayPolicyRule::sourcePortRange)).setter(TransitGatewayPolicyRule.setter(Builder::sourcePortRange)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePortRange").unmarshallLocationName("sourcePortRange").build()}).build();
    private static final SdkField<String> DESTINATION_CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationCidrBlock").getter(TransitGatewayPolicyRule.getter(TransitGatewayPolicyRule::destinationCidrBlock)).setter(TransitGatewayPolicyRule.setter(Builder::destinationCidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCidrBlock").unmarshallLocationName("destinationCidrBlock").build()}).build();
    private static final SdkField<String> DESTINATION_PORT_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationPortRange").getter(TransitGatewayPolicyRule.getter(TransitGatewayPolicyRule::destinationPortRange)).setter(TransitGatewayPolicyRule.setter(Builder::destinationPortRange)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPortRange").unmarshallLocationName("destinationPortRange").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Protocol").getter(TransitGatewayPolicyRule.getter(TransitGatewayPolicyRule::protocol)).setter(TransitGatewayPolicyRule.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").unmarshallLocationName("protocol").build()}).build();
    private static final SdkField<TransitGatewayPolicyRuleMetaData> META_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MetaData").getter(TransitGatewayPolicyRule.getter(TransitGatewayPolicyRule::metaData)).setter(TransitGatewayPolicyRule.setter(Builder::metaData)).constructor(TransitGatewayPolicyRuleMetaData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetaData").unmarshallLocationName("metaData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_CIDR_BLOCK_FIELD, SOURCE_PORT_RANGE_FIELD, DESTINATION_CIDR_BLOCK_FIELD, DESTINATION_PORT_RANGE_FIELD, PROTOCOL_FIELD, META_DATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TransitGatewayPolicyRule.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String sourceCidrBlock;
    private final String sourcePortRange;
    private final String destinationCidrBlock;
    private final String destinationPortRange;
    private final String protocol;
    private final TransitGatewayPolicyRuleMetaData metaData;

    private TransitGatewayPolicyRule(BuilderImpl builder) {
        this.sourceCidrBlock = builder.sourceCidrBlock;
        this.sourcePortRange = builder.sourcePortRange;
        this.destinationCidrBlock = builder.destinationCidrBlock;
        this.destinationPortRange = builder.destinationPortRange;
        this.protocol = builder.protocol;
        this.metaData = builder.metaData;
    }

    public final String sourceCidrBlock() {
        return this.sourceCidrBlock;
    }

    public final String sourcePortRange() {
        return this.sourcePortRange;
    }

    public final String destinationCidrBlock() {
        return this.destinationCidrBlock;
    }

    public final String destinationPortRange() {
        return this.destinationPortRange;
    }

    public final String protocol() {
        return this.protocol;
    }

    public final TransitGatewayPolicyRuleMetaData metaData() {
        return this.metaData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourcePortRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationPortRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocol());
        hashCode = 31 * hashCode + Objects.hashCode(this.metaData());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayPolicyRule)) {
            return false;
        }
        TransitGatewayPolicyRule other = (TransitGatewayPolicyRule)obj;
        return Objects.equals(this.sourceCidrBlock(), other.sourceCidrBlock()) && Objects.equals(this.sourcePortRange(), other.sourcePortRange()) && Objects.equals(this.destinationCidrBlock(), other.destinationCidrBlock()) && Objects.equals(this.destinationPortRange(), other.destinationPortRange()) && Objects.equals(this.protocol(), other.protocol()) && Objects.equals(this.metaData(), other.metaData());
    }

    public final String toString() {
        return ToString.builder((String)"TransitGatewayPolicyRule").add("SourceCidrBlock", (Object)this.sourceCidrBlock()).add("SourcePortRange", (Object)this.sourcePortRange()).add("DestinationCidrBlock", (Object)this.destinationCidrBlock()).add("DestinationPortRange", (Object)this.destinationPortRange()).add("Protocol", (Object)this.protocol()).add("MetaData", (Object)this.metaData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceCidrBlock": {
                return Optional.ofNullable(clazz.cast(this.sourceCidrBlock()));
            }
            case "SourcePortRange": {
                return Optional.ofNullable(clazz.cast(this.sourcePortRange()));
            }
            case "DestinationCidrBlock": {
                return Optional.ofNullable(clazz.cast(this.destinationCidrBlock()));
            }
            case "DestinationPortRange": {
                return Optional.ofNullable(clazz.cast(this.destinationPortRange()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocol()));
            }
            case "MetaData": {
                return Optional.ofNullable(clazz.cast(this.metaData()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SourceCidrBlock", SOURCE_CIDR_BLOCK_FIELD);
        map.put("SourcePortRange", SOURCE_PORT_RANGE_FIELD);
        map.put("DestinationCidrBlock", DESTINATION_CIDR_BLOCK_FIELD);
        map.put("DestinationPortRange", DESTINATION_PORT_RANGE_FIELD);
        map.put("Protocol", PROTOCOL_FIELD);
        map.put("MetaData", META_DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayPolicyRule, T> g) {
        return obj -> g.apply((TransitGatewayPolicyRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceCidrBlock;
        private String sourcePortRange;
        private String destinationCidrBlock;
        private String destinationPortRange;
        private String protocol;
        private TransitGatewayPolicyRuleMetaData metaData;

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayPolicyRule model) {
            this.sourceCidrBlock(model.sourceCidrBlock);
            this.sourcePortRange(model.sourcePortRange);
            this.destinationCidrBlock(model.destinationCidrBlock);
            this.destinationPortRange(model.destinationPortRange);
            this.protocol(model.protocol);
            this.metaData(model.metaData);
        }

        public final String getSourceCidrBlock() {
            return this.sourceCidrBlock;
        }

        public final void setSourceCidrBlock(String sourceCidrBlock) {
            this.sourceCidrBlock = sourceCidrBlock;
        }

        @Override
        public final Builder sourceCidrBlock(String sourceCidrBlock) {
            this.sourceCidrBlock = sourceCidrBlock;
            return this;
        }

        public final String getSourcePortRange() {
            return this.sourcePortRange;
        }

        public final void setSourcePortRange(String sourcePortRange) {
            this.sourcePortRange = sourcePortRange;
        }

        @Override
        public final Builder sourcePortRange(String sourcePortRange) {
            this.sourcePortRange = sourcePortRange;
            return this;
        }

        public final String getDestinationCidrBlock() {
            return this.destinationCidrBlock;
        }

        public final void setDestinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
        }

        @Override
        public final Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        public final String getDestinationPortRange() {
            return this.destinationPortRange;
        }

        public final void setDestinationPortRange(String destinationPortRange) {
            this.destinationPortRange = destinationPortRange;
        }

        @Override
        public final Builder destinationPortRange(String destinationPortRange) {
            this.destinationPortRange = destinationPortRange;
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final TransitGatewayPolicyRuleMetaData.Builder getMetaData() {
            return this.metaData != null ? this.metaData.toBuilder() : null;
        }

        public final void setMetaData(TransitGatewayPolicyRuleMetaData.BuilderImpl metaData) {
            this.metaData = metaData != null ? metaData.build() : null;
        }

        @Override
        public final Builder metaData(TransitGatewayPolicyRuleMetaData metaData) {
            this.metaData = metaData;
            return this;
        }

        public TransitGatewayPolicyRule build() {
            return new TransitGatewayPolicyRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransitGatewayPolicyRule> {
        public Builder sourceCidrBlock(String var1);

        public Builder sourcePortRange(String var1);

        public Builder destinationCidrBlock(String var1);

        public Builder destinationPortRange(String var1);

        public Builder protocol(String var1);

        public Builder metaData(TransitGatewayPolicyRuleMetaData var1);

        default public Builder metaData(Consumer<TransitGatewayPolicyRuleMetaData.Builder> metaData) {
            return this.metaData((TransitGatewayPolicyRuleMetaData)((TransitGatewayPolicyRuleMetaData.Builder)TransitGatewayPolicyRuleMetaData.builder().applyMutation(metaData)).build());
        }
    }
}

