/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.IpamPolicyAllocationRule;
import software.amazon.awssdk.services.ec2.model.IpamPolicyAllocationRuleListCopier;
import software.amazon.awssdk.services.ec2.model.IpamPolicyResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IpamPolicyDocument
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IpamPolicyDocument> {
    private static final SdkField<String> IPAM_POLICY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamPolicyId").getter(IpamPolicyDocument.getter(IpamPolicyDocument::ipamPolicyId)).setter(IpamPolicyDocument.setter(Builder::ipamPolicyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPolicyId").unmarshallLocationName("ipamPolicyId").build()}).build();
    private static final SdkField<String> LOCALE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Locale").getter(IpamPolicyDocument.getter(IpamPolicyDocument::locale)).setter(IpamPolicyDocument.setter(Builder::locale)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locale").unmarshallLocationName("locale").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(IpamPolicyDocument.getter(IpamPolicyDocument::resourceTypeAsString)).setter(IpamPolicyDocument.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").unmarshallLocationName("resourceType").build()}).build();
    private static final SdkField<List<IpamPolicyAllocationRule>> ALLOCATION_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AllocationRules").getter(IpamPolicyDocument.getter(IpamPolicyDocument::allocationRules)).setter(IpamPolicyDocument.setter(Builder::allocationRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationRuleSet").unmarshallLocationName("allocationRuleSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpamPolicyAllocationRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPAM_POLICY_ID_FIELD, LOCALE_FIELD, RESOURCE_TYPE_FIELD, ALLOCATION_RULES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IpamPolicyDocument.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String ipamPolicyId;
    private final String locale;
    private final String resourceType;
    private final List<IpamPolicyAllocationRule> allocationRules;

    private IpamPolicyDocument(BuilderImpl builder) {
        this.ipamPolicyId = builder.ipamPolicyId;
        this.locale = builder.locale;
        this.resourceType = builder.resourceType;
        this.allocationRules = builder.allocationRules;
    }

    public final String ipamPolicyId() {
        return this.ipamPolicyId;
    }

    public final String locale() {
        return this.locale;
    }

    public final IpamPolicyResourceType resourceType() {
        return IpamPolicyResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final boolean hasAllocationRules() {
        return this.allocationRules != null && !(this.allocationRules instanceof SdkAutoConstructList);
    }

    public final List<IpamPolicyAllocationRule> allocationRules() {
        return this.allocationRules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamPolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.locale());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllocationRules() ? this.allocationRules() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpamPolicyDocument)) {
            return false;
        }
        IpamPolicyDocument other = (IpamPolicyDocument)obj;
        return Objects.equals(this.ipamPolicyId(), other.ipamPolicyId()) && Objects.equals(this.locale(), other.locale()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && this.hasAllocationRules() == other.hasAllocationRules() && Objects.equals(this.allocationRules(), other.allocationRules());
    }

    public final String toString() {
        return ToString.builder((String)"IpamPolicyDocument").add("IpamPolicyId", (Object)this.ipamPolicyId()).add("Locale", (Object)this.locale()).add("ResourceType", (Object)this.resourceTypeAsString()).add("AllocationRules", this.hasAllocationRules() ? this.allocationRules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IpamPolicyId": {
                return Optional.ofNullable(clazz.cast(this.ipamPolicyId()));
            }
            case "Locale": {
                return Optional.ofNullable(clazz.cast(this.locale()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "AllocationRules": {
                return Optional.ofNullable(clazz.cast(this.allocationRules()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IpamPolicyId", IPAM_POLICY_ID_FIELD);
        map.put("Locale", LOCALE_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("AllocationRuleSet", ALLOCATION_RULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IpamPolicyDocument, T> g) {
        return obj -> g.apply((IpamPolicyDocument)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ipamPolicyId;
        private String locale;
        private String resourceType;
        private List<IpamPolicyAllocationRule> allocationRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IpamPolicyDocument model) {
            this.ipamPolicyId(model.ipamPolicyId);
            this.locale(model.locale);
            this.resourceType(model.resourceType);
            this.allocationRules(model.allocationRules);
        }

        public final String getIpamPolicyId() {
            return this.ipamPolicyId;
        }

        public final void setIpamPolicyId(String ipamPolicyId) {
            this.ipamPolicyId = ipamPolicyId;
        }

        @Override
        public final Builder ipamPolicyId(String ipamPolicyId) {
            this.ipamPolicyId = ipamPolicyId;
            return this;
        }

        public final String getLocale() {
            return this.locale;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(IpamPolicyResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final List<IpamPolicyAllocationRule.Builder> getAllocationRules() {
            List<IpamPolicyAllocationRule.Builder> result = IpamPolicyAllocationRuleListCopier.copyToBuilder(this.allocationRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAllocationRules(Collection<IpamPolicyAllocationRule.BuilderImpl> allocationRules) {
            this.allocationRules = IpamPolicyAllocationRuleListCopier.copyFromBuilder(allocationRules);
        }

        @Override
        public final Builder allocationRules(Collection<IpamPolicyAllocationRule> allocationRules) {
            this.allocationRules = IpamPolicyAllocationRuleListCopier.copy(allocationRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allocationRules(IpamPolicyAllocationRule ... allocationRules) {
            this.allocationRules(Arrays.asList(allocationRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allocationRules(Consumer<IpamPolicyAllocationRule.Builder> ... allocationRules) {
            this.allocationRules(Stream.of(allocationRules).map(c -> (IpamPolicyAllocationRule)((IpamPolicyAllocationRule.Builder)IpamPolicyAllocationRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public IpamPolicyDocument build() {
            return new IpamPolicyDocument(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IpamPolicyDocument> {
        public Builder ipamPolicyId(String var1);

        public Builder locale(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(IpamPolicyResourceType var1);

        public Builder allocationRules(Collection<IpamPolicyAllocationRule> var1);

        public Builder allocationRules(IpamPolicyAllocationRule ... var1);

        public Builder allocationRules(Consumer<IpamPolicyAllocationRule.Builder> ... var1);
    }
}

