/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a volume that is currently in the Recycle Bin.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VolumeRecycleBinInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<VolumeRecycleBinInfo.Builder, VolumeRecycleBinInfo> {
    private static final SdkField<String> VOLUME_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VolumeId")
            .getter(getter(VolumeRecycleBinInfo::volumeId))
            .setter(setter(Builder::volumeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId")
                    .unmarshallLocationName("volumeId").build()).build();

    private static final SdkField<String> VOLUME_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VolumeType")
            .getter(getter(VolumeRecycleBinInfo::volumeTypeAsString))
            .setter(setter(Builder::volumeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeType")
                    .unmarshallLocationName("volumeType").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(VolumeRecycleBinInfo::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<Integer> SIZE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Size")
            .getter(getter(VolumeRecycleBinInfo::size))
            .setter(setter(Builder::size))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size")
                    .unmarshallLocationName("size").build()).build();

    private static final SdkField<Integer> IOPS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Iops")
            .getter(getter(VolumeRecycleBinInfo::iops))
            .setter(setter(Builder::iops))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops")
                    .unmarshallLocationName("iops").build()).build();

    private static final SdkField<Integer> THROUGHPUT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Throughput")
            .getter(getter(VolumeRecycleBinInfo::throughput))
            .setter(setter(Builder::throughput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Throughput")
                    .unmarshallLocationName("throughput").build()).build();

    private static final SdkField<String> OUTPOST_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OutpostArn")
            .getter(getter(VolumeRecycleBinInfo::outpostArn))
            .setter(setter(Builder::outpostArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostArn")
                    .unmarshallLocationName("outpostArn").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone")
            .getter(getter(VolumeRecycleBinInfo::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone")
                    .unmarshallLocationName("availabilityZone").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZoneId")
            .getter(getter(VolumeRecycleBinInfo::availabilityZoneId))
            .setter(setter(Builder::availabilityZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneId")
                    .unmarshallLocationName("availabilityZoneId").build()).build();

    private static final SdkField<String> SOURCE_VOLUME_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SourceVolumeId")
            .getter(getter(VolumeRecycleBinInfo::sourceVolumeId))
            .setter(setter(Builder::sourceVolumeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceVolumeId")
                    .unmarshallLocationName("sourceVolumeId").build()).build();

    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SnapshotId")
            .getter(getter(VolumeRecycleBinInfo::snapshotId))
            .setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId")
                    .unmarshallLocationName("snapshotId").build()).build();

    private static final SdkField<OperatorResponse> OPERATOR_FIELD = SdkField
            .<OperatorResponse> builder(MarshallingType.SDK_POJO)
            .memberName("Operator")
            .getter(getter(VolumeRecycleBinInfo::operator))
            .setter(setter(Builder::operator))
            .constructor(OperatorResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator")
                    .unmarshallLocationName("operator").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateTime")
            .getter(getter(VolumeRecycleBinInfo::createTime))
            .setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime")
                    .unmarshallLocationName("createTime").build()).build();

    private static final SdkField<Instant> RECYCLE_BIN_ENTER_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("RecycleBinEnterTime")
            .getter(getter(VolumeRecycleBinInfo::recycleBinEnterTime))
            .setter(setter(Builder::recycleBinEnterTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecycleBinEnterTime")
                    .unmarshallLocationName("recycleBinEnterTime").build()).build();

    private static final SdkField<Instant> RECYCLE_BIN_EXIT_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("RecycleBinExitTime")
            .getter(getter(VolumeRecycleBinInfo::recycleBinExitTime))
            .setter(setter(Builder::recycleBinExitTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecycleBinExitTime")
                    .unmarshallLocationName("recycleBinExitTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_ID_FIELD,
            VOLUME_TYPE_FIELD, STATE_FIELD, SIZE_FIELD, IOPS_FIELD, THROUGHPUT_FIELD, OUTPOST_ARN_FIELD, AVAILABILITY_ZONE_FIELD,
            AVAILABILITY_ZONE_ID_FIELD, SOURCE_VOLUME_ID_FIELD, SNAPSHOT_ID_FIELD, OPERATOR_FIELD, CREATE_TIME_FIELD,
            RECYCLE_BIN_ENTER_TIME_FIELD, RECYCLE_BIN_EXIT_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String volumeId;

    private final String volumeType;

    private final String state;

    private final Integer size;

    private final Integer iops;

    private final Integer throughput;

    private final String outpostArn;

    private final String availabilityZone;

    private final String availabilityZoneId;

    private final String sourceVolumeId;

    private final String snapshotId;

    private final OperatorResponse operator;

    private final Instant createTime;

    private final Instant recycleBinEnterTime;

    private final Instant recycleBinExitTime;

    private VolumeRecycleBinInfo(BuilderImpl builder) {
        this.volumeId = builder.volumeId;
        this.volumeType = builder.volumeType;
        this.state = builder.state;
        this.size = builder.size;
        this.iops = builder.iops;
        this.throughput = builder.throughput;
        this.outpostArn = builder.outpostArn;
        this.availabilityZone = builder.availabilityZone;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.sourceVolumeId = builder.sourceVolumeId;
        this.snapshotId = builder.snapshotId;
        this.operator = builder.operator;
        this.createTime = builder.createTime;
        this.recycleBinEnterTime = builder.recycleBinEnterTime;
        this.recycleBinExitTime = builder.recycleBinExitTime;
    }

    /**
     * <p>
     * The ID of the volume.
     * </p>
     * 
     * @return The ID of the volume.
     */
    public final String volumeId() {
        return volumeId;
    }

    /**
     * <p>
     * The volume type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #volumeType} will
     * return {@link VolumeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #volumeTypeAsString}.
     * </p>
     * 
     * @return The volume type.
     * @see VolumeType
     */
    public final VolumeType volumeType() {
        return VolumeType.fromValue(volumeType);
    }

    /**
     * <p>
     * The volume type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #volumeType} will
     * return {@link VolumeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #volumeTypeAsString}.
     * </p>
     * 
     * @return The volume type.
     * @see VolumeType
     */
    public final String volumeTypeAsString() {
        return volumeType;
    }

    /**
     * <p>
     * The state of the volume.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link VolumeState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the volume.
     * @see VolumeState
     */
    public final VolumeState state() {
        return VolumeState.fromValue(state);
    }

    /**
     * <p>
     * The state of the volume.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link VolumeState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the volume.
     * @see VolumeState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The size of the volume, in GiB.
     * </p>
     * 
     * @return The size of the volume, in GiB.
     */
    public final Integer size() {
        return size;
    }

    /**
     * <p>
     * The number of I/O operations per second (IOPS) for the volume.
     * </p>
     * 
     * @return The number of I/O operations per second (IOPS) for the volume.
     */
    public final Integer iops() {
        return iops;
    }

    /**
     * <p>
     * The throughput that the volume supports, in MiB/s.
     * </p>
     * 
     * @return The throughput that the volume supports, in MiB/s.
     */
    public final Integer throughput() {
        return throughput;
    }

    /**
     * <p>
     * The ARN of the Outpost on which the volume is stored. For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volumes-outposts.html">Amazon EBS volumes on
     * Outposts</a> in the <i>Amazon EBS User Guide</i>.
     * </p>
     * 
     * @return The ARN of the Outpost on which the volume is stored. For more information, see <a
     *         href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volumes-outposts.html">Amazon EBS volumes on
     *         Outposts</a> in the <i>Amazon EBS User Guide</i>.
     */
    public final String outpostArn() {
        return outpostArn;
    }

    /**
     * <p>
     * The Availability Zone for the volume.
     * </p>
     * 
     * @return The Availability Zone for the volume.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The ID of the Availability Zone for the volume.
     * </p>
     * 
     * @return The ID of the Availability Zone for the volume.
     */
    public final String availabilityZoneId() {
        return availabilityZoneId;
    }

    /**
     * <p>
     * The ID of the source volume.
     * </p>
     * 
     * @return The ID of the source volume.
     */
    public final String sourceVolumeId() {
        return sourceVolumeId;
    }

    /**
     * <p>
     * The snapshot from which the volume was created, if applicable.
     * </p>
     * 
     * @return The snapshot from which the volume was created, if applicable.
     */
    public final String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * The service provider that manages the volume.
     * </p>
     * 
     * @return The service provider that manages the volume.
     */
    public final OperatorResponse operator() {
        return operator;
    }

    /**
     * <p>
     * The time stamp when volume creation was initiated.
     * </p>
     * 
     * @return The time stamp when volume creation was initiated.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The date and time when the volume entered the Recycle Bin.
     * </p>
     * 
     * @return The date and time when the volume entered the Recycle Bin.
     */
    public final Instant recycleBinEnterTime() {
        return recycleBinEnterTime;
    }

    /**
     * <p>
     * The date and time when the volume is to be permanently deleted from the Recycle Bin.
     * </p>
     * 
     * @return The date and time when the volume is to be permanently deleted from the Recycle Bin.
     */
    public final Instant recycleBinExitTime() {
        return recycleBinExitTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(volumeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(size());
        hashCode = 31 * hashCode + Objects.hashCode(iops());
        hashCode = 31 * hashCode + Objects.hashCode(throughput());
        hashCode = 31 * hashCode + Objects.hashCode(outpostArn());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceVolumeId());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(operator());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(recycleBinEnterTime());
        hashCode = 31 * hashCode + Objects.hashCode(recycleBinExitTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeRecycleBinInfo)) {
            return false;
        }
        VolumeRecycleBinInfo other = (VolumeRecycleBinInfo) obj;
        return Objects.equals(volumeId(), other.volumeId()) && Objects.equals(volumeTypeAsString(), other.volumeTypeAsString())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(size(), other.size())
                && Objects.equals(iops(), other.iops()) && Objects.equals(throughput(), other.throughput())
                && Objects.equals(outpostArn(), other.outpostArn())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(availabilityZoneId(), other.availabilityZoneId())
                && Objects.equals(sourceVolumeId(), other.sourceVolumeId()) && Objects.equals(snapshotId(), other.snapshotId())
                && Objects.equals(operator(), other.operator()) && Objects.equals(createTime(), other.createTime())
                && Objects.equals(recycleBinEnterTime(), other.recycleBinEnterTime())
                && Objects.equals(recycleBinExitTime(), other.recycleBinExitTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VolumeRecycleBinInfo").add("VolumeId", volumeId()).add("VolumeType", volumeTypeAsString())
                .add("State", stateAsString()).add("Size", size()).add("Iops", iops()).add("Throughput", throughput())
                .add("OutpostArn", outpostArn()).add("AvailabilityZone", availabilityZone())
                .add("AvailabilityZoneId", availabilityZoneId()).add("SourceVolumeId", sourceVolumeId())
                .add("SnapshotId", snapshotId()).add("Operator", operator()).add("CreateTime", createTime())
                .add("RecycleBinEnterTime", recycleBinEnterTime()).add("RecycleBinExitTime", recycleBinExitTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VolumeId":
            return Optional.ofNullable(clazz.cast(volumeId()));
        case "VolumeType":
            return Optional.ofNullable(clazz.cast(volumeTypeAsString()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "Size":
            return Optional.ofNullable(clazz.cast(size()));
        case "Iops":
            return Optional.ofNullable(clazz.cast(iops()));
        case "Throughput":
            return Optional.ofNullable(clazz.cast(throughput()));
        case "OutpostArn":
            return Optional.ofNullable(clazz.cast(outpostArn()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "AvailabilityZoneId":
            return Optional.ofNullable(clazz.cast(availabilityZoneId()));
        case "SourceVolumeId":
            return Optional.ofNullable(clazz.cast(sourceVolumeId()));
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        case "Operator":
            return Optional.ofNullable(clazz.cast(operator()));
        case "CreateTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "RecycleBinEnterTime":
            return Optional.ofNullable(clazz.cast(recycleBinEnterTime()));
        case "RecycleBinExitTime":
            return Optional.ofNullable(clazz.cast(recycleBinExitTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VolumeId", VOLUME_ID_FIELD);
        map.put("VolumeType", VOLUME_TYPE_FIELD);
        map.put("State", STATE_FIELD);
        map.put("Size", SIZE_FIELD);
        map.put("Iops", IOPS_FIELD);
        map.put("Throughput", THROUGHPUT_FIELD);
        map.put("OutpostArn", OUTPOST_ARN_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("AvailabilityZoneId", AVAILABILITY_ZONE_ID_FIELD);
        map.put("SourceVolumeId", SOURCE_VOLUME_ID_FIELD);
        map.put("SnapshotId", SNAPSHOT_ID_FIELD);
        map.put("Operator", OPERATOR_FIELD);
        map.put("CreateTime", CREATE_TIME_FIELD);
        map.put("RecycleBinEnterTime", RECYCLE_BIN_ENTER_TIME_FIELD);
        map.put("RecycleBinExitTime", RECYCLE_BIN_EXIT_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VolumeRecycleBinInfo, T> g) {
        return obj -> g.apply((VolumeRecycleBinInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VolumeRecycleBinInfo> {
        /**
         * <p>
         * The ID of the volume.
         * </p>
         * 
         * @param volumeId
         *        The ID of the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeId(String volumeId);

        /**
         * <p>
         * The volume type.
         * </p>
         * 
         * @param volumeType
         *        The volume type.
         * @see VolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeType
         */
        Builder volumeType(String volumeType);

        /**
         * <p>
         * The volume type.
         * </p>
         * 
         * @param volumeType
         *        The volume type.
         * @see VolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeType
         */
        Builder volumeType(VolumeType volumeType);

        /**
         * <p>
         * The state of the volume.
         * </p>
         * 
         * @param state
         *        The state of the volume.
         * @see VolumeState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the volume.
         * </p>
         * 
         * @param state
         *        The state of the volume.
         * @see VolumeState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeState
         */
        Builder state(VolumeState state);

        /**
         * <p>
         * The size of the volume, in GiB.
         * </p>
         * 
         * @param size
         *        The size of the volume, in GiB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(Integer size);

        /**
         * <p>
         * The number of I/O operations per second (IOPS) for the volume.
         * </p>
         * 
         * @param iops
         *        The number of I/O operations per second (IOPS) for the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(Integer iops);

        /**
         * <p>
         * The throughput that the volume supports, in MiB/s.
         * </p>
         * 
         * @param throughput
         *        The throughput that the volume supports, in MiB/s.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder throughput(Integer throughput);

        /**
         * <p>
         * The ARN of the Outpost on which the volume is stored. For more information, see <a
         * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volumes-outposts.html">Amazon EBS volumes on
         * Outposts</a> in the <i>Amazon EBS User Guide</i>.
         * </p>
         * 
         * @param outpostArn
         *        The ARN of the Outpost on which the volume is stored. For more information, see <a
         *        href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volumes-outposts.html">Amazon EBS volumes
         *        on Outposts</a> in the <i>Amazon EBS User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostArn(String outpostArn);

        /**
         * <p>
         * The Availability Zone for the volume.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone for the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The ID of the Availability Zone for the volume.
         * </p>
         * 
         * @param availabilityZoneId
         *        The ID of the Availability Zone for the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneId(String availabilityZoneId);

        /**
         * <p>
         * The ID of the source volume.
         * </p>
         * 
         * @param sourceVolumeId
         *        The ID of the source volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceVolumeId(String sourceVolumeId);

        /**
         * <p>
         * The snapshot from which the volume was created, if applicable.
         * </p>
         * 
         * @param snapshotId
         *        The snapshot from which the volume was created, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * The service provider that manages the volume.
         * </p>
         * 
         * @param operator
         *        The service provider that manages the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operator(OperatorResponse operator);

        /**
         * <p>
         * The service provider that manages the volume.
         * </p>
         * This is a convenience method that creates an instance of the {@link OperatorResponse.Builder} avoiding the
         * need to create one manually via {@link OperatorResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OperatorResponse.Builder#build()} is called immediately and its
         * result is passed to {@link #operator(OperatorResponse)}.
         * 
         * @param operator
         *        a consumer that will call methods on {@link OperatorResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #operator(OperatorResponse)
         */
        default Builder operator(Consumer<OperatorResponse.Builder> operator) {
            return operator(OperatorResponse.builder().applyMutation(operator).build());
        }

        /**
         * <p>
         * The time stamp when volume creation was initiated.
         * </p>
         * 
         * @param createTime
         *        The time stamp when volume creation was initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The date and time when the volume entered the Recycle Bin.
         * </p>
         * 
         * @param recycleBinEnterTime
         *        The date and time when the volume entered the Recycle Bin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recycleBinEnterTime(Instant recycleBinEnterTime);

        /**
         * <p>
         * The date and time when the volume is to be permanently deleted from the Recycle Bin.
         * </p>
         * 
         * @param recycleBinExitTime
         *        The date and time when the volume is to be permanently deleted from the Recycle Bin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recycleBinExitTime(Instant recycleBinExitTime);
    }

    static final class BuilderImpl implements Builder {
        private String volumeId;

        private String volumeType;

        private String state;

        private Integer size;

        private Integer iops;

        private Integer throughput;

        private String outpostArn;

        private String availabilityZone;

        private String availabilityZoneId;

        private String sourceVolumeId;

        private String snapshotId;

        private OperatorResponse operator;

        private Instant createTime;

        private Instant recycleBinEnterTime;

        private Instant recycleBinExitTime;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeRecycleBinInfo model) {
            volumeId(model.volumeId);
            volumeType(model.volumeType);
            state(model.state);
            size(model.size);
            iops(model.iops);
            throughput(model.throughput);
            outpostArn(model.outpostArn);
            availabilityZone(model.availabilityZone);
            availabilityZoneId(model.availabilityZoneId);
            sourceVolumeId(model.sourceVolumeId);
            snapshotId(model.snapshotId);
            operator(model.operator);
            createTime(model.createTime);
            recycleBinEnterTime(model.recycleBinEnterTime);
            recycleBinExitTime(model.recycleBinExitTime);
        }

        public final String getVolumeId() {
            return volumeId;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final String getVolumeType() {
            return volumeType;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        @Override
        public final Builder volumeType(VolumeType volumeType) {
            this.volumeType(volumeType == null ? null : volumeType.toString());
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(VolumeState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Integer getSize() {
            return size;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final Integer getIops() {
            return iops;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final Integer getThroughput() {
            return throughput;
        }

        public final void setThroughput(Integer throughput) {
            this.throughput = throughput;
        }

        @Override
        public final Builder throughput(Integer throughput) {
            this.throughput = throughput;
            return this;
        }

        public final String getOutpostArn() {
            return outpostArn;
        }

        public final void setOutpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
        }

        @Override
        public final Builder outpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getAvailabilityZoneId() {
            return availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final String getSourceVolumeId() {
            return sourceVolumeId;
        }

        public final void setSourceVolumeId(String sourceVolumeId) {
            this.sourceVolumeId = sourceVolumeId;
        }

        @Override
        public final Builder sourceVolumeId(String sourceVolumeId) {
            this.sourceVolumeId = sourceVolumeId;
            return this;
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final OperatorResponse.Builder getOperator() {
            return operator != null ? operator.toBuilder() : null;
        }

        public final void setOperator(OperatorResponse.BuilderImpl operator) {
            this.operator = operator != null ? operator.build() : null;
        }

        @Override
        public final Builder operator(OperatorResponse operator) {
            this.operator = operator;
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getRecycleBinEnterTime() {
            return recycleBinEnterTime;
        }

        public final void setRecycleBinEnterTime(Instant recycleBinEnterTime) {
            this.recycleBinEnterTime = recycleBinEnterTime;
        }

        @Override
        public final Builder recycleBinEnterTime(Instant recycleBinEnterTime) {
            this.recycleBinEnterTime = recycleBinEnterTime;
            return this;
        }

        public final Instant getRecycleBinExitTime() {
            return recycleBinExitTime;
        }

        public final void setRecycleBinExitTime(Instant recycleBinExitTime) {
            this.recycleBinExitTime = recycleBinExitTime;
        }

        @Override
        public final Builder recycleBinExitTime(Instant recycleBinExitTime) {
            this.recycleBinExitTime = recycleBinExitTime;
            return this;
        }

        @Override
        public VolumeRecycleBinInfo build() {
            return new VolumeRecycleBinInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
