/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The disk container object for the import snapshot request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SnapshotDiskContainer implements SdkPojo, Serializable,
        ToCopyableBuilder<SnapshotDiskContainer.Builder, SnapshotDiskContainer> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(SnapshotDiskContainer::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("Description").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Format")
            .getter(getter(SnapshotDiskContainer::format))
            .setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format")
                    .unmarshallLocationName("Format").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Url")
            .getter(getter(SnapshotDiskContainer::url))
            .setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").unmarshallLocationName("Url")
                    .build()).build();

    private static final SdkField<UserBucket> USER_BUCKET_FIELD = SdkField
            .<UserBucket> builder(MarshallingType.SDK_POJO)
            .memberName("UserBucket")
            .getter(getter(SnapshotDiskContainer::userBucket))
            .setter(setter(Builder::userBucket))
            .constructor(UserBucket::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserBucket")
                    .unmarshallLocationName("UserBucket").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            FORMAT_FIELD, URL_FIELD, USER_BUCKET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String description;

    private final String format;

    private final String url;

    private final UserBucket userBucket;

    private SnapshotDiskContainer(BuilderImpl builder) {
        this.description = builder.description;
        this.format = builder.format;
        this.url = builder.url;
        this.userBucket = builder.userBucket;
    }

    /**
     * <p>
     * The description of the disk image being imported.
     * </p>
     * 
     * @return The description of the disk image being imported.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The format of the disk image being imported.
     * </p>
     * <p>
     * Valid values: <code>VHD</code> | <code>VMDK</code> | <code>RAW</code>
     * </p>
     * 
     * @return The format of the disk image being imported.</p>
     *         <p>
     *         Valid values: <code>VHD</code> | <code>VMDK</code> | <code>RAW</code>
     */
    public final String format() {
        return format;
    }

    /**
     * <p>
     * The URL to the Amazon S3-based disk image being imported. It can either be a https URL (https://..) or an Amazon
     * S3 URL (s3://..).
     * </p>
     * 
     * @return The URL to the Amazon S3-based disk image being imported. It can either be a https URL (https://..) or an
     *         Amazon S3 URL (s3://..).
     */
    public final String url() {
        return url;
    }

    /**
     * <p>
     * The Amazon S3 bucket for the disk image.
     * </p>
     * 
     * @return The Amazon S3 bucket for the disk image.
     */
    public final UserBucket userBucket() {
        return userBucket;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(format());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(userBucket());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapshotDiskContainer)) {
            return false;
        }
        SnapshotDiskContainer other = (SnapshotDiskContainer) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(format(), other.format())
                && Objects.equals(url(), other.url()) && Objects.equals(userBucket(), other.userBucket());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SnapshotDiskContainer").add("Description", description()).add("Format", format())
                .add("Url", url() == null ? null : "*** Sensitive Data Redacted ***").add("UserBucket", userBucket()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Format":
            return Optional.ofNullable(clazz.cast(format()));
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        case "UserBucket":
            return Optional.ofNullable(clazz.cast(userBucket()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Format", FORMAT_FIELD);
        map.put("Url", URL_FIELD);
        map.put("UserBucket", USER_BUCKET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SnapshotDiskContainer, T> g) {
        return obj -> g.apply((SnapshotDiskContainer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SnapshotDiskContainer> {
        /**
         * <p>
         * The description of the disk image being imported.
         * </p>
         * 
         * @param description
         *        The description of the disk image being imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The format of the disk image being imported.
         * </p>
         * <p>
         * Valid values: <code>VHD</code> | <code>VMDK</code> | <code>RAW</code>
         * </p>
         * 
         * @param format
         *        The format of the disk image being imported.</p>
         *        <p>
         *        Valid values: <code>VHD</code> | <code>VMDK</code> | <code>RAW</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder format(String format);

        /**
         * <p>
         * The URL to the Amazon S3-based disk image being imported. It can either be a https URL (https://..) or an
         * Amazon S3 URL (s3://..).
         * </p>
         * 
         * @param url
         *        The URL to the Amazon S3-based disk image being imported. It can either be a https URL (https://..) or
         *        an Amazon S3 URL (s3://..).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * <p>
         * The Amazon S3 bucket for the disk image.
         * </p>
         * 
         * @param userBucket
         *        The Amazon S3 bucket for the disk image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userBucket(UserBucket userBucket);

        /**
         * <p>
         * The Amazon S3 bucket for the disk image.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserBucket.Builder} avoiding the need to
         * create one manually via {@link UserBucket#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserBucket.Builder#build()} is called immediately and its result
         * is passed to {@link #userBucket(UserBucket)}.
         * 
         * @param userBucket
         *        a consumer that will call methods on {@link UserBucket.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userBucket(UserBucket)
         */
        default Builder userBucket(Consumer<UserBucket.Builder> userBucket) {
            return userBucket(UserBucket.builder().applyMutation(userBucket).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private String format;

        private String url;

        private UserBucket userBucket;

        private BuilderImpl() {
        }

        private BuilderImpl(SnapshotDiskContainer model) {
            description(model.description);
            format(model.format);
            url(model.url);
            userBucket(model.userBucket);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        public final String getUrl() {
            return url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final UserBucket.Builder getUserBucket() {
            return userBucket != null ? userBucket.toBuilder() : null;
        }

        public final void setUserBucket(UserBucket.BuilderImpl userBucket) {
            this.userBucket = userBucket != null ? userBucket.build() : null;
        }

        @Override
        public final Builder userBucket(UserBucket userBucket) {
            this.userBucket = userBucket;
            return this;
        }

        @Override
        public SnapshotDiskContainer build() {
            return new SnapshotDiskContainer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
