/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the price for a Reserved Instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PriceSchedule implements SdkPojo, Serializable, ToCopyableBuilder<PriceSchedule.Builder, PriceSchedule> {
    private static final SdkField<Boolean> ACTIVE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Active")
            .getter(getter(PriceSchedule::active))
            .setter(setter(Builder::active))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Active")
                    .unmarshallLocationName("active").build()).build();

    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CurrencyCode")
            .getter(getter(PriceSchedule::currencyCodeAsString))
            .setter(setter(Builder::currencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode")
                    .unmarshallLocationName("currencyCode").build()).build();

    private static final SdkField<Double> PRICE_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("Price")
            .getter(getter(PriceSchedule::price))
            .setter(setter(Builder::price))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Price")
                    .unmarshallLocationName("price").build()).build();

    private static final SdkField<Long> TERM_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("Term")
            .getter(getter(PriceSchedule::term))
            .setter(setter(Builder::term))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Term")
                    .unmarshallLocationName("term").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_FIELD,
            CURRENCY_CODE_FIELD, PRICE_FIELD, TERM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean active;

    private final String currencyCode;

    private final Double price;

    private final Long term;

    private PriceSchedule(BuilderImpl builder) {
        this.active = builder.active;
        this.currencyCode = builder.currencyCode;
        this.price = builder.price;
        this.term = builder.term;
    }

    /**
     * <p>
     * The current price schedule, as determined by the term remaining for the Reserved Instance in the listing.
     * </p>
     * <p>
     * A specific price schedule is always in effect, but only one price schedule can be active at any time. Take, for
     * example, a Reserved Instance listing that has five months remaining in its term. When you specify price schedules
     * for five months and two months, this means that schedule 1, covering the first three months of the remaining
     * term, will be active during months 5, 4, and 3. Then schedule 2, covering the last two months of the term, will
     * be active for months 2 and 1.
     * </p>
     * 
     * @return The current price schedule, as determined by the term remaining for the Reserved Instance in the
     *         listing.</p>
     *         <p>
     *         A specific price schedule is always in effect, but only one price schedule can be active at any time.
     *         Take, for example, a Reserved Instance listing that has five months remaining in its term. When you
     *         specify price schedules for five months and two months, this means that schedule 1, covering the first
     *         three months of the remaining term, will be active during months 5, 4, and 3. Then schedule 2, covering
     *         the last two months of the term, will be active for months 2 and 1.
     */
    public final Boolean active() {
        return active;
    }

    /**
     * <p>
     * The currency for transacting the Reserved Instance resale. At this time, the only supported currency is
     * <code>USD</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currencyCode} will
     * return {@link CurrencyCodeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyCodeAsString}.
     * </p>
     * 
     * @return The currency for transacting the Reserved Instance resale. At this time, the only supported currency is
     *         <code>USD</code>.
     * @see CurrencyCodeValues
     */
    public final CurrencyCodeValues currencyCode() {
        return CurrencyCodeValues.fromValue(currencyCode);
    }

    /**
     * <p>
     * The currency for transacting the Reserved Instance resale. At this time, the only supported currency is
     * <code>USD</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currencyCode} will
     * return {@link CurrencyCodeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyCodeAsString}.
     * </p>
     * 
     * @return The currency for transacting the Reserved Instance resale. At this time, the only supported currency is
     *         <code>USD</code>.
     * @see CurrencyCodeValues
     */
    public final String currencyCodeAsString() {
        return currencyCode;
    }

    /**
     * <p>
     * The fixed price for the term.
     * </p>
     * 
     * @return The fixed price for the term.
     */
    public final Double price() {
        return price;
    }

    /**
     * <p>
     * The number of months remaining in the reservation. For example, 2 is the second to the last month before the
     * capacity reservation expires.
     * </p>
     * 
     * @return The number of months remaining in the reservation. For example, 2 is the second to the last month before
     *         the capacity reservation expires.
     */
    public final Long term() {
        return term;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(active());
        hashCode = 31 * hashCode + Objects.hashCode(currencyCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(price());
        hashCode = 31 * hashCode + Objects.hashCode(term());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PriceSchedule)) {
            return false;
        }
        PriceSchedule other = (PriceSchedule) obj;
        return Objects.equals(active(), other.active()) && Objects.equals(currencyCodeAsString(), other.currencyCodeAsString())
                && Objects.equals(price(), other.price()) && Objects.equals(term(), other.term());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PriceSchedule").add("Active", active()).add("CurrencyCode", currencyCodeAsString())
                .add("Price", price()).add("Term", term()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Active":
            return Optional.ofNullable(clazz.cast(active()));
        case "CurrencyCode":
            return Optional.ofNullable(clazz.cast(currencyCodeAsString()));
        case "Price":
            return Optional.ofNullable(clazz.cast(price()));
        case "Term":
            return Optional.ofNullable(clazz.cast(term()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Active", ACTIVE_FIELD);
        map.put("CurrencyCode", CURRENCY_CODE_FIELD);
        map.put("Price", PRICE_FIELD);
        map.put("Term", TERM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PriceSchedule, T> g) {
        return obj -> g.apply((PriceSchedule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PriceSchedule> {
        /**
         * <p>
         * The current price schedule, as determined by the term remaining for the Reserved Instance in the listing.
         * </p>
         * <p>
         * A specific price schedule is always in effect, but only one price schedule can be active at any time. Take,
         * for example, a Reserved Instance listing that has five months remaining in its term. When you specify price
         * schedules for five months and two months, this means that schedule 1, covering the first three months of the
         * remaining term, will be active during months 5, 4, and 3. Then schedule 2, covering the last two months of
         * the term, will be active for months 2 and 1.
         * </p>
         * 
         * @param active
         *        The current price schedule, as determined by the term remaining for the Reserved Instance in the
         *        listing.</p>
         *        <p>
         *        A specific price schedule is always in effect, but only one price schedule can be active at any time.
         *        Take, for example, a Reserved Instance listing that has five months remaining in its term. When you
         *        specify price schedules for five months and two months, this means that schedule 1, covering the first
         *        three months of the remaining term, will be active during months 5, 4, and 3. Then schedule 2,
         *        covering the last two months of the term, will be active for months 2 and 1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder active(Boolean active);

        /**
         * <p>
         * The currency for transacting the Reserved Instance resale. At this time, the only supported currency is
         * <code>USD</code>.
         * </p>
         * 
         * @param currencyCode
         *        The currency for transacting the Reserved Instance resale. At this time, the only supported currency
         *        is <code>USD</code>.
         * @see CurrencyCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCodeValues
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * The currency for transacting the Reserved Instance resale. At this time, the only supported currency is
         * <code>USD</code>.
         * </p>
         * 
         * @param currencyCode
         *        The currency for transacting the Reserved Instance resale. At this time, the only supported currency
         *        is <code>USD</code>.
         * @see CurrencyCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCodeValues
         */
        Builder currencyCode(CurrencyCodeValues currencyCode);

        /**
         * <p>
         * The fixed price for the term.
         * </p>
         * 
         * @param price
         *        The fixed price for the term.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder price(Double price);

        /**
         * <p>
         * The number of months remaining in the reservation. For example, 2 is the second to the last month before the
         * capacity reservation expires.
         * </p>
         * 
         * @param term
         *        The number of months remaining in the reservation. For example, 2 is the second to the last month
         *        before the capacity reservation expires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder term(Long term);
    }

    static final class BuilderImpl implements Builder {
        private Boolean active;

        private String currencyCode;

        private Double price;

        private Long term;

        private BuilderImpl() {
        }

        private BuilderImpl(PriceSchedule model) {
            active(model.active);
            currencyCode(model.currencyCode);
            price(model.price);
            term(model.term);
        }

        public final Boolean getActive() {
            return active;
        }

        public final void setActive(Boolean active) {
            this.active = active;
        }

        @Override
        public final Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode == null ? null : currencyCode.toString());
            return this;
        }

        public final Double getPrice() {
            return price;
        }

        public final void setPrice(Double price) {
            this.price = price;
        }

        @Override
        public final Builder price(Double price) {
            this.price = price;
            return this;
        }

        public final Long getTerm() {
            return term;
        }

        public final void setTerm(Long term) {
            this.term = term;
        }

        @Override
        public final Builder term(Long term) {
            this.term = term;
            return this;
        }

        @Override
        public PriceSchedule build() {
            return new PriceSchedule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
