/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an attachment change.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkInterfaceAttachmentChanges implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkInterfaceAttachmentChanges.Builder, NetworkInterfaceAttachmentChanges> {
    private static final SdkField<Boolean> DEFAULT_ENA_QUEUE_COUNT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DefaultEnaQueueCount")
            .getter(getter(NetworkInterfaceAttachmentChanges::defaultEnaQueueCount))
            .setter(setter(Builder::defaultEnaQueueCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultEnaQueueCount")
                    .unmarshallLocationName("DefaultEnaQueueCount").build()).build();

    private static final SdkField<Integer> ENA_QUEUE_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("EnaQueueCount")
            .getter(getter(NetworkInterfaceAttachmentChanges::enaQueueCount))
            .setter(setter(Builder::enaQueueCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnaQueueCount")
                    .unmarshallLocationName("EnaQueueCount").build()).build();

    private static final SdkField<String> ATTACHMENT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AttachmentId")
            .getter(getter(NetworkInterfaceAttachmentChanges::attachmentId))
            .setter(setter(Builder::attachmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentId")
                    .unmarshallLocationName("attachmentId").build()).build();

    private static final SdkField<Boolean> DELETE_ON_TERMINATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeleteOnTermination")
            .getter(getter(NetworkInterfaceAttachmentChanges::deleteOnTermination))
            .setter(setter(Builder::deleteOnTermination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteOnTermination")
                    .unmarshallLocationName("deleteOnTermination").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_ENA_QUEUE_COUNT_FIELD,
            ENA_QUEUE_COUNT_FIELD, ATTACHMENT_ID_FIELD, DELETE_ON_TERMINATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean defaultEnaQueueCount;

    private final Integer enaQueueCount;

    private final String attachmentId;

    private final Boolean deleteOnTermination;

    private NetworkInterfaceAttachmentChanges(BuilderImpl builder) {
        this.defaultEnaQueueCount = builder.defaultEnaQueueCount;
        this.enaQueueCount = builder.enaQueueCount;
        this.attachmentId = builder.attachmentId;
        this.deleteOnTermination = builder.deleteOnTermination;
    }

    /**
     * <p>
     * The default number of the ENA queues.
     * </p>
     * 
     * @return The default number of the ENA queues.
     */
    public final Boolean defaultEnaQueueCount() {
        return defaultEnaQueueCount;
    }

    /**
     * <p>
     * The number of ENA queues to be created with the instance.
     * </p>
     * 
     * @return The number of ENA queues to be created with the instance.
     */
    public final Integer enaQueueCount() {
        return enaQueueCount;
    }

    /**
     * <p>
     * The ID of the network interface attachment.
     * </p>
     * 
     * @return The ID of the network interface attachment.
     */
    public final String attachmentId() {
        return attachmentId;
    }

    /**
     * <p>
     * Indicates whether the network interface is deleted when the instance is terminated.
     * </p>
     * 
     * @return Indicates whether the network interface is deleted when the instance is terminated.
     */
    public final Boolean deleteOnTermination() {
        return deleteOnTermination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(defaultEnaQueueCount());
        hashCode = 31 * hashCode + Objects.hashCode(enaQueueCount());
        hashCode = 31 * hashCode + Objects.hashCode(attachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(deleteOnTermination());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInterfaceAttachmentChanges)) {
            return false;
        }
        NetworkInterfaceAttachmentChanges other = (NetworkInterfaceAttachmentChanges) obj;
        return Objects.equals(defaultEnaQueueCount(), other.defaultEnaQueueCount())
                && Objects.equals(enaQueueCount(), other.enaQueueCount()) && Objects.equals(attachmentId(), other.attachmentId())
                && Objects.equals(deleteOnTermination(), other.deleteOnTermination());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkInterfaceAttachmentChanges").add("DefaultEnaQueueCount", defaultEnaQueueCount())
                .add("EnaQueueCount", enaQueueCount()).add("AttachmentId", attachmentId())
                .add("DeleteOnTermination", deleteOnTermination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DefaultEnaQueueCount":
            return Optional.ofNullable(clazz.cast(defaultEnaQueueCount()));
        case "EnaQueueCount":
            return Optional.ofNullable(clazz.cast(enaQueueCount()));
        case "AttachmentId":
            return Optional.ofNullable(clazz.cast(attachmentId()));
        case "DeleteOnTermination":
            return Optional.ofNullable(clazz.cast(deleteOnTermination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DefaultEnaQueueCount", DEFAULT_ENA_QUEUE_COUNT_FIELD);
        map.put("EnaQueueCount", ENA_QUEUE_COUNT_FIELD);
        map.put("AttachmentId", ATTACHMENT_ID_FIELD);
        map.put("DeleteOnTermination", DELETE_ON_TERMINATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkInterfaceAttachmentChanges, T> g) {
        return obj -> g.apply((NetworkInterfaceAttachmentChanges) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkInterfaceAttachmentChanges> {
        /**
         * <p>
         * The default number of the ENA queues.
         * </p>
         * 
         * @param defaultEnaQueueCount
         *        The default number of the ENA queues.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultEnaQueueCount(Boolean defaultEnaQueueCount);

        /**
         * <p>
         * The number of ENA queues to be created with the instance.
         * </p>
         * 
         * @param enaQueueCount
         *        The number of ENA queues to be created with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enaQueueCount(Integer enaQueueCount);

        /**
         * <p>
         * The ID of the network interface attachment.
         * </p>
         * 
         * @param attachmentId
         *        The ID of the network interface attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentId(String attachmentId);

        /**
         * <p>
         * Indicates whether the network interface is deleted when the instance is terminated.
         * </p>
         * 
         * @param deleteOnTermination
         *        Indicates whether the network interface is deleted when the instance is terminated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteOnTermination(Boolean deleteOnTermination);
    }

    static final class BuilderImpl implements Builder {
        private Boolean defaultEnaQueueCount;

        private Integer enaQueueCount;

        private String attachmentId;

        private Boolean deleteOnTermination;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInterfaceAttachmentChanges model) {
            defaultEnaQueueCount(model.defaultEnaQueueCount);
            enaQueueCount(model.enaQueueCount);
            attachmentId(model.attachmentId);
            deleteOnTermination(model.deleteOnTermination);
        }

        public final Boolean getDefaultEnaQueueCount() {
            return defaultEnaQueueCount;
        }

        public final void setDefaultEnaQueueCount(Boolean defaultEnaQueueCount) {
            this.defaultEnaQueueCount = defaultEnaQueueCount;
        }

        @Override
        public final Builder defaultEnaQueueCount(Boolean defaultEnaQueueCount) {
            this.defaultEnaQueueCount = defaultEnaQueueCount;
            return this;
        }

        public final Integer getEnaQueueCount() {
            return enaQueueCount;
        }

        public final void setEnaQueueCount(Integer enaQueueCount) {
            this.enaQueueCount = enaQueueCount;
        }

        @Override
        public final Builder enaQueueCount(Integer enaQueueCount) {
            this.enaQueueCount = enaQueueCount;
            return this;
        }

        public final String getAttachmentId() {
            return attachmentId;
        }

        public final void setAttachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
        }

        @Override
        public final Builder attachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        public final Boolean getDeleteOnTermination() {
            return deleteOnTermination;
        }

        public final void setDeleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        @Override
        public final Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        @Override
        public NetworkInterfaceAttachmentChanges build() {
            return new NetworkInterfaceAttachmentChanges(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
