/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSnapshotBlockPublicAccessStateResponse extends Ec2Response implements
        ToCopyableBuilder<GetSnapshotBlockPublicAccessStateResponse.Builder, GetSnapshotBlockPublicAccessStateResponse> {
    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(GetSnapshotBlockPublicAccessStateResponse::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<String> MANAGED_BY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ManagedBy")
            .getter(getter(GetSnapshotBlockPublicAccessStateResponse::managedByAsString))
            .setter(setter(Builder::managedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedBy")
                    .unmarshallLocationName("managedBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(STATE_FIELD, MANAGED_BY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String state;

    private final String managedBy;

    private GetSnapshotBlockPublicAccessStateResponse(BuilderImpl builder) {
        super(builder);
        this.state = builder.state;
        this.managedBy = builder.managedBy;
    }

    /**
     * <p>
     * The current state of block public access for snapshots. Possible values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>block-all-sharing</code> - All public sharing of snapshots is blocked. Users in the account can't request
     * new public sharing. Additionally, snapshots that were already publicly shared are treated as private and are not
     * publicly available.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>block-new-sharing</code> - Only new public sharing of snapshots is blocked. Users in the account can't
     * request new public sharing. However, snapshots that were already publicly shared, remain publicly available.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>unblocked</code> - Public sharing is not blocked. Users can publicly share snapshots.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link SnapshotBlockPublicAccessState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of block public access for snapshots. Possible values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>block-all-sharing</code> - All public sharing of snapshots is blocked. Users in the account can't
     *         request new public sharing. Additionally, snapshots that were already publicly shared are treated as
     *         private and are not publicly available.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>block-new-sharing</code> - Only new public sharing of snapshots is blocked. Users in the account
     *         can't request new public sharing. However, snapshots that were already publicly shared, remain publicly
     *         available.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>unblocked</code> - Public sharing is not blocked. Users can publicly share snapshots.
     *         </p>
     *         </li>
     * @see SnapshotBlockPublicAccessState
     */
    public final SnapshotBlockPublicAccessState state() {
        return SnapshotBlockPublicAccessState.fromValue(state);
    }

    /**
     * <p>
     * The current state of block public access for snapshots. Possible values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>block-all-sharing</code> - All public sharing of snapshots is blocked. Users in the account can't request
     * new public sharing. Additionally, snapshots that were already publicly shared are treated as private and are not
     * publicly available.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>block-new-sharing</code> - Only new public sharing of snapshots is blocked. Users in the account can't
     * request new public sharing. However, snapshots that were already publicly shared, remain publicly available.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>unblocked</code> - Public sharing is not blocked. Users can publicly share snapshots.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link SnapshotBlockPublicAccessState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of block public access for snapshots. Possible values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>block-all-sharing</code> - All public sharing of snapshots is blocked. Users in the account can't
     *         request new public sharing. Additionally, snapshots that were already publicly shared are treated as
     *         private and are not publicly available.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>block-new-sharing</code> - Only new public sharing of snapshots is blocked. Users in the account
     *         can't request new public sharing. However, snapshots that were already publicly shared, remain publicly
     *         available.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>unblocked</code> - Public sharing is not blocked. Users can publicly share snapshots.
     *         </p>
     *         </li>
     * @see SnapshotBlockPublicAccessState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The entity that manages the state for block public access for snapshots. Possible values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>account</code> - The state is managed by the account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>declarative-policy</code> - The state is managed by a declarative policy and can't be modified by the
     * account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #managedBy} will
     * return {@link ManagedBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #managedByAsString}.
     * </p>
     * 
     * @return The entity that manages the state for block public access for snapshots. Possible values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>account</code> - The state is managed by the account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>declarative-policy</code> - The state is managed by a declarative policy and can't be modified by
     *         the account.
     *         </p>
     *         </li>
     * @see ManagedBy
     */
    public final ManagedBy managedBy() {
        return ManagedBy.fromValue(managedBy);
    }

    /**
     * <p>
     * The entity that manages the state for block public access for snapshots. Possible values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>account</code> - The state is managed by the account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>declarative-policy</code> - The state is managed by a declarative policy and can't be modified by the
     * account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #managedBy} will
     * return {@link ManagedBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #managedByAsString}.
     * </p>
     * 
     * @return The entity that manages the state for block public access for snapshots. Possible values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>account</code> - The state is managed by the account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>declarative-policy</code> - The state is managed by a declarative policy and can't be modified by
     *         the account.
     *         </p>
     *         </li>
     * @see ManagedBy
     */
    public final String managedByAsString() {
        return managedBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(managedByAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSnapshotBlockPublicAccessStateResponse)) {
            return false;
        }
        GetSnapshotBlockPublicAccessStateResponse other = (GetSnapshotBlockPublicAccessStateResponse) obj;
        return Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(managedByAsString(), other.managedByAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSnapshotBlockPublicAccessStateResponse").add("State", stateAsString())
                .add("ManagedBy", managedByAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "ManagedBy":
            return Optional.ofNullable(clazz.cast(managedByAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("State", STATE_FIELD);
        map.put("ManagedBy", MANAGED_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSnapshotBlockPublicAccessStateResponse, T> g) {
        return obj -> g.apply((GetSnapshotBlockPublicAccessStateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, GetSnapshotBlockPublicAccessStateResponse> {
        /**
         * <p>
         * The current state of block public access for snapshots. Possible values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>block-all-sharing</code> - All public sharing of snapshots is blocked. Users in the account can't
         * request new public sharing. Additionally, snapshots that were already publicly shared are treated as private
         * and are not publicly available.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-new-sharing</code> - Only new public sharing of snapshots is blocked. Users in the account can't
         * request new public sharing. However, snapshots that were already publicly shared, remain publicly available.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>unblocked</code> - Public sharing is not blocked. Users can publicly share snapshots.
         * </p>
         * </li>
         * </ul>
         * 
         * @param state
         *        The current state of block public access for snapshots. Possible values include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>block-all-sharing</code> - All public sharing of snapshots is blocked. Users in the account
         *        can't request new public sharing. Additionally, snapshots that were already publicly shared are
         *        treated as private and are not publicly available.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-new-sharing</code> - Only new public sharing of snapshots is blocked. Users in the account
         *        can't request new public sharing. However, snapshots that were already publicly shared, remain
         *        publicly available.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>unblocked</code> - Public sharing is not blocked. Users can publicly share snapshots.
         *        </p>
         *        </li>
         * @see SnapshotBlockPublicAccessState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapshotBlockPublicAccessState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of block public access for snapshots. Possible values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>block-all-sharing</code> - All public sharing of snapshots is blocked. Users in the account can't
         * request new public sharing. Additionally, snapshots that were already publicly shared are treated as private
         * and are not publicly available.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-new-sharing</code> - Only new public sharing of snapshots is blocked. Users in the account can't
         * request new public sharing. However, snapshots that were already publicly shared, remain publicly available.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>unblocked</code> - Public sharing is not blocked. Users can publicly share snapshots.
         * </p>
         * </li>
         * </ul>
         * 
         * @param state
         *        The current state of block public access for snapshots. Possible values include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>block-all-sharing</code> - All public sharing of snapshots is blocked. Users in the account
         *        can't request new public sharing. Additionally, snapshots that were already publicly shared are
         *        treated as private and are not publicly available.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-new-sharing</code> - Only new public sharing of snapshots is blocked. Users in the account
         *        can't request new public sharing. However, snapshots that were already publicly shared, remain
         *        publicly available.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>unblocked</code> - Public sharing is not blocked. Users can publicly share snapshots.
         *        </p>
         *        </li>
         * @see SnapshotBlockPublicAccessState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapshotBlockPublicAccessState
         */
        Builder state(SnapshotBlockPublicAccessState state);

        /**
         * <p>
         * The entity that manages the state for block public access for snapshots. Possible values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>account</code> - The state is managed by the account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>declarative-policy</code> - The state is managed by a declarative policy and can't be modified by the
         * account.
         * </p>
         * </li>
         * </ul>
         * 
         * @param managedBy
         *        The entity that manages the state for block public access for snapshots. Possible values include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>account</code> - The state is managed by the account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>declarative-policy</code> - The state is managed by a declarative policy and can't be modified
         *        by the account.
         *        </p>
         *        </li>
         * @see ManagedBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManagedBy
         */
        Builder managedBy(String managedBy);

        /**
         * <p>
         * The entity that manages the state for block public access for snapshots. Possible values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>account</code> - The state is managed by the account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>declarative-policy</code> - The state is managed by a declarative policy and can't be modified by the
         * account.
         * </p>
         * </li>
         * </ul>
         * 
         * @param managedBy
         *        The entity that manages the state for block public access for snapshots. Possible values include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>account</code> - The state is managed by the account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>declarative-policy</code> - The state is managed by a declarative policy and can't be modified
         *        by the account.
         *        </p>
         *        </li>
         * @see ManagedBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManagedBy
         */
        Builder managedBy(ManagedBy managedBy);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String state;

        private String managedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSnapshotBlockPublicAccessStateResponse model) {
            super(model);
            state(model.state);
            managedBy(model.managedBy);
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(SnapshotBlockPublicAccessState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getManagedBy() {
            return managedBy;
        }

        public final void setManagedBy(String managedBy) {
            this.managedBy = managedBy;
        }

        @Override
        public final Builder managedBy(String managedBy) {
            this.managedBy = managedBy;
            return this;
        }

        @Override
        public final Builder managedBy(ManagedBy managedBy) {
            this.managedBy(managedBy == null ? null : managedBy.toString());
            return this;
        }

        @Override
        public GetSnapshotBlockPublicAccessStateResponse build() {
            return new GetSnapshotBlockPublicAccessStateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
